/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.helpers;

import com.pixelmonmod.pixelmon.AI.AIFlying;
import com.pixelmonmod.pixelmon.AI.AIFlyingPersistent;
import com.pixelmonmod.pixelmon.AI.AIIsInBattle;
import com.pixelmonmod.pixelmon.AI.AIMoveTowardsBlock;
import com.pixelmonmod.pixelmon.AI.AIMoveTowardsTarget;
import com.pixelmonmod.pixelmon.AI.AIStartBattle;
import com.pixelmonmod.pixelmon.AI.AISwimming;
import com.pixelmonmod.pixelmon.AI.AITargetNearest;
import com.pixelmonmod.pixelmon.AI.AITeleportAway;
import com.pixelmonmod.pixelmon.AI.AITempt;
import com.pixelmonmod.pixelmon.AI.AIWander;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity7HasAI;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;

public class AIHelper {
    int i = 0;

    public AIHelper(String name, Entity7HasAI entity, EntityAITasks tasks) {
        EntityPixelmon pix = (EntityPixelmon)entity;
        if (tasks.field_75782_a.size() != 0) {
            tasks.field_75782_a.clear();
        }
        this.initBaseAI(pix, tasks);
        if (pix.getSpawnLocation() == SpawnLocation.Land && !entity.baseStats.canFly && (!entity.baseStats.isRideable || entity.baseStats.type1 != EnumType.Water && entity.baseStats.type2 != EnumType.Water)) {
            this.initGroundAI(name, pix, tasks);
        } else if (entity.baseStats.canFly) {
            if (pix.getSpawnLocation() == SpawnLocation.AirPersistent) {
                this.initFlyingPersistentAI(name, pix, tasks);
            } else {
                this.initFlyingAI(name, pix, tasks);
            }
        } else if (pix.getSpawnLocation() == SpawnLocation.Water) {
            this.initSwimmingAI(name, pix, tasks);
        }
    }

    private void initFlyingPersistentAI(String name, EntityPixelmon entity, EntityAITasks tasks) {
        if (!entity.isInRanchBlock) {
            tasks.func_75776_a(this.i++, (EntityAIBase)new AITempt((EntityCreature)entity, PixelmonItems.rareCandy, false));
        }
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIFlyingPersistent(entity));
    }

    private void initSwimmingAI(String name, EntityPixelmon entity, EntityAITasks tasks) {
        if (!entity.isInRanchBlock) {
            tasks.func_75776_a(this.i++, (EntityAIBase)new AITempt((EntityCreature)entity, PixelmonItems.rareCandy, false));
        }
        tasks.func_75776_a(this.i++, (EntityAIBase)new AISwimming(entity));
    }

    private void initFlyingAI(String name, EntityPixelmon entity, EntityAITasks tasks) {
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAISwimming((EntityLiving)entity));
        if (!entity.isInRanchBlock) {
            tasks.func_75776_a(this.i++, (EntityAIBase)new AITempt((EntityCreature)entity, PixelmonItems.rareCandy, false));
        }
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)entity, EntityPixelmon.class, 8.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIFlying(entity));
    }

    private void initBaseAI(EntityPixelmon entity, EntityAITasks tasks) {
        if (!entity.isInRanchBlock) {
            tasks.func_75776_a(this.i++, (EntityAIBase)new AIIsInBattle(entity));
            tasks.func_75776_a(this.i++, (EntityAIBase)new AIMoveTowardsTarget((EntityCreature)entity, 15.0f));
            tasks.func_75776_a(this.i++, (EntityAIBase)new AIStartBattle((EntityCreature)entity));
            if (entity.getSpawnLocation() != SpawnLocation.Water && (!entity.baseStats.isRideable || entity.baseStats.type1 != EnumType.Water && entity.baseStats.type2 != EnumType.Water)) {
                if (PixelmonConfig.isAgressionAllowed && entity.aggression == Entity7HasAI.Aggression.aggressive) {
                    tasks.func_75776_a(this.i++, (EntityAIBase)new AITargetNearest((EntityCreature)entity, 10.0f, true));
                } else if (entity.aggression == Entity7HasAI.Aggression.timid) {
                    tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityPlayer.class, 16.0f, (double)0.23f, (double)0.4f));
                }
            }
            if (entity.func_70902_q() != null) {
                tasks.func_75776_a(this.i++, (EntityAIBase)new AIMoveTowardsBlock(entity, 25.0f));
            }
        }
    }

    private void initGroundAI(String Name, EntityPixelmon entity, EntityAITasks tasks) {
        if (entity.baseStats.type1 != EnumType.Fire && entity.baseStats.type2 != EnumType.Fire) {
            entity.func_70661_as().func_75495_e(true);
        }
        if (Name.equalsIgnoreCase("Abra")) {
            if (!entity.isInRanchBlock) {
                tasks.func_75776_a(this.i++, (EntityAIBase)new AITeleportAway(entity));
            }
        } else {
            tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAISwimming((EntityLiving)entity));
            if (!entity.isInRanchBlock) {
                tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)entity, (double)0.3f, 10.0f, 4.0f));
                tasks.func_75776_a(this.i++, (EntityAIBase)new AITempt((EntityCreature)entity, PixelmonItems.rareCandy, false));
            }
            tasks.func_75776_a(this.i++, (EntityAIBase)new AIWander((EntityCreature)entity));
            tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)entity, EntityPixelmon.class, 8.0f));
            tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAILookIdle((EntityLiving)entity));
        }
    }

    public void setWanderGroundAI(EntityPixelmon entity, EntityAITasks tasks) {
        tasks.field_75782_a.clear();
        entity.func_70661_as().func_75495_e(true);
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAISwimming((EntityLiving)entity));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIWander((EntityCreature)entity));
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)entity, EntityPixelmon.class, 8.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAILookIdle((EntityLiving)entity));
    }
}

