/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.helpers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.Evolution;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenReplaceMoveScreen;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.database.DatabaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class EvolutionQuery {
    public static List<EvolutionQuery> queryList = new ArrayList<EvolutionQuery>();
    EntityPixelmon pixelmon;
    String newPokemonName;
    public int[] pokemonID;
    boolean fromLevelUp;
    int level;
    EntityPlayer player;

    public EvolutionQuery(EntityPixelmon pixelmon, String newPokemonName, boolean fromLevelUp) {
        this.pixelmon = pixelmon;
        this.newPokemonName = newPokemonName;
        this.pokemonID = pixelmon.getPokemonId();
        this.fromLevelUp = fromLevelUp;
        if (pixelmon.func_70902_q() != null) {
            this.player = (EntityPlayer)pixelmon.func_70902_q();
        }
        this.sendQuery();
        pixelmon.evolving = 1;
        this.level = pixelmon.getLvl().getLevel();
    }

    private void sendQuery() {
        if (this.pixelmon.hasOwner()) {
            EntityPlayerMP player = (EntityPlayerMP)this.pixelmon.func_70902_q();
            Pixelmon.network.sendTo((IMessage)new Evolution(this.pokemonID, this.newPokemonName), player);
            this.removeExisting();
            queryList.add(this);
        }
    }

    private void removeExisting() {
        for (int i = 0; i < queryList.size(); ++i) {
            if (!PixelmonMethods.isIDSame(EvolutionQuery.queryList.get((int)i).pokemonID, this.pokemonID)) continue;
            EvolutionQuery.queryList.get((int)i).pixelmon.evolving = 0;
            queryList.remove(i);
            break;
        }
    }

    public static void acceptQuery(int[] pokemonID) {
        for (int i = 0; i < queryList.size(); ++i) {
            if (!PixelmonMethods.isIDSame(EvolutionQuery.queryList.get((int)i).pokemonID, pokemonID)) continue;
            EvolutionQuery.queryList.get((int)i).pixelmon.evolving = 0;
            queryList.get(i).accept();
            queryList.remove(i);
            return;
        }
    }

    private void accept() {
        this.pixelmon.evolve(this.newPokemonName);
        this.removeEntity();
        this.checkForLearnMoves();
    }

    private void removeEntity() {
        this.pixelmon.unloadEntity();
    }

    private void decline() {
        this.removeEntity();
    }

    private void checkForLearnMoves() {
        String name = this.pixelmon.getName();
        BaseStats basestats = DatabaseStats.GetBaseStats(name);
        this.pixelmon.baseStats.id = basestats.id;
        if (this.pixelmon.evolving == 0 && DatabaseMoves.LearnsAttackAtLevel(this.pixelmon.baseStats.id, this.pixelmon.getLvl().getLevel())) {
            ArrayList<Attack> newAttacks = DatabaseMoves.getAttacksAtLevel(this.pixelmon.baseStats.id, this.pixelmon.getLvl().getLevel());
            for (Attack a : newAttacks) {
                if (this.pixelmon.getMoveset().hasAttack(a)) continue;
                if (this.pixelmon.getMoveset().size() >= 4) {
                    Pixelmon.network.sendTo((IMessage)new OpenReplaceMoveScreen(this.pixelmon.getPokemonId(), a.baseAttack.attackIndex, 0, this.pixelmon.getLvl().getLevel()), (EntityPlayerMP)this.pixelmon.func_70902_q());
                    continue;
                }
                this.pixelmon.getMoveset().add(a);
                this.pixelmon.update(EnumUpdateType.Moveset);
                if (BattleRegistry.getBattle((EntityPlayer)this.pixelmon.func_70902_q()) != null) {
                    ChatHandler.sendBattleMessage((Entity)this.pixelmon.func_70902_q(), "pixelmon.stats.learnedmove", this.pixelmon.getNickname(), a.baseAttack.getLocalizedName());
                }
                ChatHandler.sendChat((Entity)this.pixelmon.func_70902_q(), "pixelmon.stats.learnedmove", this.pixelmon.getNickname(), a.baseAttack.getLocalizedName());
            }
        }
    }

    public static void declineQuery(int[] pokemonID) {
        for (int i = 0; i < queryList.size(); ++i) {
            if (!PixelmonMethods.isIDSame(EvolutionQuery.queryList.get((int)i).pokemonID, pokemonID)) continue;
            EvolutionQuery.queryList.get((int)i).pixelmon.evolving = 0;
            queryList.get(i).decline();
            queryList.remove(i);
            return;
        }
    }

    public static EvolutionQuery get(EntityPlayer player) {
        for (EvolutionQuery q : queryList) {
            if (q.player != player) continue;
            return q;
        }
        return null;
    }
}

