/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.entities.pixelmon.Entity6CanBattle;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.ChoiceItem;
import net.minecraft.nbt.NBTTagCompound;

public class BattleStats {
    private EntityPixelmon pixelmon;
    private int Accuracy;
    private int Evasion;
    private int AttackModifier;
    private int DefenceModifier;
    private int SpecialAttackModifier;
    private int SpecialDefenceModifier;
    private int SpeedModifier;
    public int attackStat;
    public int defenceStat;
    public int specialAttackStat;
    public int specialDefenceStat;
    public int speedStat;
    private int[] stages = new int[7];

    public int getAccuracy() {
        return this.Accuracy;
    }

    public int getEvasion() {
        return this.Evasion;
    }

    public double getAttackModifier() {
        return this.AttackModifier;
    }

    public int getDefenceModifier() {
        return this.DefenceModifier;
    }

    public double getSpecialAttackModifier() {
        return this.SpecialAttackModifier;
    }

    public int getSpecialDefenceModifier() {
        return this.SpecialDefenceModifier;
    }

    public double getSpeedModifier() {
        return this.SpeedModifier;
    }

    public double getHeldItemAttackModifier() {
        if (ItemHeld.isItemOfType(this.pixelmon.func_70694_bm(), EnumHeldItems.choiceItem)) {
            return ((ChoiceItem)this.pixelmon.func_70694_bm().func_77973_b()).affectAttack(1.0);
        }
        return 1.0;
    }

    public double getHeldItemSpecialAttackModifier() {
        if (ItemHeld.isItemOfType(this.pixelmon.func_70694_bm(), EnumHeldItems.choiceItem)) {
            return ((ChoiceItem)this.pixelmon.func_70694_bm().func_77973_b()).affectAttack(1.0);
        }
        return 1.0;
    }

    public double getHeldItemSpeedModifier() {
        if (ItemHeld.isItemOfType(this.pixelmon.func_70694_bm(), EnumHeldItems.choiceItem)) {
            return ((ChoiceItem)this.pixelmon.func_70694_bm().func_77973_b()).affectSpeed(1.0);
        }
        if (ItemHeld.isItemOfType(this.pixelmon.func_70694_bm(), EnumHeldItems.evAdjusting)) {
            return 0.5;
        }
        return 1.0;
    }

    public void setIsParalyzed() {
        this.SpeedModifier /= 4;
    }

    public void setNotParalyzed() {
        this.SpeedModifier *= 4;
    }

    public boolean IncreaseAccuracy(int amount) {
        return this.IncreaseStat(amount, "Accuracy");
    }

    public boolean DecreaseAccuracy(int amount) {
        return this.DecreaseStat(amount, "Accuracy");
    }

    public boolean IncreaseEvasion(int amount) {
        return this.IncreaseStat(amount, "Evasion");
    }

    public boolean DecreaseEvasion(int amount) {
        return this.DecreaseStat(amount, "Evasion");
    }

    public boolean IncreaseAttack(int amount) {
        return this.IncreaseStat(amount, "AttackModifier");
    }

    public boolean DecreaseAttack(int amount) {
        return this.DecreaseStat(amount, "AttackModifier");
    }

    public boolean IncreaseDefence(int amount) {
        return this.IncreaseStat(amount, "DefenceModifier");
    }

    public boolean DecreaseDefence(int amount) {
        return this.DecreaseStat(amount, "DefenceModifier");
    }

    public boolean IncreaseSpecialAttack(int amount) {
        return this.IncreaseStat(amount, "SpecialAttackModifier");
    }

    public boolean DecreaseSpecialAttack(int amount) {
        return this.DecreaseStat(amount, "SpecialAttackModifier");
    }

    public boolean IncreaseSpecialDefence(int amount) {
        return this.IncreaseStat(amount, "SpecialDefenceModifier");
    }

    public boolean DecreaseSpecialDefence(int amount) {
        return this.DecreaseStat(amount, "SpecialDefenceModifier");
    }

    public boolean IncreaseSpeed(int amount) {
        return this.IncreaseStat(amount, "SpeedModifier");
    }

    public boolean DecreaseSpeed(int amount) {
        return this.DecreaseStat(amount, "SpeedModifier");
    }

    public BattleStats(Entity6CanBattle entity6CanBattle) {
        this.pixelmon = (EntityPixelmon)entity6CanBattle;
        this.clearBattleStats();
    }

    private int GetAccOrEva(double stage) {
        if (stage < 1.0) {
            return (int)Math.round(3.0 / (Math.abs(stage) + 3.0) * 100.0);
        }
        return (int)Math.round((Math.abs(stage) + 3.0) / 3.0 * 100.0);
    }

    private int GetStat(double stage) {
        if (stage < 1.0) {
            return (int)Math.round(2.0 / (Math.abs(stage) + 2.0) * 100.0);
        }
        return (int)Math.round((Math.abs(stage) + 2.0) / 2.0 * 100.0);
    }

    public boolean IncreaseStat(int amount, String stat) {
        if (amount < 0) {
            return this.DecreaseStat(Math.abs(amount), stat);
        }
        int stageIndex = this.GetStageIndex(stat);
        int currentStage = this.stages[stageIndex];
        if (currentStage == 6) {
            return false;
        }
        if ((currentStage += Math.abs(amount)) > 6) {
            currentStage = 6;
        }
        int newValue = stageIndex < 2 ? this.GetAccOrEva(currentStage) : this.GetStat(currentStage);
        this.stages[stageIndex] = currentStage;
        this.ChangeStat(stat, newValue);
        return true;
    }

    public boolean DecreaseStat(int amount, String stat) {
        int stageIndex = this.GetStageIndex(stat);
        int currentStage = this.stages[stageIndex];
        if (currentStage == -6) {
            return false;
        }
        if ((currentStage -= Math.abs(amount)) < -6) {
            currentStage = -6;
        }
        int newValue = stageIndex < 2 ? this.GetAccOrEva(currentStage) : this.GetStat(currentStage);
        this.stages[stageIndex] = currentStage;
        this.ChangeStat(stat, newValue);
        return true;
    }

    private void ChangeStat(String stat, int value) {
        if (stat.equalsIgnoreCase("Accuracy")) {
            this.Accuracy = value;
        }
        if (stat.equalsIgnoreCase("Evasion")) {
            this.Evasion = value;
        }
        if (stat.equalsIgnoreCase("AttackModifier")) {
            this.AttackModifier = value;
        }
        if (stat.equalsIgnoreCase("DefenceModifier")) {
            this.DefenceModifier = value;
        }
        if (stat.equalsIgnoreCase("SpecialAttackModifier")) {
            this.SpecialAttackModifier = value;
        }
        if (stat.equalsIgnoreCase("SpecialDefenceModifier")) {
            this.SpecialDefenceModifier = value;
        }
        if (stat.equalsIgnoreCase("SpeedModifier")) {
            this.SpeedModifier = value;
        }
    }

    private int GetStageIndex(String stat) {
        if (stat.equalsIgnoreCase("Accuracy")) {
            return 0;
        }
        if (stat.equalsIgnoreCase("Evasion")) {
            return 1;
        }
        if (stat.equalsIgnoreCase("AttackModifier")) {
            return 2;
        }
        if (stat.equalsIgnoreCase("DefenceModifier")) {
            return 3;
        }
        if (stat.equalsIgnoreCase("SpecialAttackModifier")) {
            return 4;
        }
        if (stat.equalsIgnoreCase("SpecialDefenceModifier")) {
            return 5;
        }
        if (stat.equalsIgnoreCase("SpeedModifier")) {
            return 6;
        }
        return -1;
    }

    public void writeToNBT(NBTTagCompound var1) {
        var1.func_74768_a("BattleAccuracy", this.Accuracy);
        var1.func_74768_a("BattleEvasion", this.Evasion);
        var1.func_74768_a("BattleAttackModifier", this.AttackModifier);
        var1.func_74768_a("BattleDefenceModifier", this.DefenceModifier);
        var1.func_74768_a("BattleSpecialAttackModifier", this.SpecialAttackModifier);
        var1.func_74768_a("BattleSpecialDefenceModifier", this.SpecialDefenceModifier);
        var1.func_74768_a("BattleSpeedModifier", this.SpeedModifier);
    }

    public void clearBattleStats() {
        this.Evasion = 100;
        this.Accuracy = 100;
        this.SpeedModifier = 100;
        this.SpecialDefenceModifier = 100;
        this.SpecialAttackModifier = 100;
        this.DefenceModifier = 100;
        this.AttackModifier = 100;
        this.stages = new int[7];
    }

    public void readFromNBT(NBTTagCompound var1) {
        this.Accuracy = var1.func_74762_e("BattleAccuracy");
        this.Evasion = var1.func_74762_e("BattleEvasion");
        this.AttackModifier = var1.func_74762_e("BattleAttackModifier");
        this.DefenceModifier = var1.func_74762_e("BattleDefenceModifier");
        this.SpecialAttackModifier = var1.func_74762_e("BattleSpecialAttackModifier");
        this.SpecialDefenceModifier = var1.func_74762_e("BattleSpecialDefenceModifier");
        this.SpeedModifier = var1.func_74762_e("BattleSpeedModifier");
    }

    public void setSpeedModifier(int value) {
        this.SpeedModifier = value;
    }

    public void setAttackModifier(int value) {
        this.AttackModifier = value;
    }

    public void setDefenceModifier(int value) {
        this.DefenceModifier = value;
    }

    public void setSpecialAttackModifier(int value) {
        this.SpecialAttackModifier = value;
    }

    public void setSpecialDefenceModifier(int value) {
        this.SpecialDefenceModifier = value;
    }

    public void setEvasion(int value) {
        this.Evasion = value;
    }

    public void setAccuracy(int value) {
        this.Accuracy = value;
    }

    public void copyStats(BattleStats battleStats) {
        this.SpeedModifier = battleStats.SpeedModifier;
        this.AttackModifier = battleStats.AttackModifier;
        this.DefenceModifier = battleStats.DefenceModifier;
        this.SpecialAttackModifier = battleStats.SpecialAttackModifier;
        this.SpecialDefenceModifier = battleStats.SpecialDefenceModifier;
        this.Evasion = battleStats.Evasion;
        this.Accuracy = battleStats.Accuracy;
    }

    public int getSumIncreases() {
        int increases = 0;
        if (this.getSpeedModifier() > 100.0) {
            increases += (this.SpeedModifier - 100) / 50;
        }
        if (this.AttackModifier > 100) {
            increases += (this.AttackModifier - 100) / 50;
        }
        if (this.DefenceModifier > 100) {
            increases += (this.DefenceModifier - 100) / 50;
        }
        if (this.SpecialAttackModifier > 100) {
            increases += (this.SpecialAttackModifier - 100) / 50;
        }
        if (this.SpecialDefenceModifier > 100) {
            increases += (this.SpecialDefenceModifier - 100) / 50;
        }
        if (this.Evasion > 100) {
            increases += (this.Evasion - 100) / 50;
        }
        if (this.Accuracy > 100) {
            increases += (this.Accuracy - 100) / 50;
        }
        return increases;
    }

    public boolean statCanBeRaised() {
        for (int i = 0; i < this.stages.length; ++i) {
            if (this.stages[i] >= 6) continue;
            return true;
        }
        return false;
    }

    public void setStatsForTurn(int[] stats) {
        this.attackStat = stats[0];
        this.defenceStat = stats[1];
        this.specialAttackStat = stats[2];
        this.specialDefenceStat = stats[3];
        this.speedStat = stats[4];
        this.Evasion = stats[5];
        this.Accuracy = stats[6];
    }
}

