/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumHerbalMedicines;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;

public class FriendShip {
    private static final int maxFriendship = 255;
    private static final int minFriendship = 0;
    private int friendship = 0;
    private EntityPixelmon pixelmon;
    private Random rand = new Random();
    boolean luxuryBall = false;
    public EnumHerbalMedicines type;
    private int tickCounter = 0;

    public FriendShip(EntityPixelmon pixelmon) {
        this.pixelmon = pixelmon;
    }

    public void initFromCapture() {
        this.friendship = this.pixelmon.baseStats.baseFriendship;
    }

    public void increaseFriendship(int amount) {
        this.friendship = this.pixelmon.func_70694_bm() != null ? (this.pixelmon.func_70694_bm().func_77973_b() == PixelmonItemsHeld.sootheBell ? (int)((double)this.friendship + (double)amount * 1.5) : (this.friendship += amount)) : (this.friendship += amount);
        if (this.friendship > 255) {
            this.friendship = 255;
        }
        if (this.pixelmon.func_70902_q() != null) {
            this.pixelmon.update(EnumUpdateType.Friendship);
        }
    }

    public void decreaseFriendship(int amount) {
        this.friendship -= amount;
        if (this.friendship < 0) {
            this.friendship = 0;
        }
        this.pixelmon.update(EnumUpdateType.Friendship);
    }

    public int getFriendship() {
        return this.friendship;
    }

    public void initFromEgg() {
        this.friendship = 120;
    }

    public void resetFromTrade() {
        this.friendship = 70;
    }

    public boolean isFriendshipHighEnoughToEvolve() {
        return this.friendship >= 220;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Friendship", this.friendship);
        nbt.func_74757_a("LuxuryBall", this.luxuryBall);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.friendship = nbt.func_74762_e("Friendship");
        this.luxuryBall = nbt.func_74767_n("LuxuryBall");
    }

    private int luxuryBonus() {
        if (this.luxuryBall) {
            return 1 + this.rand.nextInt(2);
        }
        return 0;
    }

    public void tick() {
        ++this.tickCounter;
        if (this.tickCounter >= 800) {
            if (this.pixelmon.func_70694_bm() != null && this.pixelmon.func_70694_bm().func_77973_b() == PixelmonItemsHeld.sootheBell) {
                this.friendship += 2;
                this.tickCounter = 0;
            }
            this.increaseFriendship(1 + this.luxuryBonus());
            this.tickCounter = 0;
        }
    }

    public void hurtByOwner() {
        this.decreaseFriendship(20);
    }

    public void onLevelUp() {
        this.increaseFriendship(this.rand.nextInt(2) + 5 + this.luxuryBonus());
    }

    public void onFaint() {
        this.decreaseFriendship(2);
    }

    public void captureLuxuryBall() {
        this.luxuryBall = true;
    }

    public void setFriendship(int i) {
        this.friendship = i;
    }

    public void berryFriendship() {
        if (this.friendship < 100) {
            this.friendship += 10;
        } else if (this.friendship >= 100 && this.friendship < 200) {
            this.friendship += 5;
        } else if (this.friendship >= 200 && this.friendship <= 253) {
            this.friendship += 2;
        } else if (this.friendship >= 255) {
            this.friendship += 0;
        }
        this.pixelmon.update(EnumUpdateType.Friendship);
    }

    public void vitaminFriendship() {
        if (this.friendship < 100) {
            this.friendship += 5;
        } else if (this.friendship >= 100 && this.friendship < 200) {
            this.friendship += 3;
        } else if (this.friendship >= 200 && this.friendship <= 253) {
            this.friendship += 2;
        } else if (this.friendship >= 255) {
            this.friendship += 0;
        }
        this.pixelmon.update(EnumUpdateType.Friendship);
    }

    public void HerbalFriendship() {
        if (this.friendship < 100 && this.friendship >= 5) {
            this.friendship -= 5;
        } else if (this.friendship > 100 && this.friendship < 200 && this.friendship >= 5) {
            this.friendship -= 5;
        } else if (this.friendship > 200 && this.friendship <= 255 && this.friendship >= 10) {
            this.friendship -= 10;
        }
        this.pixelmon.update(EnumUpdateType.Friendship);
    }

    public void HerbalFriendshipEnergyRoot() {
        if (this.friendship < 100 && this.friendship >= 5) {
            this.friendship -= 10;
        } else if (this.friendship > 100 && this.friendship < 200 && this.friendship >= 10) {
            this.friendship -= 10;
        } else if (this.friendship > 200 && this.friendship <= 255 && this.friendship >= 15) {
            this.friendship -= 15;
        }
        this.pixelmon.update(EnumUpdateType.Friendship);
    }

    public void HerbalFriendshipRevivalHerb() {
        if (this.friendship < 100 && this.friendship >= 15) {
            this.friendship -= 15;
        } else if (this.friendship > 100 && this.friendship < 200 && this.friendship >= 15) {
            this.friendship -= 15;
        } else if (this.friendship > 200 && this.friendship <= 255 && this.friendship >= 20) {
            this.friendship -= 20;
        }
        this.pixelmon.update(EnumUpdateType.Friendship);
    }
}

