/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.api.events.ExperienceGainEvent;
import com.pixelmonmod.pixelmon.api.events.LevelUpEvent;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LevelUp;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenReplaceMoveScreen;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.database.ExperienceGroup;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class Level {
    private EntityPixelmon pixelmon;
    private int baseLevel = 0;
    public int expToNextLevel = 0;
    int oldLevel = -1;

    public Level(EntityPixelmon p) {
        this.pixelmon = p;
        this.pixelmon.func_70096_w().func_75682_a(27, (Object)-1);
        this.pixelmon.func_70096_w().func_75682_a(14, (Object)0);
        this.setScale();
    }

    protected void updateStats() {
        this.pixelmon.updateStats();
    }

    public void writeToNBT(NBTTagCompound var1) {
        var1.func_74768_a("Level", this.getLevel());
        var1.func_74768_a("EXP", this.getExp());
        var1.func_74768_a("EXPToNextLevel", this.getExp());
    }

    public void readFromNBT(NBTTagCompound var1) {
        this.setExp(var1.func_74762_e("EXP"));
        this.expToNextLevel = this.getExpForLevel(this.getLevel() + 1) - this.getExpForLevel(this.getLevel());
        this.setLevel(var1.func_74762_e("Level"));
    }

    public int getLevel() {
        return this.pixelmon.func_70096_w().func_75693_b(27);
    }

    public void setLevel(int i) {
        this.pixelmon.func_70096_w().func_75692_b(27, (Object)((short)i));
        this.setScale();
        this.expToNextLevel = this.getExpForLevel(this.getLevel() + 1) - this.getExpForLevel(this.getLevel());
        if (this.pixelmon.func_110143_aJ() == (float)this.pixelmon.stats.HP) {
            this.updateStats();
            this.pixelmon.func_70606_j(this.pixelmon.stats.HP);
        } else {
            float oldHp = this.pixelmon.stats.HP;
            float oldHealth = this.pixelmon.func_110143_aJ();
            this.updateStats();
            float newHealth = this.pixelmon.stats.HP;
            if (oldHp != 0.0f) {
                newHealth = oldHealth / oldHp * (float)this.pixelmon.stats.HP;
            }
            this.pixelmon.func_70606_j((int)Math.ceil(newHealth));
        }
    }

    private int getExpForLevel(int l) {
        ExperienceGroup ex = this.pixelmon.baseStats.experienceGroup;
        if (ex == ExperienceGroup.Erratic) {
            if (l <= 50) {
                return (100 - l) * (l * l * l) / 50;
            }
            if (l <= 68) {
                return (150 - l) * (l * l * l) / 100;
            }
            if (l <= 98) {
                return (191 - l) * (l * l * l) / 150;
            }
            if (l <= 100) {
                return (160 - l) * (l * l * l) / 100;
            }
        } else {
            if (ex == ExperienceGroup.Fast) {
                return (int)(0.8 * (double)l * (double)l * (double)l);
            }
            if (ex == ExperienceGroup.MediumFast) {
                return l * l * l;
            }
            if (ex == ExperienceGroup.MediumSlow) {
                return (int)(1.2 * (double)l * (double)l * (double)l - (double)(15 * l * l) + (double)(100 * l) - 140.0);
            }
            if (ex == ExperienceGroup.Slow) {
                return (int)(1.25 * (double)l * (double)l * (double)l);
            }
            if (ex == ExperienceGroup.Fluctuating) {
                if (l <= 15) {
                    return (l + 73) * (l * l * l) / 150;
                }
                if (l <= 36) {
                    return (l + 14) * (l * l * l) / 50;
                }
                if (l <= 100) {
                    return (l + 64) * (l * l * l) / 100;
                }
            }
        }
        return -1;
    }

    public int getExp() {
        return this.pixelmon.func_70096_w().func_75679_c(14);
    }

    public void setExp(int i) {
        this.pixelmon.func_70096_w().func_75692_b(14, (Object)i);
    }

    public boolean canLevelUp() {
        return this.getLevel() != 100;
    }

    protected void onLevelUp(PixelmonStatsData stats) {
        float oldHp = this.pixelmon.stats.HP;
        this.updateStats();
        float percentGain = (float)this.pixelmon.stats.HP / oldHp;
        float newHealth = this.pixelmon.func_110143_aJ() * percentGain;
        this.pixelmon.func_70606_j((int)Math.ceil(newHealth));
        if (this.pixelmon.func_70902_q() != null && this.pixelmon.func_70902_q() instanceof EntityPlayerMP) {
            PixelmonStatsData stats2 = PixelmonStatsData.createPacket(this.pixelmon);
            Pixelmon.EVENT_BUS.post((Event)new LevelUpEvent((EntityPlayer)this.pixelmon.func_70902_q(), this.pixelmon));
            Pixelmon.network.sendTo((IMessage)new LevelUp(this.pixelmon, this.getLevel(), stats, stats2), (EntityPlayerMP)this.pixelmon.func_70902_q());
            this.pixelmon.update(EnumUpdateType.Stats);
        }
        if (this.pixelmon.func_70902_q() != null) {
            this.pixelmon.friendship.onLevelUp();
        }
        this.setScale();
    }

    public void awardEXP(int i) {
        if (!this.pixelmon.doesLevel) {
            return;
        }
        ExperienceGainEvent expgainEvent = new ExperienceGainEvent(this.pixelmon, i);
        Pixelmon.EVENT_BUS.post((Event)expgainEvent);
        i = expgainEvent.experience;
        this.setExp(this.getExp() + i);
        if (this.pixelmon.func_70902_q() != null && this.getLevel() != 100 && i > 0) {
            ChatHandler.sendChat((Entity)this.pixelmon.func_70902_q(), "pixelmon.stats.gainexp", this.pixelmon.getNickname(), i);
        }
        if (!this.canLevelUp() || this.expToNextLevel == -1) {
            this.setExp(0);
            return;
        }
        while (this.getExp() >= this.expToNextLevel) {
            this.pixelmon.update(EnumUpdateType.Name);
            int newExp = this.getExp() - this.expToNextLevel;
            if (!this.canLevelUp()) {
                return;
            }
            PixelmonStatsData stats = null;
            if (this.pixelmon.func_70902_q() != null) {
                stats = PixelmonStatsData.createPacket(this.pixelmon);
            }
            this.setLevel(this.getLevel() + 1);
            this.onLevelUp(stats);
            this.setExp(newExp);
            if (DatabaseMoves.LearnsAttackAtLevel(this.pixelmon.baseStats.id, this.getLevel())) {
                ArrayList<Attack> newAttacks = DatabaseMoves.getAttacksAtLevel(this.pixelmon.baseStats.id, this.getLevel());
                for (Attack a : newAttacks) {
                    if (this.pixelmon.getMoveset().hasAttack(a)) continue;
                    if (this.pixelmon.getMoveset().size() >= 4) {
                        Pixelmon.network.sendTo((IMessage)new OpenReplaceMoveScreen(this.pixelmon.getPokemonId(), a.baseAttack.attackIndex, 0, this.getLevel()), (EntityPlayerMP)this.pixelmon.func_70902_q());
                        continue;
                    }
                    this.pixelmon.getMoveset().add(a);
                    this.pixelmon.update(EnumUpdateType.Moveset);
                    if (BattleRegistry.getBattle((EntityPlayer)this.pixelmon.func_70902_q()) != null) {
                        ChatHandler.sendBattleMessage((Entity)this.pixelmon.func_70902_q(), "pixelmon.stats.learnedmove", this.pixelmon.getNickname(), a.baseAttack.getLocalizedName());
                    }
                    ChatHandler.sendChat((Entity)this.pixelmon.func_70902_q(), "pixelmon.stats.learnedmove", this.pixelmon.getNickname(), a.baseAttack.getLocalizedName());
                }
            }
            boolean hasEvolved = this.checkForExistingEvolutionQuery();
            if (ItemHeld.isItemOfType(this.pixelmon.func_70694_bm(), EnumHeldItems.everStone) || hasEvolved) continue;
            hasEvolved = this.pixelmon.checkEvolution(EvolutionType.Level, EvolutionType.Friendship, EvolutionType.Move, EvolutionType.Proximity, EvolutionType.LevelHeldItem);
        }
    }

    private boolean checkForExistingEvolutionQuery() {
        for (int i = 0; i < EvolutionQuery.queryList.size(); ++i) {
            if (!PixelmonMethods.isIDSame(EvolutionQuery.queryList.get((int)i).pokemonID, this.pixelmon)) continue;
            return true;
        }
        return false;
    }

    private void setScale() {
        float percent = 1.0f;
        percent = 0.8f + 0.4f * (float)this.getLevel() / 100.0f;
        if (percent > this.pixelmon.maxScale) {
            percent = this.pixelmon.maxScale;
        }
        this.pixelmon.setPixelmonScale(percent);
    }

    public void recalculateXP() {
        this.setExp(0);
        this.expToNextLevel = this.getExpForLevel(this.getLevel() + 1) - this.getExpForLevel(this.getLevel());
    }

    public int getExpForNextLevelClient() {
        if (this.oldLevel != this.getLevel()) {
            this.expToNextLevel = this.getExpForLevel(this.getLevel() + 1) - this.getExpForLevel(this.getLevel());
            this.oldLevel = this.getLevel();
        }
        return this.expToNextLevel;
    }
}

