/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import net.minecraft.nbt.NBTTagCompound;

public class Moveset
extends AbstractList<Attack>
implements List<Attack>,
RandomAccess,
Cloneable {
    public Attack[] attacks = new Attack[4];

    public Moveset() {
    }

    public Moveset(int index, Attack a) {
        this.attacks[0] = a;
    }

    @Override
    public Attack get(int index) {
        if (index < 0 || index > 3) {
            return null;
        }
        return this.attacks[index];
    }

    @Override
    public boolean add(Attack a) {
        if (this.size() >= 4) {
            return false;
        }
        this.attacks[this.size()] = a;
        return true;
    }

    @Override
    public Attack set(int index, Attack a) {
        Attack retval = this.attacks[index];
        this.attacks[index] = a;
        return retval;
    }

    public void swap(int index, int index2) {
        Attack a = this.attacks[index];
        this.attacks[index] = this.attacks[index2];
        this.attacks[index2] = a;
    }

    @Override
    public Attack remove(int index) {
        Attack a = this.get(index);
        int oldSize = this.size();
        for (int i = index + 1; i < this.size(); ++i) {
            this.set(i - 1, this.get(i));
        }
        this.set(oldSize - 1, null);
        return a;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Attack)) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.attacks[i] != (Attack)o) continue;
            this.attacks[i] = null;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.attacks[i] == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isAt(int index, Attack a) {
        if (this.isEmpty()) {
            return false;
        }
        if (!this.contains(a)) {
            return false;
        }
        return this.attacks[index] == a;
    }

    @Override
    public boolean contains(Object o) {
        if (this.isEmpty()) {
            return false;
        }
        if (o instanceof Attack) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.attacks[i] != (Attack)o) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.attacks = new Attack[4];
    }

    public void writeToNBT(NBTTagCompound var1) {
        var1.func_74768_a("PixelmonNumberMoves", this.size());
        for (int i = 0; i < this.size(); ++i) {
            var1.func_74768_a("PixelmonMoveID" + i, this.get((int)i).baseAttack.attackIndex);
            var1.func_74768_a("PixelmonMoveType" + i, this.get((int)i).baseAttack.attackType.getIndex());
            var1.func_74768_a("PixelmonMovePP" + i, this.get((int)i).pp);
            var1.func_74768_a("PixelmonMovePPBase" + i, this.get((int)i).ppBase);
            var1.func_74768_a("PixelmonMovePPMax" + i, this.get((int)i).baseAttack.ppMax);
        }
    }

    public void readFromNBT(NBTTagCompound var1) {
        this.clear();
        int numMoves = var1.func_74762_e("PixelmonNumberMoves");
        for (int i = 0; i < numMoves; ++i) {
            Attack a = !var1.func_74764_b("PixelmonMoveID" + i) && var1.func_74764_b("PixelmonMoveName" + i) ? DatabaseMoves.getAttack(var1.func_74779_i("PixelmonMoveName" + i)) : DatabaseMoves.getAttack(var1.func_74762_e("PixelmonMoveID" + i));
            if (a == null) continue;
            if (var1.func_74764_b("PixelmonMovePP" + i)) {
                a.pp = var1.func_74762_e("PixelmonMovePP" + i);
            }
            if (var1.func_74764_b("PixelmonMovePPBase" + i)) {
                a.ppBase = var1.func_74762_e("PixelmonMovePPBase" + i);
            }
            this.add(a);
        }
    }

    public boolean hasAttack(Attack a) {
        for (int i = 0; i < this.attacks.length; ++i) {
            if (this.attacks[i] == null || this.attacks[i].baseAttack.attackIndex != a.baseAttack.attackIndex) continue;
            return true;
        }
        return false;
    }

    public void replaceWith(ArrayList<Integer> attackIds) {
        this.clear();
        for (Integer i : attackIds) {
            this.add(DatabaseMoves.getAttack(i));
        }
    }
}

