/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EVsStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import net.minecraft.nbt.NBTTagCompound;

public class Stats {
    public int HP;
    public int Attack;
    public int Defence;
    public int SpecialAttack;
    public int SpecialDefence;
    public int Speed;
    public IVStore IVs;
    public EVsStore EVs = new EVsStore();

    public void setLevelStats(EnumNature nature, BaseStats baseStats, int level) {
        this.HP = this.calculateHP(baseStats, level);
        this.Attack = this.calculateStat(StatsType.Attack, nature, baseStats, level);
        this.Defence = this.calculateStat(StatsType.Defence, nature, baseStats, level);
        this.SpecialAttack = this.calculateStat(StatsType.SpecialAttack, nature, baseStats, level);
        this.SpecialDefence = this.calculateStat(StatsType.SpecialDefence, nature, baseStats, level);
        this.Speed = this.calculateStat(StatsType.Speed, nature, baseStats, level);
    }

    public int calculateHP(BaseStats baseStats, int level) {
        return (int)(((float)this.IVs.HP + 2.0f * (float)baseStats.hp + (float)this.EVs.HP / 4.0f + 100.0f) * (float)level / 100.0f + 10.0f);
    }

    public int calculateStat(StatsType stat, EnumNature nature, BaseStats baseStats, int level) {
        float val = ((float)this.IVs.get(stat) + 2.0f * (float)baseStats.get(stat) + (float)this.EVs.get(stat) / 4.0f) * (float)level;
        val /= 100.0f;
        val += 5.0f;
        if (stat == nature.increasedStat) {
            val *= 1.1f;
        }
        if (stat == nature.decreasedStat) {
            val *= 0.9f;
        }
        return (int)val;
    }

    public void writeToNBT(NBTTagCompound var1) {
        var1.func_74768_a("StatsHP", this.HP);
        var1.func_74768_a("StatsAttack", this.Attack);
        var1.func_74768_a("StatsDefence", this.Defence);
        var1.func_74768_a("StatsSpecialAttack", this.SpecialAttack);
        var1.func_74768_a("StatsSpecialDefence", this.SpecialDefence);
        var1.func_74768_a("StatsSpeed", this.Speed);
        if (this.IVs != null) {
            this.IVs.writeToNBt(var1);
        }
        this.EVs.writeToNBT(var1);
    }

    public void readFromNBT(NBTTagCompound var1) {
        this.HP = var1.func_74762_e("StatsHP");
        this.Attack = var1.func_74762_e("StatsAttack");
        this.Defence = var1.func_74762_e("StatsDefence");
        this.SpecialAttack = var1.func_74762_e("StatsSpecialAttack");
        this.SpecialDefence = var1.func_74762_e("StatsSpecialDefence");
        this.Speed = var1.func_74762_e("StatsSpeed");
        if (this.IVs != null) {
            this.IVs.readFromNBT(var1);
        }
        this.EVs.readFromNBT(var1);
    }
}

