/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.database.DatabaseAbilities;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.ComingSoon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionLevel;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionTyrogue;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.IEvolutionData;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;

public class Evolution {
    public EnumPokemon evolveInto;
    public IEvolutionData data;

    public Evolution(EnumPokemon target) {
        this.evolveInto = target;
    }

    public Evolution(EnumPokemon target, int evolveLevel) {
        this(target);
        this.data = new EvolutionLevel(evolveLevel);
    }

    public Evolution(IEvolutionData data, EnumPokemon target) {
        this(target);
        this.data = data;
    }

    public boolean handleEvolution(EntityPixelmon pixelmon, EvolutionType type) {
        if (this.data.getType() == type && this.data.doEvolution(pixelmon, this.evolveInto)) {
            this.evolve(pixelmon, type);
            return true;
        }
        return false;
    }

    public void evolve(EntityPixelmon pixelmon, EvolutionType type) {
        String[] oldAbilities = DatabaseAbilities.getAbilities(pixelmon.getName());
        String[] newAbilities = DatabaseAbilities.getAbilities(this.evolveInto.name);
        Integer newSlot = pixelmon.getAbilitySlot();
        if (pixelmon.getAbilitySlot() == 0 && oldAbilities[1] == null && newAbilities[1] != null) {
            newSlot = RandomHelper.getRandomNumberBetween(0, 1);
        }
        if (pixelmon.getAbilitySlot() == 1 && newAbilities[1] == null) {
            newSlot = 0;
        }
        pixelmon.setAbilitySlot(newSlot);
        String chosenAbility = newAbilities[newSlot];
        try {
            Class<?> abilityClass = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.abilities." + chosenAbility);
            pixelmon.setAbility((AbilityBase)abilityClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            pixelmon.setAbility(new ComingSoon(chosenAbility));
        }
        if (this.data instanceof EvolutionTyrogue) {
            this.evolveInto = ((EvolutionTyrogue)this.data).getEvolution(pixelmon);
        }
        if (type == EvolutionType.Trade || type == EvolutionType.EvolutionStone) {
            pixelmon.startEvolution(this.evolveInto.name, false);
        } else {
            pixelmon.startEvolution(this.evolveInto.name, true);
        }
    }
}

