/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution;

import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.IEvolutionData;
import com.pixelmonmod.pixelmon.enums.EnumBiomes;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;

public class EvolutionLevel
implements IEvolutionData {
    int evolveLevel;
    String biome;
    boolean biomeCondition = false;
    boolean hasEvolveLevel = true;

    @Override
    public EvolutionType getType() {
        return EvolutionType.Level;
    }

    public EvolutionLevel(int level) {
        this.evolveLevel = level;
    }

    public EvolutionLevel(int level, String biome) {
        this.biomeCondition = true;
        this.evolveLevel = level;
        this.biome = biome;
    }

    public EvolutionLevel(String biome) {
        this.hasEvolveLevel = false;
        this.biomeCondition = true;
        this.biome = biome;
    }

    @Override
    public boolean doEvolution(EntityPixelmon pixelmon, EnumPokemon evolveTarget) {
        if (this.hasEvolveLevel) {
            if (this.evolveLevel == -1) {
                return false;
            }
            if (pixelmon.getLvl().getLevel() < this.evolveLevel) {
                return false;
            }
        }
        return !this.biomeCondition || pixelmon.field_70170_p.func_72807_a((int)pixelmon.field_70165_t, (int)pixelmon.field_70161_v) == EnumBiomes.parseBiome(this.biome).getBiome();
    }
}

