/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pokeballs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.achievement.PixelmonAchievements;
import com.pixelmonmod.pixelmon.api.events.PixelmonCaptureEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonRecievedEvent;
import com.pixelmonmod.pixelmon.api.events.ReceiveType;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.Experience;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityPokeBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeballTypeHelper;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumPokeballs;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityEmptyPokeball
extends EntityPokeBall {
    private int breakChance;
    private int waitTime;
    private BattleControllerBase battleController;
    private boolean isBattleThrown;
    private double pokemonPosX;
    private double pokemonPosY;
    private double pokemonPosZ;
    boolean capturedPokemon;

    public EntityEmptyPokeball(World world) {
        super(world);
        this.breakChance = this.field_70146_Z.nextInt(30);
        this.isBattleThrown = false;
        this.capturedPokemon = false;
    }

    public EntityEmptyPokeball(World world, EntityLivingBase entityliving, EnumPokeballs type, boolean dropItem) {
        super(type, world, entityliving, EntityPokeBall.Mode.empty);
        this.breakChance = this.field_70146_Z.nextInt(30);
        this.isBattleThrown = false;
        this.capturedPokemon = false;
        this.field_70192_c = entityliving;
        this.dropItem = dropItem;
    }

    public EntityEmptyPokeball(World world, EntityLivingBase thrower, EntityPixelmon target, EnumPokeballs type, BattleControllerBase battleController) {
        super(type, world, thrower, EntityPokeBall.Mode.battle);
        this.breakChance = this.field_70146_Z.nextInt(30);
        this.isBattleThrown = false;
        this.capturedPokemon = false;
        this.field_70192_c = thrower;
        this.dropItem = false;
        this.endRotationYaw = thrower.field_70759_as;
        this.pixelmon = target;
        this.isBattleThrown = true;
        this.battleController = battleController;
        this.field_70170_p = thrower.field_70170_p;
        battleController.pauseBattle();
        this.func_70012_b(thrower.field_70165_t, thrower.field_70163_u + (double)thrower.func_70047_e(), thrower.field_70161_v, thrower.field_70177_z, thrower.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        Vec3 posVec = Vec3.func_72443_a((double)(this.field_70165_t - this.pixelmon.field_70165_t), (double)(this.field_70163_u - this.pixelmon.field_70163_u), (double)(this.field_70161_v - this.pixelmon.field_70161_v));
        this.field_70159_w = (double)(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI))) * 0.8;
        this.field_70179_y = (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI))) * 0.8;
        this.field_70181_x = (double)(-MathHelper.func_76126_a((float)0.0f)) * 0.8;
    }

    @Override
    protected void func_70184_a(MovingObjectPosition movingobjectposition) {
        if (this.dropItem && this.breakChance == 1 && this.getType() != EnumPokeballs.MasterBall) {
            this.field_70170_p.func_72956_a((Entity)this, "random.break", 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            this.func_70099_a(new ItemStack(Blocks.field_150430_aB), 0.0f);
            this.func_70099_a(new ItemStack(PixelmonItemsPokeballs.ironBase), 0.0f);
            this.func_70099_a(new ItemStack(this.breakBall()), 0.0f);
            this.func_70106_y();
            return;
        }
        if (this.isBattleThrown && !this.field_70170_p.field_72995_K) {
            if (!this.getIsWaiting()) {
                this.pokemonPosX = this.pixelmon.field_70165_t;
                this.pokemonPosY = this.pixelmon.field_70163_u;
                this.pokemonPosZ = this.pixelmon.field_70161_v;
                this.pixelmon.hitByPokeball = this;
                this.doCaptureCalc(this.pixelmon);
                this.pixelmon.field_70179_y = 0.0;
                this.pixelmon.field_70181_x = 0.0;
                this.pixelmon.field_70159_w = 0.0;
                this.initialScale = this.pixelmon.getPixelmonScale();
                this.setAnimation("bounceOpen");
                this.setIsWaiting(true);
                this.setId(this.canCatch ? this.numShakes : -1 * this.numShakes);
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.field_70125_A = 0.0f;
                int i = -2;
                while (!this.field_70170_p.func_147437_c((int)this.field_70165_t, (int)Math.ceil(this.field_70163_u) + i, (int)this.field_70161_v)) {
                    ++i;
                }
                this.field_70165_t = (int)this.field_70165_t;
                this.field_70161_v = (int)this.field_70161_v;
                this.field_70163_u = Math.ceil(this.field_70163_u) + (double)i + (double)0.1f;
            } else if (this.getIsWaiting()) {
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.setIsOnGround(true);
            }
        } else if (movingobjectposition != null) {
            if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                Block hitBlock = this.field_70170_p.func_147439_a(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d);
                Material mat = hitBlock.func_149688_o();
                if (hitBlock == Blocks.field_150329_H || mat == Material.field_151585_k) {
                    return;
                }
            }
            if (movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPixelmon) {
                this.pixelmon = (EntityPixelmon)movingobjectposition.field_72308_g;
                this.pokemonPosX = this.pixelmon.field_70165_t;
                this.pokemonPosY = this.pixelmon.field_70163_u;
                this.pokemonPosZ = this.pixelmon.field_70161_v;
                if (this.pixelmon.battleController != null) {
                    ChatHandler.sendChat((Entity)((EntityPlayer)this.field_70192_c), "pixelmon.pokeballs.pokeinbattle", new Object[0]);
                    if (this.dropItem) {
                        this.func_70099_a(new ItemStack((Item)this.getType().getItem()), 0.0f);
                    }
                    this.func_70106_y();
                    return;
                }
                if (this.pixelmon.getBossMode() != EnumBossMode.NotBoss) {
                    ChatHandler.sendChat((Entity)((EntityPlayer)this.field_70192_c), "pixelmon.pokeballs.boss", new Object[0]);
                    this.func_70106_y();
                    return;
                }
                if (this.pixelmon.hasOwner() || this.pixelmon.getTrainer() != null) {
                    if (this.pixelmon.func_70902_q() == this.field_70192_c) {
                        ChatHandler.sendChat((Entity)((EntityPlayer)this.field_70192_c), "pixelmon.pokeballs.alreadyown", new Object[0]);
                    } else {
                        ChatHandler.sendChat((Entity)((EntityPlayer)this.field_70192_c), "pixelmon.pokeballs.otherspokemon", new Object[0]);
                    }
                    if (this.dropItem) {
                        this.func_70099_a(new ItemStack((Item)this.getType().getItem()), 0.0f);
                    }
                    this.func_70106_y();
                    return;
                }
                if (this.pixelmon.hitByPokeball != null) {
                    if (this.dropItem) {
                        this.func_70099_a(new ItemStack((Item)this.getType().getItem()), 0.0f);
                    }
                    this.func_70106_y();
                    return;
                }
                this.pixelmon.hitByPokeball = this;
                if (!this.getIsWaiting()) {
                    this.doCaptureCalc(this.pixelmon);
                    this.pixelmon.field_70179_y = 0.0;
                    this.pixelmon.field_70181_x = 0.0;
                    this.pixelmon.field_70159_w = 0.0;
                    this.initialScale = this.pixelmon.getPixelmonScale();
                    this.setAnimation("bounceOpen");
                    this.setIsWaiting(true);
                    this.setId(this.canCatch ? this.numShakes : -1 * this.numShakes);
                    this.field_70181_x = 0.0;
                    this.field_70159_w = 0.0;
                    this.field_70179_y = 0.0;
                    this.field_70125_A = 0.0f;
                    int i = -2;
                    while (!this.field_70170_p.func_147437_c((int)this.field_70165_t, (int)Math.ceil(this.field_70163_u) + i, (int)this.field_70161_v)) {
                        ++i;
                    }
                    this.field_70163_u = Math.ceil(this.field_70163_u) + (double)i + (double)0.1f;
                }
            } else if (this.getIsWaiting()) {
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.setIsOnGround(true);
            } else {
                Material mat = this.field_70170_p.func_147439_a(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d).func_149688_o();
                if (!this.getIsWaiting() && mat != null && mat.func_76220_a()) {
                    if (this.dropItem) {
                        this.func_70099_a(new ItemStack((Item)this.getType().getItem()), 0.0f);
                    }
                    this.func_70106_y();
                }
            }
        }
        super.func_70184_a(movingobjectposition);
    }

    @Override
    public void func_70071_h_() {
        if (this.getIsOnGround()) {
            ++this.waitTime;
        }
        if (this.capturedPokemon) {
            if (this.waitTime > 20) {
                try {
                    this.pixelmon.func_70903_f(true);
                    this.pixelmon.func_152115_b(((EntityPlayer)this.field_70192_c).func_110124_au().toString());
                    this.pixelmon.caughtBall = this.getType();
                    this.pixelmon.clearAttackTarget();
                    this.pixelmon.friendship.initFromCapture();
                    PokeballTypeHelper.doAfterEffect(this.getType(), this.pixelmon);
                    PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.field_70192_c).addToParty(this.pixelmon);
                    Pixelmon.EVENT_BUS.post((Event)new PixelmonRecievedEvent((EntityPlayer)this.field_70192_c, ReceiveType.PokeBall, this.pixelmon));
                    this.pixelmon.catchInPokeball();
                    if (this.getMode() == EntityPokeBall.Mode.battle) {
                        PlayerParticipant p = (PlayerParticipant)this.battleController.getParticipantForEntity(this.field_70192_c);
                        Experience.awardExp(this.battleController.participants, p, this.pixelmon);
                        this.battleController.endBattleWithoutXP();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setIsWaiting(false);
                this.func_70106_y();
            }
        } else if (this.waitTime > this.numShakes * 25) {
            this.catchPokemon();
            this.waitTime = 0;
        }
        super.func_70071_h_();
    }

    protected void catchPokemon() {
        if (this.canCatch) {
            ChatHandler.sendChat((Entity)((EntityPlayer)this.field_70192_c), "pixelmon.pokeballs.capture", this.pixelmon.getLocalizedName());
            Pixelmon.EVENT_BUS.post((Event)new PixelmonCaptureEvent((EntityPlayer)this.field_70192_c, this.pixelmon));
            this.capturedPokemon = true;
            this.waitTime = 0;
            PixelmonAchievements.captureChieves((EntityPlayer)this.field_70192_c, this.pixelmon);
        } else {
            this.openAngle = -1.5707964f;
            this.waitTime = 0;
            this.setIsWaiting(false);
            this.pixelmon.func_70107_b(this.pokemonPosX, this.pokemonPosY, this.pokemonPosZ);
            this.pixelmon.battleController = this.battleController;
            this.pixelmon.hitByPokeball = null;
            if (this.field_70170_p.func_73045_a(this.pixelmon.func_145782_y()) != null) {
                this.pixelmon.unloadEntity();
            }
            this.field_70170_p.func_72838_d((Entity)this.pixelmon);
            this.pixelmon.func_70107_b(this.pokemonPosX, this.pokemonPosY, this.pokemonPosZ);
            this.pixelmon.setPixelmonScale(this.initialScale);
            this.pixelmon.field_70128_L = false;
            if (this.getMode() == EntityPokeBall.Mode.battle) {
                this.battleController.endPause();
            }
            this.func_70106_y();
        }
    }

    public void func_70106_y() {
        if (this.pixelmon != null && this.pixelmon.hitByPokeball == this) {
            this.pixelmon.hitByPokeball = null;
        }
        super.func_70106_y();
    }
}

