/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pokeballs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballBase;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ReleasePokemon;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeballTypeHelper;
import com.pixelmonmod.pixelmon.enums.EnumPokeballs;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityPokeBall
extends EntityThrowable {
    protected static final int dwPokeballType = 10;
    protected static final int dwIsWaiting = 11;
    protected static final int dwIsOnGround = 12;
    protected static final int dwInitialYaw = 13;
    protected static final int dwAnimation = 14;
    protected static final int dwId = 15;
    protected static final int dwInitialPitch = 16;
    protected static final int dwMode = 17;
    protected final int ticksPerShake = 25;
    public int waitTimer;
    public static float scale = 0.0033333334f;
    protected EntityLivingBase field_70192_c;
    public EntityPixelmon pixelmon;
    public int shakePokeball;
    protected float endRotationYaw = 0.0f;
    public boolean dropItem;
    protected boolean canCatch = false;
    public float openAngle = 0.0f;
    int numRocks = 0;
    boolean isUnloaded = false;
    Vec3 initPos;
    Vec3 diff;
    float initialScale;
    public IncrementingVariable inc;
    public boolean firstContact = true;
    public boolean pausing = false;
    public String lastAnim = "";
    public int shakeCount = 0;
    private boolean startCapture = true;
    private String[] anims = new String[]{"shakeLeft", "shakeRight"};
    private int capture1 = 0;
    private int capture2 = 0;
    int numShakes = 0;
    private int b;
    ModelPokeballBase model = null;

    public EntityPokeBall(World world) {
        super(world);
        this.field_70180_af.func_75682_a(10, (Object)EnumPokeballs.PokeBall.getIndex());
        this.field_70180_af.func_75682_a(11, (Object)0);
        this.field_70180_af.func_75682_a(12, (Object)0);
        this.field_70180_af.func_75682_a(13, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(16, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(14, (Object)"idle");
        this.field_70180_af.func_75682_a(15, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    public EntityPokeBall(EnumPokeballs type, World world, EntityLivingBase thrower, Mode mode) {
        super(world, thrower);
        this.field_70180_af.func_75682_a(10, (Object)type.getIndex());
        this.field_70180_af.func_75682_a(11, (Object)0);
        this.field_70180_af.func_75682_a(12, (Object)0);
        this.field_70180_af.func_75682_a(13, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(16, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(14, (Object)"idle");
        this.field_70180_af.func_75682_a(15, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)((short)mode.ordinal()));
    }

    public void init() {
    }

    protected void func_70184_a(MovingObjectPosition movingobjectposition) {
        if (this.getIsWaiting()) {
            return;
        }
    }

    public Item breakBall() {
        return PixelmonItemsPokeballs.getLidFromEnum(this.getType());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.model != null) {
            if (this.inc == null) {
                this.inc = new IncrementingVariable(1.0f, 2.1474836E9f);
            }
            this.inc.tick();
            this.model.doAnimation((Entity)this);
        }
        if (this.getMode() == Mode.full && this.getIsWaiting()) {
            this.field_70177_z = -1.0f * this.getInitialYaw();
            if (this.waitTimer > 0) {
                --this.waitTimer;
            }
            if (this.firstContact) {
                this.field_70181_x = 0.3;
                this.firstContact = false;
            } else if (this.field_70181_x <= 0.0 && !this.pausing) {
                this.waitTimer = 2;
                this.pausing = true;
            }
            if (this.waitTimer > 0) {
                this.field_70181_x = 0.0;
            } else if (this.pausing && this.waitTimer == 0) {
                if (!this.getAnimation().equalsIgnoreCase("bounceClose")) {
                    this.field_70181_x = 0.2;
                    this.field_70159_w = 0.2 * (double)((float)Math.cos((double)this.getInitialYaw() * Math.PI / 180.0 - 1.5707963267948966));
                    this.field_70179_y = 0.2 * (double)((float)Math.sin((double)this.getInitialYaw() * Math.PI / 180.0 - 1.5707963267948966));
                }
                if (!this.getAnimation().equalsIgnoreCase("bounceClose") && this.field_70170_p.field_72995_K) {
                    this.setAnimation("bounceClose");
                    this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "pixelmon:pixelmon.block.PokeballClose", 0.1f, 1.0f, false);
                    this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "pixelmon:pixelmon.block.PokeballRelease", 0.2f, 1.0f, false);
                }
                if (this.field_70170_p.field_72995_K) {
                    Pixelmon.network.sendToServer((IMessage)new ReleasePokemon(this.getId()));
                }
                --this.waitTimer;
            }
        }
        if ((this.getMode() == Mode.empty || this.getMode() == Mode.battle && !this.getIsOnGround()) && this.getIsWaiting()) {
            if (this.waitTimer > 0) {
                --this.waitTimer;
            }
            if (this.firstContact) {
                this.field_70181_x = 0.3;
                this.firstContact = false;
            } else if (this.field_70181_x <= 0.0 && !this.pausing) {
                this.waitTimer = 25;
                this.pausing = true;
                if (!this.field_70170_p.field_72995_K) {
                    this.initialScale = this.pixelmon.getPixelmonScale();
                    this.initPos = Vec3.func_72443_a((double)this.pixelmon.field_70165_t, (double)this.pixelmon.field_70163_u, (double)this.pixelmon.field_70161_v);
                    Vec3 current = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
                    current.field_72450_a -= this.initPos.field_72450_a;
                    current.field_72448_b -= this.initPos.field_72448_b;
                    current.field_72449_c -= this.initPos.field_72449_c;
                    this.diff = current;
                }
            }
            if (this.waitTimer > 0) {
                this.field_70181_x = 0.0;
                if (this.waitTimer < 20 && !this.field_70170_p.field_72995_K) {
                    if (this.startCapture) {
                        this.field_70170_p.func_72956_a((Entity)this.pixelmon, "pixelmon:pixelmon.block.PokeballCapture", 0.2f, 1.0f);
                        this.startCapture = false;
                    }
                    this.pixelmon.setPixelmonScale(this.initialScale * (float)Math.pow(0.5, (20 - this.waitTimer) / 5));
                    this.moveCloser((float)Math.pow(0.5, (20 - this.waitTimer) / 5));
                }
                if (this.waitTimer == 1 && !this.field_70170_p.field_72995_K) {
                    this.pixelmon.unloadEntity();
                    this.setAnimation("bounceClose");
                    this.field_70170_p.func_72956_a((Entity)this.pixelmon, "pixelmon:pixelmon.block.PokeballClose", 0.1f, 1.0f);
                }
            }
        }
        if (!this.getIsWaiting() && !this.getIsOnGround()) {
            this.field_70177_z += 50.0f;
        } else if (this.getIsOnGround()) {
            this.field_70181_x = 0.0;
            if (this.getMode() == Mode.empty || this.getMode() == Mode.battle && this.field_70170_p.field_72995_K) {
                if (this.waitTimer > 0) {
                    --this.waitTimer;
                }
                if (this.waitTimer <= 0 && this.shakeCount < Math.abs(this.getId())) {
                    ++this.shakeCount;
                    this.chooseAnimation();
                    if (this.inc != null) {
                        this.inc.value = 0.0f;
                    }
                    this.waitTimer = 25;
                }
            }
        }
    }

    private void chooseAnimation() {
        this.setAnimation(this.anims[RandomHelper.getRandomNumberBetween(0, this.anims.length - 1)]);
    }

    protected void moveCloser(float percent) {
        Vec3 newVec = this.initPos.func_72441_c(this.diff.field_72450_a * (double)(1.0f - percent), this.diff.field_72448_b * (double)(1.0f - percent), this.diff.field_72449_c * (double)(1.0f - percent));
        this.pixelmon.field_70165_t = newVec.field_72450_a;
        this.pixelmon.field_70142_S = newVec.field_72450_a;
        this.pixelmon.field_70163_u = newVec.field_72448_b;
        this.pixelmon.field_70137_T = newVec.field_72448_b;
        this.pixelmon.field_70161_v = newVec.field_72449_c;
        this.pixelmon.field_70136_U = newVec.field_72449_c;
    }

    public void func_70030_z() {
        if (this.getIsOnGround()) {
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        }
    }

    public void premierFlash() {
        if (this.getType() == EnumPokeballs.PremierBall) {
            this.field_70170_p.func_72869_a("reddust", this.field_70165_t + 0.1, this.field_70163_u + 0.05, this.field_70161_v, 255.0, 250.0, 250.0);
        }
    }

    public void onCaptureEffect() {
        if (this.capture2 == 0 && this.pausing) {
            if (this.getType() == EnumPokeballs.PremierBall) {
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t, this.field_70163_u + 0.4, this.field_70161_v, 255.0, 250.0, 250.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t, this.field_70163_u - 0.4, this.field_70161_v, 255.0, 250.0, 250.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t + 0.2, this.field_70163_u + 0.2, this.field_70161_v, 255.0, 250.0, 250.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t - 0.2, this.field_70163_u + 0.2, this.field_70161_v, 255.0, 250.0, 250.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t + 0.2, this.field_70163_u - 0.2, this.field_70161_v, 255.0, 250.0, 250.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t - 0.2, this.field_70163_u - 0.2, this.field_70161_v, 255.0, 250.0, 250.0);
            }
            if (this.getType() == EnumPokeballs.MasterBall) {
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t, this.field_70163_u + 0.4, this.field_70161_v, 148.0, 0.0, 211.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t, this.field_70163_u - 0.4, this.field_70161_v, 148.0, 0.0, 211.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t + 0.2, this.field_70163_u + 0.2, this.field_70161_v, 148.0, 0.0, 211.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t - 0.2, this.field_70163_u + 0.2, this.field_70161_v, 148.0, 0.0, 211.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t + 0.2, this.field_70163_u - 0.2, this.field_70161_v, 148.0, 0.0, 211.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t - 0.2, this.field_70163_u - 0.2, this.field_70161_v, 148.0, 0.0, 211.0);
            }
            this.capture2 = 1;
        }
    }

    public void successfulCaptureEffect() {
        if (this.capture1 == 0) {
            this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "pixelmon:pixelmon.block.PokeballCaptureSuccess", 0.07f, 1.0f, false);
            if (this.getType() == EnumPokeballs.PremierBall) {
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t, this.field_70163_u + 0.8, this.field_70161_v, 255.0, 250.0, 250.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t + 0.5, this.field_70163_u + 0.6, this.field_70161_v, 255.0, 250.0, 250.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t - 0.5, this.field_70163_u + 0.6, this.field_70161_v, 255.0, 250.0, 250.0);
            } else {
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t, this.field_70163_u + 0.8, this.field_70161_v, 255.0, 255.0, 0.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t + 0.5, this.field_70163_u + 0.6, this.field_70161_v, 255.0, 255.0, 0.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t - 0.5, this.field_70163_u + 0.6, this.field_70161_v, 255.0, 255.0, 0.0);
            }
            this.capture1 = 1;
        }
    }

    public void releaseEffect() {
        if (this.capture1 == 0) {
            if (this.getType() == EnumPokeballs.PremierBall) {
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t, this.field_70163_u + 0.4, this.field_70161_v, 0.0, 0.0, 0.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t, this.field_70163_u - 0.4, this.field_70161_v, 0.0, 0.0, 0.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t + 0.2, this.field_70163_u + 0.2, this.field_70161_v, 0.0, 0.0, 0.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t - 0.2, this.field_70163_u + 0.2, this.field_70161_v, 0.0, 0.0, 0.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t + 0.2, this.field_70163_u - 0.2, this.field_70161_v, 0.0, 0.0, 0.0);
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t - 0.2, this.field_70163_u - 0.2, this.field_70161_v, 0.0, 0.0, 0.0);
            }
            this.capture1 = 1;
        }
    }

    protected void doCaptureCalc(EntityPixelmon p2) {
        if (this.getType() == EnumPokeballs.MasterBall) {
            this.canCatch = true;
            this.numShakes = 4;
            return;
        }
        int passedShakes = 0;
        int pokemonRate = p2.getCatchRate();
        pokemonRate = PokeballTypeHelper.modifyCaptureRate(this.getType(), p2.getName(), pokemonRate);
        if (pokemonRate > 0) {
            float hpMax = p2.func_110138_aP();
            float hpCurrent = p2.func_110143_aJ();
            double bonusStatus = 1.0;
            double ballBonus = PokeballTypeHelper.getBallBonus(this.getType(), this.field_70192_c, p2, this.getMode());
            if (p2.hasStatus(StatusType.Sleep) || p2.hasStatus(StatusType.Freeze)) {
                bonusStatus = 2.0;
            } else if (p2.hasStatus(StatusType.Paralysis) || p2.hasStatus(StatusType.Poison) || p2.hasStatus(StatusType.Burn)) {
                bonusStatus = 1.5;
            }
            double a = (double)((3.0f * hpMax - 2.0f * hpCurrent) * (float)pokemonRate) * ballBonus / (double)(3.0f * hpMax) * bonusStatus;
            double b = (double)Math.round(Math.pow(255.0 / a, 0.25) * 4096.0) / 4096.0;
            b = Math.floor(65536.0 / b);
            if (b != 0.0) {
                if (a < 255.0) {
                    for (int i = 0; i < 4; ++i) {
                        int roll = new Random().nextInt(65536);
                        if (!((double)roll <= b)) continue;
                        ++passedShakes;
                    }
                } else {
                    this.canCatch = true;
                    this.numShakes = 4;
                    return;
                }
            }
        }
        this.canCatch = passedShakes == 4;
        this.numShakes = passedShakes;
    }

    public EnumPokeballs getType() {
        return EnumPokeballs.getFromIndex(this.field_70180_af.func_75679_c(10));
    }

    protected void setIsWaiting(boolean value) {
        this.field_70180_af.func_75692_b(11, (Object)(value ? (short)1 : 0));
    }

    public boolean getIsWaiting() {
        return this.field_70180_af.func_75693_b(11) == 1;
    }

    protected void setIsOnGround(boolean value) {
        this.field_70180_af.func_75692_b(12, (Object)(value ? (short)1 : 0));
    }

    protected boolean getIsOnGround() {
        return this.field_70180_af.func_75693_b(12) == 1;
    }

    public void setAnimation(String animation) {
        this.field_70180_af.func_75692_b(14, (Object)animation);
    }

    public String getAnimation() {
        return this.field_70180_af.func_75681_e(14);
    }

    public int getId() {
        return this.field_70180_af.func_75679_c(15);
    }

    public void setId(int id) {
        this.field_70180_af.func_75692_b(15, (Object)id);
    }

    public float getInitialYaw() {
        return this.field_70180_af.func_111145_d(13);
    }

    public void setInitialYaw(float yaw) {
        this.field_70180_af.func_75692_b(13, (Object)Float.valueOf(yaw));
    }

    public float getInitialPitch() {
        return this.field_70180_af.func_111145_d(16);
    }

    public void setInitialPitch(float pitch) {
        this.field_70180_af.func_75692_b(16, (Object)Float.valueOf(pitch));
    }

    public Mode getMode() {
        return Mode.getFromOrdinal(this.field_70180_af.func_75693_b(17));
    }

    public ModelPokeballBase getModel() {
        if (this.model == null) {
            this.model = Pixelmon.proxy.loadPokeballModel(this.getType().getModel());
        }
        return this.model;
    }

    public static enum Mode {
        empty,
        full,
        battle;


        public static Mode getFromOrdinal(short ordinal) {
            for (Mode m : Mode.values()) {
                if (m.ordinal() != ordinal) continue;
                return m;
            }
            return null;
        }
    }
}

