/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pokeballs.captures;

import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityPokeBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureBase;
import com.pixelmonmod.pixelmon.enums.EnumPokeballs;
import net.minecraft.entity.player.EntityPlayer;

public class CaptureLevelBall
extends CaptureBase {
    public CaptureLevelBall() {
        super(EnumPokeballs.LevelBall);
    }

    @Override
    public double getBallBonus(EnumPokeballs type, EntityPlayer thrower, EntityPixelmon p2, EntityPokeBall.Mode mode) {
        double ballBonus = this.pokeball.getBallBonus();
        if (mode == EntityPokeBall.Mode.battle) {
            BattleControllerBase bc = BattleRegistry.getBattle(thrower);
            if (bc == null) {
                return ballBonus;
            }
            int ownerPokemonLevel = 0;
            for (BattleParticipant p : bc.participants) {
                if (!(p instanceof PlayerParticipant) || p.getEntity() != thrower) continue;
                for (PixelmonWrapper pw : p.controlledPokemon) {
                    if (pw.pokemon.getLvl().getLevel() <= ownerPokemonLevel) continue;
                    ownerPokemonLevel = pw.pokemon.getLvl().getLevel();
                }
            }
            if (ownerPokemonLevel > p2.getLvl().getLevel()) {
                ballBonus = 2.0;
            }
            if (ownerPokemonLevel > 2 * p2.getLvl().getLevel()) {
                ballBonus = 4.0;
            }
            if (ownerPokemonLevel > 4 * p2.getLvl().getLevel()) {
                ballBonus = 8.0;
            }
        }
        return ballBonus;
    }
}

