/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.config.PixelmonGen;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.world.biome.BiomeGenBase;

public enum EnumBiomes {
    Beach("Beach", BiomeGenBase.field_76787_r),
    Desert("Desert", BiomeGenBase.field_76769_d),
    DesertHills("DesertHills", BiomeGenBase.field_76786_s),
    Forest("Forest", BiomeGenBase.field_76767_f),
    ForestHills("ForestHills", BiomeGenBase.field_76785_t),
    IcePlains("IcePlains", BiomeGenBase.field_76774_n),
    IceMountain("IceMountains", BiomeGenBase.field_76775_o),
    Jungle("Jungle", BiomeGenBase.field_76782_w),
    JungleHills("JungleHills", BiomeGenBase.field_76792_x),
    Mountain("ExtremeHills", BiomeGenBase.field_76770_e),
    MountainEdge("ExtremeHillsEdge", BiomeGenBase.field_76783_v),
    Mushroom("MushroomIsland", BiomeGenBase.field_76789_p),
    MushroomShore("MushroomIslandShore", BiomeGenBase.field_76788_q),
    Plains("Plains", BiomeGenBase.field_76772_c),
    Swamp("SwampLand", BiomeGenBase.field_76780_h),
    Taiga("Taiga", BiomeGenBase.field_76768_g),
    TaigaHills("TaigaHills", BiomeGenBase.field_76784_u),
    FrozenOcean("FrozenOcean", BiomeGenBase.field_76776_l),
    FrozenRiver("FrozenRiver", BiomeGenBase.field_76777_m),
    Ocean("Ocean", BiomeGenBase.field_76771_b),
    River("River", BiomeGenBase.field_76781_i),
    Nether("Hell", BiomeGenBase.field_76778_j),
    Sky("Sky", BiomeGenBase.field_76779_k),
    MysteryValley("ShrineFalls", PixelmonGen.mysteryValley);

    private BiomeGenBase biome;
    private String name;

    private EnumBiomes(String s, BiomeGenBase b) {
        this.name = s;
        this.biome = b;
    }

    public BiomeGenBase getBiome() {
        return this.biome;
    }

    public String getName() {
        return this.name;
    }

    public static EnumBiomes parseBiome(String name) {
        for (EnumBiomes b : EnumBiomes.values()) {
            if (!b.name.equalsIgnoreCase(name)) continue;
            return b;
        }
        return null;
    }

    public static ArrayList<EnumBiomes> getAllBiomes() {
        ArrayList<EnumBiomes> list = new ArrayList<EnumBiomes>();
        EnumBiomes[] t = EnumBiomes.values();
        Collections.addAll(list, t);
        return list;
    }

    public static boolean hasBiome(String name) {
        try {
            return EnumBiomes.valueOf(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

