/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import java.awt.Color;
import java.util.Random;

public enum EnumBossMode {
    NotBoss(0, -1, Color.WHITE, 1.0f, 0, 0),
    Uncommon(1, 40, Color.GREEN, 1.2f, 5, 1),
    Rare(2, 30, Color.CYAN, 1.4f, 10, 2),
    Legendary(3, 20, Color.RED, 1.6f, 20, 3),
    Ultimate(4, 10, Color.YELLOW, 1.8f, 40, 5);

    public int index;
    public int rarity;
    public Color colour;
    public float scaleFactor;
    public int extraLevels;
    public int numDroppedItems = 0;
    public float r;
    public float g;
    public float b;

    private EnumBossMode(int index, int rarity, Color colour, float scaleFactor, int extraLevels, int numDroppedItems) {
        this.index = index;
        this.rarity = rarity;
        this.colour = colour;
        this.scaleFactor = scaleFactor;
        this.extraLevels = extraLevels;
        this.numDroppedItems = numDroppedItems;
        if (colour == Color.CYAN) {
            this.r = 0.5f;
            this.g = 1.0f;
            this.b = 1.0f;
        } else if (colour == Color.GREEN) {
            this.r = 0.5f;
            this.g = 1.0f;
            this.b = 0.5f;
        } else if (colour == Color.RED) {
            this.r = 1.0f;
            this.g = 0.5f;
            this.b = 0.5f;
        } else if (colour == Color.YELLOW) {
            this.r = 1.0f;
            this.g = 1.0f;
            this.b = 0.5f;
        }
    }

    public static EnumBossMode getMode(int index) {
        try {
            return EnumBossMode.values()[index];
        }
        catch (Exception npe) {
            return null;
        }
    }

    public static EnumBossMode getRandomMode() {
        int val = new Random().nextInt(100);
        int total = 0;
        for (EnumBossMode b : EnumBossMode.values()) {
            if (b.rarity == -1 || val > (total += b.rarity)) continue;
            return b;
        }
        return null;
    }

    public int getColourInt() {
        if (this.colour == Color.WHITE) {
            return -1;
        }
        if (this.colour == Color.GREEN) {
            return 500000;
        }
        if (this.colour == Color.CYAN) {
            return 100000;
        }
        if (this.colour == Color.RED) {
            return -65280;
        }
        if (this.colour == Color.YELLOW) {
            return -255;
        }
        return -1;
    }

    public static EnumBossMode getNextMode(EnumBossMode bossMode) {
        int index = bossMode.ordinal();
        index = index == EnumBossMode.values().length - 1 ? 0 : ++index;
        for (EnumBossMode e : EnumBossMode.values()) {
            if (e.ordinal() != index) continue;
            return e;
        }
        return null;
    }

    public static boolean hasBossMode(String name) {
        try {
            return EnumBossMode.valueOf(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

