/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.config.PixelmonItems;
import net.minecraft.item.Item;

public enum EnumEthers {
    Ether(178, false, false, "ether"),
    MaxEther(194, true, false, "maxether"),
    Elixir(210, false, true, "elixir"),
    MaxElixir(226, true, true, "maxelixir");

    private boolean allPP;
    private boolean allMoves;
    private int index;
    private String filenamePrefix;

    private EnumEthers(int index, boolean allPP, boolean allMoves, String filenamePrefix) {
        this.allPP = allPP;
        this.allMoves = allMoves;
        this.index = index;
        this.filenamePrefix = filenamePrefix;
    }

    public boolean restoresAllPP() {
        return this.allPP;
    }

    public boolean restoresAllMoves() {
        return this.allMoves;
    }

    public int getIndex() {
        return this.index;
    }

    public Item getItem() {
        if (this.index == 178) {
            return PixelmonItems.ether;
        }
        if (this.index == 194) {
            return PixelmonItems.maxEther;
        }
        if (this.index == 210) {
            return PixelmonItems.elixir;
        }
        if (this.index == 226) {
            return PixelmonItems.maxElixir;
        }
        return PixelmonItems.potion;
    }

    public String getTexture() {
        return this.filenamePrefix;
    }

    public static EnumEthers getFromIndex(int index) {
        if (index == 178) {
            return Ether;
        }
        if (index == 194) {
            return MaxEther;
        }
        if (index == 210) {
            return Elixir;
        }
        if (index == 226) {
            return MaxElixir;
        }
        return Ether;
    }

    public static boolean hasEther(String name) {
        try {
            return EnumEthers.valueOf(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

