/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelCherishBall;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelGreatBall;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelHeavyBall;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelMasterBall;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelNetBall;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeball;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelTimerBall;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.enums.EnumApricorns;
import com.pixelmonmod.pixelmon.items.IEnumItem;
import com.pixelmonmod.pixelmon.items.ItemPokeball;
import com.pixelmonmod.pixelmon.items.ItemPokeballDisc;
import com.pixelmonmod.pixelmon.items.ItemPokeballLid;
import net.minecraft.item.Item;

public enum EnumPokeballs implements IEnumItem
{
    PokeBall(0, 1.0, "pokeball", new EnumApricorns[]{EnumApricorns.Red, EnumApricorns.Red, EnumApricorns.Red}, 5, 15),
    GreatBall(1, 1.5, "greatball", new EnumApricorns[]{EnumApricorns.Blue, EnumApricorns.Red, EnumApricorns.Blue}, 2, 35),
    UltraBall(2, 2.0, "ultraball", new EnumApricorns[]{EnumApricorns.Black, EnumApricorns.Yellow, EnumApricorns.Black}, 1, 55),
    MasterBall(3, 255.0, "masterball", null, 0, 0),
    LevelBall(4, 1.0, "levelball", new EnumApricorns[]{EnumApricorns.Black, EnumApricorns.Red, EnumApricorns.Yellow}, 2, 35),
    MoonBall(5, 1.0, "moonball", new EnumApricorns[]{EnumApricorns.Blue, EnumApricorns.Yellow, EnumApricorns.Black}, 2, 35),
    FriendBall(6, 1.0, "friendball", new EnumApricorns[]{EnumApricorns.Green, EnumApricorns.Yellow, EnumApricorns.Red}, 3, 35),
    LoveBall(7, 1.0, "loveball", new EnumApricorns[]{EnumApricorns.Pink, EnumApricorns.Pink, EnumApricorns.Pink}, 3, 35),
    SafariBall(8, -1.0, "safariball", new EnumApricorns[]{EnumApricorns.Green, EnumApricorns.Green, EnumApricorns.Yellow}, 3, 35),
    HeavyBall(9, 1.0, "heavyball", new EnumApricorns[]{EnumApricorns.Blue, EnumApricorns.Blue, EnumApricorns.Blue}, 3, 35),
    FastBall(10, 1.0, "fastball", new EnumApricorns[]{EnumApricorns.Red, EnumApricorns.Yellow, EnumApricorns.Red}, 3, 35),
    RepeatBall(11, 1.0, "repeatball", new EnumApricorns[]{EnumApricorns.Red, EnumApricorns.Black, EnumApricorns.Red}, 3, 35),
    TimerBall(12, 1.0, "timerball", new EnumApricorns[]{EnumApricorns.Red, EnumApricorns.Black, EnumApricorns.White}, 3, 35),
    NestBall(13, 1.0, "nestball", new EnumApricorns[]{EnumApricorns.Green, EnumApricorns.Yellow, EnumApricorns.Green}, 3, 35),
    NetBall(14, 1.0, "netball", new EnumApricorns[]{EnumApricorns.Black, EnumApricorns.Blue, EnumApricorns.Black}, 3, 35),
    DiveBall(15, 1.0, "diveball", new EnumApricorns[]{EnumApricorns.Blue, EnumApricorns.Pink, EnumApricorns.Blue}, 3, 35),
    LuxuryBall(16, 1.0, "luxuryball", new EnumApricorns[]{EnumApricorns.Black, EnumApricorns.Red, EnumApricorns.White}, 3, 35),
    HealBall(17, 1.0, "healball", new EnumApricorns[]{EnumApricorns.White, EnumApricorns.Pink, EnumApricorns.White}, 3, 35),
    DuskBall(18, 1.0, "duskball", new EnumApricorns[]{EnumApricorns.Green, EnumApricorns.Black, EnumApricorns.Green}, 3, 35),
    PremierBall(19, 1.0, "premierball", new EnumApricorns[]{EnumApricorns.White, EnumApricorns.Red, EnumApricorns.White}, 3, 25),
    SportBall(20, 1.0, "sportball", new EnumApricorns[]{EnumApricorns.Red, EnumApricorns.White, EnumApricorns.Red}, 3, 25),
    QuickBall(21, 1.0, "quickball", new EnumApricorns[]{EnumApricorns.Blue, EnumApricorns.Yellow, EnumApricorns.Blue}, 3, 35),
    ParkBall(22, 255.0, "parkball", null, 0, 0),
    LureBall(23, 1.0, "lureball", new EnumApricorns[]{EnumApricorns.Green, EnumApricorns.Red, EnumApricorns.Green}, 3, 35),
    CherishBall(24, 1.0, "cherishball", null, 0, 0),
    GSBall(25, 1.0, "gsball", null, 0, 0);

    private double ballBonus;
    private int index;
    private String directory;
    private String filenamePrefix;
    private int iconIndex;
    public EnumApricorns[] recipe;
    public int quantityMade;
    public int breakChance;

    private EnumPokeballs(int index, double ballBonus, String filenamePrefix, EnumApricorns[] recipe, int quantityMade, int chanceBreak) {
        this.ballBonus = ballBonus;
        this.index = index;
        this.filenamePrefix = filenamePrefix;
        this.recipe = recipe;
        this.quantityMade = quantityMade;
        this.breakChance = chanceBreak;
    }

    public double getBallBonus() {
        return this.ballBonus;
    }

    public int getIndex() {
        return this.index;
    }

    public int getBreakChance() {
        return this.breakChance;
    }

    public String getTexture() {
        return this.filenamePrefix + ".png";
    }

    public String getFlashRedTexture() {
        return this.filenamePrefix + "flashing.png";
    }

    public String getCaptureTexture() {
        return this.filenamePrefix + "captured.png";
    }

    public static EnumPokeballs getFromIndex(int index) {
        return index >= 0 && index < EnumPokeballs.values().length ? EnumPokeballs.values()[index] : PokeBall;
    }

    public ItemPokeball getItem() {
        return PixelmonItemsPokeballs.getItemFromEnum(this);
    }

    public ItemPokeballLid getLid() {
        return PixelmonItemsPokeballs.getLidFromEnum(this);
    }

    public ItemPokeballDisc getDisc() {
        return PixelmonItemsPokeballs.getDiscFromEnum(this);
    }

    @Override
    public Item getItem(int type) {
        switch (type) {
            case 0: {
                return this.getItem();
            }
            case 1: {
                return this.getLid();
            }
            case 2: {
                return this.getDisc();
            }
        }
        return null;
    }

    @Override
    public int numTypes() {
        return 3;
    }

    public static boolean hasPokeball(String pokeball) {
        try {
            return EnumPokeballs.valueOf(pokeball) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getTextureDirectory() {
        String path = "pixelmon:textures/pokeballs/";
        if (PixelmonConfig.useLowResTextures) {
            path = "pixelmon:low-res/pokeballs/";
        }
        return this.directory == null ? path : this.directory;
    }

    public void setTextureDirectory(String newDirectory) {
        try {
            this.directory = newDirectory.charAt(newDirectory.length() - 1) == '/' ? newDirectory : newDirectory + '/';
        }
        catch (NullPointerException e) {
            this.directory = null;
        }
    }

    public Class getModel() {
        if (this == MasterBall) {
            return ModelMasterBall.class;
        }
        if (this == CherishBall) {
            return ModelCherishBall.class;
        }
        if (this == GreatBall) {
            return ModelGreatBall.class;
        }
        if (this == HeavyBall) {
            return ModelHeavyBall.class;
        }
        if (this == NetBall) {
            return ModelNetBall.class;
        }
        if (this == TimerBall) {
            return ModelTimerBall.class;
        }
        return ModelPokeball.class;
    }
}

