/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.items.IEnumItem;
import com.pixelmonmod.pixelmon.items.ItemPotion;
import net.minecraft.item.Item;

public enum EnumPotions implements IEnumItem
{
    Potion(2, 20, 0, "potion"),
    SuperPotion(18, 50, 0, "superpotion"),
    HyperPotion(34, 200, 0, "hyperpotion"),
    MaxPotion(50, 0, 100, "maxpotion"),
    FullRestore(66, 0, 100, "fullrestore"),
    Revive(67, 0, 50, "revive"),
    MaxRevive(68, 0, 100, "maxrevive");

    private int healAmount;
    private int healPercent;
    private int index;
    private String filenamePrefix;

    private EnumPotions(int index, int healAmount, int healPercent, String filenamePrefix) {
        this.healAmount = healAmount;
        this.healPercent = healPercent;
        this.index = index;
        this.filenamePrefix = filenamePrefix;
    }

    public int getHealAmount() {
        return this.healAmount;
    }

    public int getHealPercent() {
        return this.healPercent;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public ItemPotion getItem(int useless) {
        return this.getItem();
    }

    public ItemPotion getItem() {
        Item result = null;
        switch (this) {
            case FullRestore: {
                result = PixelmonItems.fullRestore;
                break;
            }
            case HyperPotion: {
                result = PixelmonItems.hyperPotion;
                break;
            }
            case MaxPotion: {
                result = PixelmonItems.maxPotion;
                break;
            }
            case MaxRevive: {
                result = PixelmonItems.maxRevive;
                break;
            }
            case Potion: {
                result = PixelmonItems.potion;
                break;
            }
            case Revive: {
                result = PixelmonItems.revive;
                break;
            }
            case SuperPotion: {
                result = PixelmonItems.superPotion;
            }
        }
        return (ItemPotion)result;
    }

    public String getTexture() {
        return this.filenamePrefix;
    }

    public static EnumPotions getFromIndex(int index) {
        if (index == 2) {
            return Potion;
        }
        if (index == 18) {
            return SuperPotion;
        }
        if (index == 34) {
            return HyperPotion;
        }
        if (index == 50) {
            return MaxPotion;
        }
        if (index == 66) {
            return FullRestore;
        }
        if (index == 67) {
            return Revive;
        }
        if (index == 68) {
            return MaxRevive;
        }
        return Potion;
    }

    @Override
    public int numTypes() {
        return 1;
    }

    public static boolean hasPotion(String name) {
        try {
            return EnumPotions.valueOf(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

