/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import java.util.Random;
import net.minecraft.world.biome.BiomeGenBase;

public enum EnumScatteredStructure {
    mansion(0, 55, 4, BiomeGenBase.field_76780_h, "mansion"),
    gymRed(1, 10, 2, BiomeGenBase.field_76772_c, "gymRed"),
    moltresSpawn(2, 35, 1, BiomeGenBase.field_76767_f, "moltresSpawn", "Pikachu", 57, 38, 54),
    zapdosSpawn(3, 30, 0, BiomeGenBase.field_76770_e, "zapdosSpawn", "Pikachu", 5, 2, 5);

    public int structureId;
    public int rarity;
    public BiomeGenBase biome;
    public String schematicName;
    public boolean spawnPokemon = false;
    public String pokemonSpawn;
    public int pokemonX;
    public int pokemonZ;
    public int pokemonY;
    public int depthInGround;

    private EnumScatteredStructure(int structureId, int rarity, int depthInGround, BiomeGenBase biome, String schematicName) {
        this.structureId = structureId;
        this.rarity = rarity;
        this.depthInGround = depthInGround;
        this.biome = biome;
        this.schematicName = schematicName;
    }

    private EnumScatteredStructure(int structureId, int rarity, int depthInGround, BiomeGenBase biome, String schematicName, String pokemonSpawn, int pokemonX, int pokemonY, int pokemonZ) {
        this.structureId = structureId;
        this.rarity = rarity;
        this.depthInGround = depthInGround;
        this.biome = biome;
        this.schematicName = schematicName;
        this.spawnPokemon = true;
        this.pokemonSpawn = pokemonSpawn;
        this.pokemonX = pokemonX;
        this.pokemonY = pokemonY;
        this.pokemonZ = pokemonZ;
    }

    public int getRarity() {
        return new Random().nextInt(this.rarity * 10);
    }

    public int getY(int par1) {
        return par1 - this.depthInGround;
    }

    public BiomeGenBase biomeToSpawnIn() {
        return this.biome;
    }

    public String getSchematicPath() {
        return "resources/pixelmon/structures/standAlone/" + this.schematicName + ".schematic";
    }

    public static EnumScatteredStructure getStructureFromBiome(BiomeGenBase biome) {
        for (EnumScatteredStructure e : EnumScatteredStructure.values()) {
            if (e.biomeToSpawnIn() != biome) continue;
            return e;
        }
        return null;
    }

    public static boolean hasScatteredStructure(String name) {
        try {
            return EnumScatteredStructure.valueOf(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

