/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;

public enum EnumTownType {
    basicTown(0, 5, BiomeGenBase.field_76772_c, Blocks.field_150347_e, "resources/pixelmon/structures/basicTown/"),
    desertTown(1, 5, BiomeGenBase.field_76769_d, Blocks.field_150322_A, "resources/pixelmon/structures/desertTown/"),
    snowTown(2, 5, BiomeGenBase.field_76774_n, Blocks.field_150417_aV, "resources/pixelmon/structures/snowTown/");

    public int townId;
    public int rarity;
    public BiomeGenBase biome;
    public Block block;
    public String folderPath;

    private EnumTownType(int townId, int rarity, BiomeGenBase biome, Block pathBlock, String folderPath) {
        this.townId = townId;
        this.rarity = rarity;
        this.biome = biome;
        this.block = pathBlock;
        this.folderPath = folderPath;
    }

    public int getId() {
        return this.townId;
    }

    public int getRarity() {
        return this.rarity;
    }

    public BiomeGenBase getBiome() {
        return this.biome;
    }

    public Block getPathBlock() {
        return this.block;
    }

    public static EnumTownType getTownFromBiome(BiomeGenBase biome) {
        for (EnumTownType e : EnumTownType.values()) {
            if (e.getBiome() != biome) continue;
            return e;
        }
        return null;
    }

    public static EnumTownType getTownFromId(int Id) {
        for (EnumTownType e : EnumTownType.values()) {
            if (e.getId() != Id) continue;
            return e;
        }
        return null;
    }

    public static boolean hasTownType(String name) {
        try {
            return EnumTownType.valueOf(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

