/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.blocks.BlockPC;
import com.pixelmonmod.pixelmon.blocks.BlockRotation;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemBlock
extends PixelmonItem {
    public Block block;

    public ItemBlock(Block block, String textureName, String name) {
        super("blocks/" + textureName, name);
        this.block = block;
        this.func_77637_a(CreativeTabs.field_78031_c);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (side != 1) {
            return false;
        }
        if (world.field_72995_K) {
            return false;
        }
        ++y;
        int direction = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        BlockRotation rot = BlockRotation.Normal;
        if (direction == 0) {
            rot = BlockRotation.getRotationFromMetadata(2);
        }
        if (direction == 1) {
            rot = BlockRotation.getRotationFromMetadata(1);
        }
        if (direction == 2) {
            rot = BlockRotation.getRotationFromMetadata(0);
        }
        if (direction == 3) {
            rot = BlockRotation.getRotationFromMetadata(3);
        }
        if (world.func_147437_c(x, y, z) && world.func_147437_c(x, y + 1, z) && world.func_147445_c(x, y - 1, z, true) && world.func_147439_a(x, y - 1, z) != this.block) {
            if (this.block instanceof BlockPC && world.func_147439_a(x, y + 2, z) == this.block) {
                return false;
            }
            if (this.block instanceof MultiBlock) {
                MultiBlock mb = (MultiBlock)this.block;
                if (!ItemBlock.canPlace(x, y, z, rot, world, mb)) {
                    ChatHandler.sendChat((Entity)player, "Can't place this there!", new Object[0]);
                    return false;
                }
                world.func_147465_d(x, y, z, this.block, rot.metadata, 2);
                this.block.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
                ItemBlock.setMultiBlocksWidth(x, y, z, rot, world, mb, this.block);
            } else {
                world.func_147465_d(x, y, z, this.block, rot.metadata, 2);
                this.block.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public static boolean canPlace(int x, int y, int z, BlockRotation rot, World world, MultiBlock mb) {
        if (rot == BlockRotation.Normal) {
            for (int l = 0; l < mb.length; ++l) {
                if (ItemBlock.canPlaceLength(x, y, z, 0, l, rot, world, mb)) continue;
                return false;
            }
        } else if (rot == BlockRotation.CW) {
            for (int l = 0; l < mb.length; ++l) {
                if (ItemBlock.canPlaceLength(x, y, z, l, 0, rot, world, mb)) continue;
                return false;
            }
        } else if (rot == BlockRotation.Rotate180) {
            for (int l = 0; l < mb.length; ++l) {
                if (ItemBlock.canPlaceLength(x, y, z, 0, -1 * l, rot, world, mb)) continue;
                return false;
            }
        } else {
            for (int l = 0; l < mb.length; ++l) {
                if (ItemBlock.canPlaceLength(x, y, z, -1 * l, 0, rot, world, mb)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canPlaceLength(int x, int y, int z, int xd, int zd, BlockRotation rot, World world, MultiBlock mb) {
        if (rot == BlockRotation.Normal) {
            for (int w = 0; w < mb.width; ++w) {
                if (ItemBlock.canPlaceHeight(x, y, z, xd + w, zd, rot, world, mb)) continue;
                return false;
            }
        } else if (rot == BlockRotation.CW) {
            for (int w = 0; w < mb.width; ++w) {
                if (ItemBlock.canPlaceHeight(x, y, z, xd, zd - w, rot, world, mb)) continue;
                return false;
            }
        } else if (rot == BlockRotation.Rotate180) {
            for (int w = 0; w < mb.width; ++w) {
                if (ItemBlock.canPlaceHeight(x, y, z, xd - w, zd, rot, world, mb)) continue;
                return false;
            }
        } else {
            for (int w = 0; w < mb.width; ++w) {
                if (ItemBlock.canPlaceHeight(x, y, z, xd, zd + w, rot, world, mb)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canPlaceHeight(int x, int y, int z, int xd, int zd, BlockRotation rot, World world, MultiBlock mb) {
        for (int h = 0; h < mb.height; ++h) {
            int meta = rot.metadata;
            if (h > 0) {
                meta = 8;
            } else if (xd > 0) {
                meta = 9;
            } else if (xd < 0) {
                meta = 10;
            } else if (zd > 0) {
                meta = 11;
            } else if (zd < 0) {
                meta = 12;
            }
            if (world.func_147439_a(x + xd, y + h, z + zd).func_149688_o() != Material.field_151579_a) {
                return false;
            }
            if (world.func_147439_a(x + xd, y + h, z + zd).func_149688_o() == Material.field_151597_y || world.func_147439_a(x + xd, y + h, z + zd).func_149688_o() == Material.field_151577_b || world.func_147439_a(x + xd, y + h, z + zd).func_149688_o() == Material.field_151579_a) continue;
            return false;
        }
        return true;
    }

    public static void setMultiBlocksWidth(int x, int y, int z, BlockRotation rot, World world, MultiBlock mb, Block block) {
        if (rot == BlockRotation.Normal) {
            for (int l = 0; l < mb.length; ++l) {
                ItemBlock.setMultiBlocksLength(x, y, z, 0, l, rot, world, mb, block);
            }
        } else if (rot == BlockRotation.CW) {
            for (int l = 0; l < mb.length; ++l) {
                ItemBlock.setMultiBlocksLength(x, y, z, l, 0, rot, world, mb, block);
            }
        } else if (rot == BlockRotation.Rotate180) {
            for (int l = 0; l < mb.length; ++l) {
                ItemBlock.setMultiBlocksLength(x, y, z, 0, -1 * l, rot, world, mb, block);
            }
        } else {
            for (int l = 0; l < mb.length; ++l) {
                ItemBlock.setMultiBlocksLength(x, y, z, -1 * l, 0, rot, world, mb, block);
            }
        }
    }

    private static void setMultiBlocksLength(int x, int y, int z, int xd, int zd, BlockRotation rot, World world, MultiBlock mb, Block block) {
        if (rot == BlockRotation.Normal) {
            for (int w = 0; w < mb.width; ++w) {
                ItemBlock.setMultiBlocksHeight(x, y, z, xd + w, zd, rot, world, mb, block);
            }
        } else if (rot == BlockRotation.CW) {
            for (int w = 0; w < mb.width; ++w) {
                ItemBlock.setMultiBlocksHeight(x, y, z, xd, zd - w, rot, world, mb, block);
            }
        } else if (rot == BlockRotation.Rotate180) {
            for (int w = 0; w < mb.width; ++w) {
                ItemBlock.setMultiBlocksHeight(x, y, z, xd - w, zd, rot, world, mb, block);
            }
        } else {
            for (int w = 0; w < mb.width; ++w) {
                ItemBlock.setMultiBlocksHeight(x, y, z, xd, zd + w, rot, world, mb, block);
            }
        }
    }

    private static void setMultiBlocksHeight(int x, int y, int z, int xd, int zd, BlockRotation rot, World world, MultiBlock mb, Block block) {
        for (int h = 0; h < mb.height; ++h) {
            int meta = rot.metadata;
            if (h > 0) {
                meta = 8;
            } else if (xd > 0) {
                meta = 9;
            } else if (xd < 0) {
                meta = 10;
            } else if (zd > 0) {
                meta = 11;
            } else if (zd < 0) {
                meta = 12;
            }
            world.func_147465_d(x + xd, y + h, z + zd, block, meta, 2);
        }
    }
}

