/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.PixelmonMovesetData;
import com.pixelmonmod.pixelmon.config.PixelmonCreativeTabs;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumEthers;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.entity.Entity;

public class ItemEther
extends PixelmonItem {
    public EnumEthers type;

    public ItemEther(EnumEthers type, String itemName) {
        super("healingitems/" + type.getTexture(), itemName);
        this.SetUsableInBattle(true);
        this.type = type;
        this.func_77625_d(16);
        this.func_77637_a(PixelmonCreativeTabs.restoration);
        this.canRepair = false;
    }

    private boolean restorePP(EntityPixelmon userPokemon, int moveIndex) {
        Attack m = userPokemon.getMoveset().get(moveIndex);
        if (m.pp == m.ppBase) {
            return false;
        }
        if (this.type.restoresAllPP()) {
            m.pp = m.ppBase;
        } else {
            m.pp += 10;
            if (m.pp > m.ppBase) {
                m.pp = m.ppBase;
            }
        }
        return true;
    }

    public boolean restoreAllMoves(EntityPixelmon pxm) {
        boolean restored = false;
        for (int a = 0; a < pxm.getMoveset().size(); ++a) {
            if (restored || !this.restorePP(pxm, a)) continue;
            restored = true;
        }
        return restored;
    }

    @Override
    public boolean useFromBag(EntityPixelmon userPokemon, EntityPixelmon targetPokemon, int selectedMove) {
        if (this.type.restoresAllMoves()) {
            if (!this.restoreAllMoves(userPokemon)) {
                ChatHandler.sendChat((Entity)userPokemon.func_70902_q(), "pixelmon.general.noeffect", new Object[0]);
                return false;
            }
        } else if (!this.restorePP(userPokemon, selectedMove)) {
            ChatHandler.sendChat((Entity)userPokemon.func_70902_q(), "pixelmon.general.noeffect", new Object[0]);
            return false;
        }
        return super.useFromBag(userPokemon, targetPokemon);
    }

    private boolean canRestorePP(PixelmonData userPokemon, int moveIndex) {
        PixelmonMovesetData m = userPokemon.moveset[moveIndex];
        if (m.pp < m.ppBase) {
            return true;
        }
        return true;
    }

    private boolean canRestoreAllMoves(PixelmonData pxm) {
        for (int a = 0; a < pxm.moveset.length; ++a) {
            if (!this.canRestorePP(pxm, a)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean affects(PixelmonData user) {
        return this.canRestoreAllMoves(user);
    }
}

