/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.config.PixelmonCreativeTabs;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity7HasAI;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.item.ItemStack;

public abstract class ItemHeld
extends PixelmonItem {
    private EnumHeldItems heldItemType;
    private boolean usableInBattle;

    public ItemHeld(EnumHeldItems heldItemType, String textureName, String itemName) {
        super("helditems/" + textureName, itemName);
        this.isEquippable = true;
        this.heldItemType = heldItemType;
        this.usableInBattle = heldItemType.getUsableInBattle();
        if (heldItemType != EnumHeldItems.gems) {
            this.func_77637_a(PixelmonCreativeTabs.held);
        }
        this.canRepair = false;
    }

    public EnumHeldItems getHeldItemType() {
        return this.heldItemType;
    }

    public boolean usableInBattle() {
        return this.usableInBattle;
    }

    public static boolean isItemOfType(ItemStack item, EnumHeldItems type) {
        if (item == null || item != null && (item.func_77973_b() == null || !(item.func_77973_b() instanceof ItemHeld))) {
            return false;
        }
        return ((ItemHeld)item.func_77973_b()).heldItemType == type;
    }

    public boolean effectEntity(EntityPixelmon helper1) {
        return false;
    }

    public static void useBattleItems(EntityPixelmon user) {
        ItemStack itemstack = user.func_70694_bm();
        if (itemstack == null) {
            return;
        }
        ItemHeld item = (ItemHeld)itemstack.func_77973_b();
        if (item.effectEntity(user)) {
            user.setHeldItem(null);
        }
    }

    public boolean dealtDamage(EntityPixelmon holder, Entity7HasAI target, float damage) {
        return false;
    }

    public double preProcessAttack(EntityPixelmon attacker, Entity7HasAI target, Attack attack, double damage, boolean heldByTarget) {
        return damage;
    }

    public boolean postProcessAttack(PixelmonWrapper attacker, PixelmonWrapper holder, Attack attack, float damage) {
        return false;
    }

    public void onMiss(EntityPixelmon attacker, EntityPixelmon target) {
    }

    public void onBattleEnd() {
    }

    public double preProcessAttackPhysical(EntityPixelmon attacker, Entity7HasAI target, Attack attack, double damage, boolean heldByTarget) {
        return damage;
    }

    public int modifyDamage(int damage, EntityPixelmon pokemon, EntityPixelmon opponent, Attack a, boolean incomingDamage) {
        return damage;
    }

    public void onStatusAdded(EntityPixelmon user, EntityPixelmon opponent, StatusBase status) {
    }

    public int adjustCritStage(EntityPixelmon user, EntityPixelmon opponent) {
        return 0;
    }
}

