/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.config.PixelmonCreativeTabs;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumPotions;
import com.pixelmonmod.pixelmon.enums.EnumStatusAilmentHealers;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class ItemPotion
extends PixelmonItem {
    public EnumPotions type;

    public ItemPotion(EnumPotions type, String itemName) {
        super("healingitems/" + type.getTexture(), itemName);
        this.SetUsableInBattle(true);
        this.type = type;
        this.func_77625_d(16);
        this.func_77637_a(PixelmonCreativeTabs.restoration);
        this.canRepair = false;
    }

    private int healAmount(EntityPixelmon userPokemon) {
        if (this.type.getHealAmount() != 0) {
            return this.type.getHealAmount();
        }
        if (this.type.getHealPercent() != 0) {
            return (int)Math.floor((double)userPokemon.stats.HP * (double)this.type.getHealPercent() / 100.0);
        }
        return 0;
    }

    public void healPokemon(EntityPixelmon pxm) {
        float newHP = pxm.func_110143_aJ() + (float)this.healAmount(pxm);
        pxm.func_70606_j(newHP);
        if (pxm.func_70902_q() != null) {
            pxm.update(EnumUpdateType.HP);
        }
    }

    private boolean hasStatusThatCanBeHealed(EntityPixelmon pokemonToCheck) {
        if (this.type == EnumPotions.FullRestore) {
            for (StatusType s : EnumStatusAilmentHealers.FullHeal.statusesHealed()) {
                if (!pokemonToCheck.hasStatus(s)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean useFromBag(EntityPixelmon userPokemon, EntityPixelmon targetPokemon) {
        return false;
    }

    @Override
    public boolean useFromBagNBT(EntityPlayer user, NBTTagCompound nbt, PlayerStorage storage) {
        boolean wasOut = false;
        EntityPixelmon userPokemon = storage.getAlreadyExists(PixelmonMethods.getID(nbt), user.field_70170_p);
        if (userPokemon != null) {
            wasOut = true;
        } else {
            userPokemon = storage.sendOut(PixelmonMethods.getID(nbt), user.field_70170_p);
        }
        if (this.type == EnumPotions.Revive || this.type == EnumPotions.MaxRevive) {
            if (!nbt.func_74767_n("IsFainted") || nbt.func_74765_d("Health") > 0) {
                ChatHandler.sendChat((Entity)user, "pixelmon.general.noeffect", new Object[0]);
                return false;
            }
            this.healPokemon(userPokemon);
            nbt.func_74777_a("Health", (short)this.healAmount(userPokemon));
            nbt.func_74776_a("HealF", (float)this.healAmount(userPokemon));
            nbt.func_74757_a("IsFainted", false);
            storage.updateClient(nbt, EnumUpdateType.HP);
        } else {
            if (userPokemon.func_110143_aJ() == (float)userPokemon.stats.HP && (this.type != EnumPotions.FullRestore || this.hasStatusThatCanBeHealed(userPokemon))) {
                ChatHandler.sendChat((Entity)userPokemon.func_70902_q(), "pixelmon.general.noeffect", new Object[0]);
                return false;
            }
            this.healPokemon(userPokemon);
            if (this.type == EnumPotions.FullRestore) {
                for (StatusType s : EnumStatusAilmentHealers.FullHeal.statusesHealed()) {
                    userPokemon.removeStatus(s);
                }
            }
            if (!wasOut) {
                userPokemon.unloadEntity();
            }
        }
        return super.useFromBagNBT(user, nbt, storage);
    }

    private boolean hasStatusThatCanBeHealed(PixelmonData pokemonToCheck) {
        if (this.type == EnumPotions.FullRestore) {
            for (StatusType s : EnumStatusAilmentHealers.FullHeal.statusesHealed()) {
                if (!pokemonToCheck.status.contains((Object)s)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean affects(PixelmonData user) {
        if (this.type == EnumPotions.Revive || this.type == EnumPotions.MaxRevive) {
            return user.isFainted;
        }
        return user.health != user.hp || this.type == EnumPotions.FullRestore && this.hasStatusThatCanBeHealed(user);
    }
}

