/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.config.PixelmonCreativeTabs;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumStatusAilmentHealers;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.entity.Entity;

public class ItemStatusAilmentHealer
extends PixelmonItem {
    public EnumStatusAilmentHealers type;

    public ItemStatusAilmentHealer(EnumStatusAilmentHealers type, String itemName) {
        super("healingitems/" + ItemStatusAilmentHealer.getTextureName(itemName), itemName);
        this.SetUsableInBattle(true);
        this.type = type;
        this.func_77625_d(16);
        this.func_77637_a(PixelmonCreativeTabs.restoration);
    }

    private static String getTextureName(String itemName) {
        String texName = "";
        for (int i = 0; i < itemName.length(); ++i) {
            if (itemName.charAt(i) == ' ') continue;
            texName = texName + itemName.charAt(i);
        }
        return texName.toLowerCase();
    }

    public boolean healPokemon(EntityPixelmon pxm) {
        boolean healedAilment = false;
        for (StatusType s : this.type.statusesHealed()) {
            if (!pxm.removeStatus(s)) continue;
            healedAilment = true;
        }
        return healedAilment;
    }

    private boolean hasStatusThatCanBeHealed(EntityPixelmon pokemonToCheck) {
        for (StatusType s : this.type.statusesHealed()) {
            if (!pokemonToCheck.hasStatus(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean useFromBag(EntityPixelmon userPokemon, EntityPixelmon targetPokemon) {
        if (!this.hasStatusThatCanBeHealed(userPokemon)) {
            ChatHandler.sendChat((Entity)userPokemon.func_70902_q(), "pixelmon.general.noeffect", new Object[0]);
            return false;
        }
        for (StatusType s : this.type.statusesHealed()) {
            userPokemon.removeStatus(s);
        }
        userPokemon.update(EnumUpdateType.Status);
        if (this.type == EnumStatusAilmentHealers.RedFlute || this.type == EnumStatusAilmentHealers.YellowFlute || this.type == EnumStatusAilmentHealers.BlueFlute) {
            return false;
        }
        return super.useFromBag(userPokemon, targetPokemon);
    }

    private boolean hasStatusThatCanBeHealed(PixelmonData pokemonToCheck) {
        for (StatusType s : this.type.statusesHealed()) {
            if (!pokemonToCheck.status.contains((Object)s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean affects(PixelmonData user) {
        return this.hasStatusThatCanBeHealed(user);
    }
}

