/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity7HasAI;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class ItemMetronome
extends ItemHeld {
    private Attack lastAttack = null;
    private int boost = 0;

    public ItemMetronome() {
        super(EnumHeldItems.metronome, "metronome", "Metronome");
    }

    @Override
    public double preProcessAttack(EntityPixelmon attacker, Entity7HasAI target, Attack attack, double damage, boolean heldByTarget) {
        if (!heldByTarget) {
            if (this.lastAttack != null && this.lastAttack == attack && damage > 0.0) {
                ChatHandler.sendBattleMessage((Entity)attacker.func_70902_q(), (Entity)target.func_70902_q(), "pixelmon.helditem.metronomeowner", ((EntityPlayer)attacker.func_70902_q()).getDisplayName(), attacker.getNickname());
                this.boost += 20;
                if (this.boost > 100) {
                    this.boost = 100;
                }
                return damage + damage / 100.0 * (double)this.boost;
            }
            this.lastAttack = attack;
            this.boost = 0;
        }
        return damage;
    }

    @Override
    public void onMiss(EntityPixelmon attacker, EntityPixelmon target) {
        this.boost = 0;
        this.lastAttack = null;
    }

    @Override
    public void onBattleEnd() {
        this.boost = 0;
        this.lastAttack = null;
    }
}

