/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.pokedex;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.PixelmonPokedexPacket;
import com.pixelmonmod.pixelmon.database.DatabaseHelper;
import com.pixelmonmod.pixelmon.pokedex.PokedexEntry;
import com.pixelmonmod.pixelmon.pokedex.PokedexEntryEmpty;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.StatCollector;

public class Pokedex {
    public static final HashMap<Integer, PokedexEntry> fullPokedex = new HashMap();
    public static final HashMap<String, Integer> nameToID = new HashMap();
    public static final int pokedexSize = 649;
    public Entity owner;
    private HashMap<Integer, DexRegisterStatus> seenMap;

    public static void init() {
    }

    public static int nameToID(String name) {
        if (!nameToID.containsKey(name)) {
            return 0;
        }
        return nameToID.get(name);
    }

    public static boolean isEntryEmpty(int i) {
        if (!fullPokedex.containsKey(i)) {
            return true;
        }
        return Pokedex.fullPokedex.get((Object)Integer.valueOf((int)i)).name.equals("???");
    }

    public Pokedex() {
        this(null);
    }

    public Pokedex(Entity e) {
        this.owner = e;
        this.seenMap = new HashMap();
    }

    public NBTTagCompound readFromNBT(NBTTagCompound nbt) {
        this.seenMap.clear();
        NBTTagList nbtl = nbt.func_150295_c("Pokedex", 8);
        for (int i = 0; i < nbtl.func_74745_c(); ++i) {
            try {
                String[] s = nbtl.func_150307_f(i).split(":");
                this.seenMap.put(Integer.parseInt(s[0]), DexRegisterStatus.get(Integer.parseInt(s[1])));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return nbt;
    }

    public HashMap<Integer, DexRegisterStatus> getSeenMap() {
        return this.seenMap;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList nbtl = new NBTTagList();
        for (Map.Entry<Integer, DexRegisterStatus> e : this.seenMap.entrySet()) {
            nbtl.func_74742_a((NBTBase)new NBTTagString(e.getKey() + ":" + e.getValue().ordinal()));
        }
        nbt.func_74782_a("Pokedex", (NBTBase)nbtl);
        return nbt;
    }

    public void sendToPlayer(EntityPlayerMP e) {
        PixelmonPokedexPacket p = new PixelmonPokedexPacket(this);
        Pixelmon.network.sendTo((IMessage)p, e);
    }

    public void set(int id, DexRegisterStatus drs) {
        if (this.seenMap.containsKey(id) && this.seenMap.get(id).ordinal() > drs.ordinal()) {
            return;
        }
        if (id > 0 && id <= 649) {
            this.seenMap.put(id, drs);
        }
    }

    public DexRegisterStatus get(int id) {
        DexRegisterStatus d = this.seenMap.get(id);
        if (d == null) {
            d = DexRegisterStatus.unknown;
        }
        return d;
    }

    public boolean isUnknown(int id) {
        return this.get(id) == DexRegisterStatus.unknown;
    }

    public boolean hasSeen(int id) {
        DexRegisterStatus d = this.get(id);
        return d == DexRegisterStatus.seen || this.hasCaught(id);
    }

    public boolean hasCaught(int id) {
        return this.get(id) == DexRegisterStatus.caught;
    }

    public PokedexEntry getEntry(int id) {
        PokedexEntry e = fullPokedex.get(id);
        if (e == null) {
            e = new PokedexEntryEmpty(id);
        }
        return e;
    }

    public int countCaught() {
        int count = 0;
        for (int i = 1; i <= 649; ++i) {
            if (!this.hasCaught(i)) continue;
            ++count;
        }
        return count;
    }

    public void setSeenList(HashMap<Integer, DexRegisterStatus> data) {
        this.seenMap = data;
    }

    static {
        try {
            ResultSet r = DatabaseHelper.getResultSet("select * from PIXELMON");
            while (r.next()) {
                String n = StatCollector.func_74838_a((String)("pixelmon." + r.getString("PIXELMONFULLNAME").toLowerCase() + ".name"));
                int i = r.getInt("NATIONALPOKEDEXNUMBER");
                String d = r.getString("POKEDEXDESCRIPTION");
                float w = r.getFloat("POKEDEXWEIGHT");
                float h = r.getFloat("POKEDEXHEIGHT");
                fullPokedex.put(i, new PokedexEntry(i, n, d, w, h));
                nameToID.put(n, i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum DexRegisterStatus {
        unknown,
        seen,
        caught;


        public static DexRegisterStatus get(int i) {
            return DexRegisterStatus.values()[i];
        }
    }
}

