/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.pokeloot.worldGen;

import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.pokeloot.worldGen.HiddenGrotto;
import com.pixelmonmod.pixelmon.spawning.PixelmonBiomeDictionary;
import com.pixelmonmod.pixelmon.worldGeneration.battleDimension.BattleDimChunkProvider;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;

public class WorldGenHiddenGrotto
extends MapGenScatteredFeature
implements IWorldGenerator {
    private static int lastChunk = 0;
    private static int lastX;
    private static int lastZ;
    private static int MIN_DISTANCE;
    private static int MIN_CHUNK;
    private static HiddenGrotto groto;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (chunkGenerator instanceof BattleDimChunkProvider) {
            return;
        }
        if (!PixelmonConfig.spawnGrotto) {
            return;
        }
        int x = random.nextInt(16) + chunkX * 16;
        int z = random.nextInt(16) + chunkZ * 16;
        int y = world.func_72976_f(x, z);
        if (this.canGenerate(world, x, z)) {
            int y0 = this.lowerToGround(world, x, world.func_72976_f(x, z), z);
            int y1 = this.lowerToGround(world, x + 8, world.func_72976_f(x + 8, z), z);
            int y2 = this.lowerToGround(world, x, world.func_72976_f(x, z + 8), z + 8);
            int y3 = this.lowerToGround(world, x + 8, world.func_72976_f(x + 8, z + 8), z + 8);
            if (!(this.waterCheck(world, x, y0, z) && this.waterCheck(world, x + 8, y1, z) && this.waterCheck(world, x, y2, z + 8) && this.waterCheck(world, x + 8, y3, z + 8))) {
                return;
            }
            y = Math.min(Math.min(y0, y1), Math.min(y2, y3));
            groto.generate(world, x, y, z);
            lastX = x;
            lastZ = y;
        }
    }

    private boolean canGenerate(World world, int x, int z) {
        if (world.field_73011_w.field_76574_g == -1 || world.field_73011_w.field_76574_g == 1) {
            return false;
        }
        int distance = (int)Math.sqrt(Math.pow(lastX - x, 2.0) + Math.pow(lastZ - z, 2.0));
        if (distance >= MIN_DISTANCE && lastChunk % MIN_CHUNK == 0) {
            if (this.biomeOK(world.func_72807_a(x, z))) {
                ++lastChunk;
                return true;
            }
            ++lastChunk;
            return false;
        }
        ++lastChunk;
        return false;
    }

    private boolean biomeOK(BiomeGenBase b) {
        ArrayList<PixelmonBiomeDictionary.Type> validTypes = new ArrayList<PixelmonBiomeDictionary.Type>();
        validTypes.add(PixelmonBiomeDictionary.Type.FOREST);
        validTypes.add(PixelmonBiomeDictionary.Type.TAIGA);
        validTypes.add(PixelmonBiomeDictionary.Type.JUNGLE);
        return PixelmonBiomeDictionary.getBiomeIDsMatchingAnyTag(validTypes).contains(b.field_76756_M);
    }

    private boolean waterCheck(World world, int x, int y, int z) {
        Block underBlock = world.func_147439_a(x, y - 1, z);
        return underBlock != Blocks.field_150358_i && underBlock != Blocks.field_150355_j && underBlock != Blocks.field_150392_bi;
    }

    private int lowerToGround(World world, int x, int y, int z) {
        int Y = y;
        Block underBlock = world.func_147439_a(x, Y - 1, z);
        while (underBlock == Blocks.field_150362_t || underBlock == Blocks.field_150364_r || world.func_147437_c(x, Y - 1, z)) {
            underBlock = world.func_147439_a(x, --Y - 1, z);
        }
        return Y;
    }

    static {
        lastZ = 0;
        MIN_DISTANCE = 512;
        MIN_CHUNK = 128;
        groto = new HiddenGrotto();
    }
}

