/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.pokeloot.worldGen;

import com.pixelmonmod.pixelmon.blocks.TileEntityPokeChest;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.spawning.PixelmonBiomeDictionary;
import com.pixelmonmod.pixelmon.worldGeneration.battleDimension.BattleDimChunkProvider;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenPokeChest
implements IWorldGenerator {
    private static int lastChunk = 0;
    private static int lastX;
    private static int lastZ;
    private static int totalPlaced;
    private static int normalPlaced;
    private static int ultraPlaced;
    private static int MIN_DISTANCE;
    private static int MIN_CHUNK;
    private static int HIDDEN_FREQ;
    private static boolean chestOneTime;
    private static boolean dropOneTime;
    private static boolean timeEnabled;
    private int x;
    private int y;
    private int z;
    private int distance;
    private int face = 0;
    Block underBlock;
    private int x2;
    private int y2;
    private int z2;
    private int underID2;
    private int distance2;
    private int face2 = 0;
    private BiomeGenBase biome;
    private BiomeGenBase biome2;
    private boolean goodBiome = true;
    private boolean goodBiome2 = true;
    private String mode = "N/A";

    public static void setRatesAndModes() {
        switch (PixelmonConfig.spawnRate) {
            case EXTREME: {
                MIN_DISTANCE = 76;
                MIN_CHUNK = 9;
                break;
            }
            case MINIMAL: {
                MIN_DISTANCE = 508;
                MIN_CHUNK = 64;
                HIDDEN_FREQ = 4;
                break;
            }
            case NORMAL: {
                MIN_DISTANCE = 254;
                MIN_CHUNK = 32;
                HIDDEN_FREQ = 2;
                break;
            }
            case MORE: {
                MIN_DISTANCE = 143;
                MIN_CHUNK = 18;
                break;
            }
            default: {
                MIN_DISTANCE = 254;
                MIN_CHUNK = 32;
                HIDDEN_FREQ = 2;
            }
        }
        switch (PixelmonConfig.spawnMode) {
            case FCFS: {
                chestOneTime = true;
                dropOneTime = true;
                timeEnabled = false;
                break;
            }
            case PL: {
                chestOneTime = false;
                dropOneTime = true;
                timeEnabled = false;
                break;
            }
            case PU: {
                chestOneTime = false;
                dropOneTime = false;
                timeEnabled = false;
                break;
            }
            case TIMED: {
                chestOneTime = false;
                dropOneTime = true;
                timeEnabled = true;
                break;
            }
            default: {
                chestOneTime = true;
                dropOneTime = true;
                timeEnabled = false;
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (chunkGenerator instanceof BattleDimChunkProvider) {
            return;
        }
        if (PixelmonConfig.spawnNormal || PixelmonConfig.spawnHidden) {
            this.genBlocks(random, chunkX, chunkZ, world);
        }
    }

    private void genBlocks(Random random, int chunkX, int chunkZ, World world) {
        if (world.field_73011_w.field_76574_g == -1 || world.field_73011_w.field_76574_g == 1) {
            return;
        }
        this.x = random.nextInt(16) + chunkX * 16;
        this.z = random.nextInt(16) + chunkZ * 16;
        this.y = world.func_72976_f(this.x, this.z);
        this.distance = (int)Math.sqrt(Math.pow(lastX - this.x, 2.0) + Math.pow(lastZ - this.z, 2.0));
        if (this.distance >= MIN_DISTANCE && lastChunk % MIN_CHUNK == 0) {
            this.underBlock = world.func_147439_a(this.x, this.y - 1, this.z);
            this.biome = world.func_72807_a(chunkX * 16, chunkZ * 16);
            while (this.underBlock == Blocks.field_150362_t || this.underBlock == Blocks.field_150364_r || world.func_147437_c(this.x, this.y - 1, this.z)) {
                --this.y;
                try {
                    this.underBlock = world.func_147439_a(this.x, this.y - 1, this.z);
                }
                catch (Exception e) {
                    return;
                }
            }
            ArrayList<PixelmonBiomeDictionary.Type> invalidTypes = new ArrayList<PixelmonBiomeDictionary.Type>();
            invalidTypes.add(PixelmonBiomeDictionary.Type.RIVER);
            invalidTypes.add(PixelmonBiomeDictionary.Type.OCEAN);
            this.goodBiome = !PixelmonBiomeDictionary.getBiomeIDsMatchingAnyTag(invalidTypes).contains(this.biome.field_76756_M);
            if (this.goodBiome && this.underBlock != Blocks.field_150355_j && this.underBlock != Blocks.field_150358_i && this.underBlock != Blocks.field_150356_k && this.underBlock != Blocks.field_150353_l) {
                Block block = PixelmonBlocks.pokeChest;
                this.mode = "Poke Chest";
                if (normalPlaced > 4) {
                    if (ultraPlaced > 4) {
                        block = PixelmonBlocks.masterChest;
                        this.mode = "Master Chest";
                        ultraPlaced = 0;
                    } else {
                        block = PixelmonBlocks.ultraChest;
                        this.mode = "Ultra Chest";
                        ++ultraPlaced;
                    }
                    normalPlaced = 0;
                } else {
                    ++normalPlaced;
                }
                if (PixelmonConfig.spawnHidden && totalPlaced % HIDDEN_FREQ == 0 && totalPlaced != 0 && block == PixelmonBlocks.pokeChest) {
                    this.face = random.nextInt(4) + 1;
                    world.func_147465_d(this.x, this.y, this.z, PixelmonBlocks.pokeChest, this.face + 10, 2);
                    this.mode = "Hidden Poke Chest";
                } else if (PixelmonConfig.spawnNormal) {
                    this.face = random.nextInt(4) + 1;
                    world.func_147465_d(this.x, this.y, this.z, block, this.face, 2);
                } else if (PixelmonConfig.spawnHidden) {
                    this.face = random.nextInt(4) + 1;
                    world.func_147465_d(this.x, this.y, this.z, PixelmonBlocks.pokeChest, this.face + 10, 2);
                    this.mode = "Hidden Poke Chest";
                }
                TileEntity t0 = world.func_147438_o(this.x, this.y, this.z);
                if (t0 != null) {
                    TileEntityPokeChest t = (TileEntityPokeChest)t0;
                    t.setChestOneTime(chestOneTime);
                    t.setDropOneTime(dropOneTime);
                    t.setTimeEnabled(timeEnabled);
                    lastX = this.x;
                    lastZ = this.z;
                    ++totalPlaced;
                } else {
                    world.func_147468_f(this.x, this.y, this.z);
                }
            } else {
                --lastChunk;
            }
        }
        ++lastChunk;
    }

    static {
        lastZ = 0;
        totalPlaced = 0;
        normalPlaced = 0;
        ultraPlaced = 0;
        MIN_DISTANCE = 254;
        MIN_CHUNK = 32;
        HIDDEN_FREQ = 3;
        chestOneTime = true;
        dropOneTime = true;
        timeEnabled = false;
    }
}

