/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class PixelmonBiomeDictionary {
    private static final int BIOME_LIST_SIZE = 256;
    private static PixelmonBiomeInfo[] biomeList = new PixelmonBiomeInfo[256];
    private static ArrayList<Integer>[] biomesWithType = new ArrayList[Type.values().length];

    public static Integer getBiomeIDFromName(String biomeName) {
        Integer i = 0;
        while (i < biomeList.length) {
            if (biomeList[i] != null && PixelmonBiomeDictionary.biomeList[i.intValue()].biomeName != null && biomeList[i].isSameNameAs(biomeName)) {
                return i;
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return null;
    }

    public static PixelmonBiomeInfo[] getBiomeInfoList() {
        return biomeList;
    }

    public static boolean registerBiomeType(Integer biomeID, Type ... types) {
        if (types == null) {
            types = new Type[]{Type.WASTELAND};
        }
        if (BiomeGenBase.func_150565_n()[biomeID] != null) {
            for (Type type : types) {
                if (biomesWithType[type.ordinal()] == null) {
                    PixelmonBiomeDictionary.biomesWithType[type.ordinal()] = new ArrayList();
                }
                biomesWithType[type.ordinal()].add(biomeID);
            }
            if (biomeList[biomeID] == null) {
                PixelmonBiomeDictionary.biomeList[biomeID.intValue()] = new PixelmonBiomeInfo(BiomeGenBase.func_150565_n()[biomeID.intValue()].field_76791_y, types);
            } else {
                Collections.addAll(PixelmonBiomeDictionary.biomeList[biomeID.intValue()].typeList, types);
            }
            return true;
        }
        return false;
    }

    public static Type[] getTypesForBiome(BiomeGenBase biome) {
        return PixelmonBiomeDictionary.getTypesForBiomeID(biome.field_76756_M);
    }

    public static Type[] getTypesForBiomeID(Integer biomeID) {
        if (PixelmonBiomeDictionary.isBiomeRegistered(biomeID)) {
            return PixelmonBiomeDictionary.biomeList[biomeID.intValue()].typeList.toArray(new Type[PixelmonBiomeDictionary.biomeList[biomeID.intValue()].typeList.size()]);
        }
        BiomeGenBase biome = BiomeGenBase.func_150568_d((int)biomeID);
        BiomeDictionary.Type[] forgeBiomeTypes = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        Collections.addAll(PixelmonBiomeDictionary.biomeList[biomeID.intValue()].typeList, PixelmonBiomeDictionary.getPixelmonEquivalentTypes(biome, forgeBiomeTypes));
        return PixelmonBiomeDictionary.biomeList[biomeID.intValue()].typeList.toArray(new Type[PixelmonBiomeDictionary.biomeList[biomeID.intValue()].typeList.size()]);
    }

    public static boolean isBiomeRegistered(BiomeGenBase biome) {
        if (biome != null) {
            return PixelmonBiomeDictionary.isBiomeRegistered(biome.field_76756_M);
        }
        return false;
    }

    public static boolean isBiomeRegistered(Integer biomeID) {
        return biomeList[biomeID] != null;
    }

    public static boolean isBiomeOfType(BiomeGenBase biome, Type tag) {
        return PixelmonBiomeDictionary.isBiomeOfType(biome.field_76756_M, tag);
    }

    public static boolean isBiomeOfType(Integer biomeID, Type tag) {
        if (biomeList[biomeID] != null) {
            return PixelmonBiomeDictionary.biomeList[biomeID.intValue()].typeList.contains((Object)tag);
        }
        return false;
    }

    public static ArrayList<Integer> getBiomeIDsMatchingAnyTag(ArrayList<Type> tags) {
        ArrayList<Integer> intBiomeIDs = new ArrayList<Integer>();
        for (int i = 0; i < biomeList.length; ++i) {
            if (tags == null || tags.size() <= 0 || biomeList[i] == null || PixelmonBiomeDictionary.biomeList[i].typeList == null) continue;
            for (Type tag : tags) {
                if (!PixelmonBiomeDictionary.biomeList[i].typeList.contains((Object)tag)) continue;
                intBiomeIDs.add(i);
            }
        }
        return intBiomeIDs;
    }

    public static ArrayList<Integer> getBiomeIDsMatchingAllTags(ArrayList<Type> tags) {
        ArrayList<Integer> intBiomeIDs = new ArrayList<Integer>();
        int intCountMatches = 0;
        for (int i = 0; i < biomeList.length; ++i) {
            intCountMatches = 0;
            if (tags == null || tags.size() <= 0 || biomeList[i] == null || PixelmonBiomeDictionary.biomeList[i].typeList == null) continue;
            for (Type tag : tags) {
                if (!PixelmonBiomeDictionary.biomeList[i].typeList.contains((Object)tag)) continue;
                ++intCountMatches;
            }
            if (intCountMatches != tags.size()) continue;
            intBiomeIDs.add(i);
        }
        return intBiomeIDs;
    }

    public static ArrayList<Integer> getBiomeIDsMatchingAllTagsExactly(ArrayList<Type> tags) {
        ArrayList<Integer> intBiomeIDs = new ArrayList<Integer>();
        int intCountMatches = 0;
        for (int i = 0; i < biomeList.length; ++i) {
            intCountMatches = 0;
            if (tags == null || tags.size() <= 0 || biomeList[i] == null || PixelmonBiomeDictionary.biomeList[i].typeList == null) continue;
            for (Type tag : tags) {
                if (!PixelmonBiomeDictionary.biomeList[i].typeList.contains((Object)tag)) continue;
                ++intCountMatches;
            }
            if (intCountMatches != tags.size() || intCountMatches != PixelmonBiomeDictionary.biomeList[i].typeList.size()) continue;
            intBiomeIDs.add(i);
        }
        return intBiomeIDs;
    }

    public static Type[] getPixelmonEquivalentTypes(BiomeGenBase biome, BiomeDictionary.Type[] forgeBiomeTypes) {
        ArrayList<Type> pixelmonTypesArray = new ArrayList<Type>();
        for (BiomeDictionary.Type forgeType : forgeBiomeTypes) {
            Type pixelmonType = PixelmonBiomeDictionary.getTypeFromString(forgeType.toString());
            if (pixelmonType != null) {
                pixelmonTypesArray.add(pixelmonType);
                continue;
            }
            if (forgeType.toString().equalsIgnoreCase("water")) {
                if (biome.field_76791_y.toLowerCase().contains("river")) {
                    pixelmonTypesArray.add(Type.RIVER);
                    continue;
                }
                if (biome.field_76791_y.toLowerCase().contains("ocean")) {
                    pixelmonTypesArray.add(Type.OCEAN);
                    continue;
                }
                pixelmonTypesArray.add(Type.OCEAN);
                continue;
            }
            if (forgeType.toString().equalsIgnoreCase("mountain")) {
                pixelmonTypesArray.add(Type.EXTREMEHILLS);
                continue;
            }
            System.out.println("[ERROR] Unknown Forge Biome Tag: '" + forgeType.toString() + "' when trying to assign tags for biome: '" + biome.field_76791_y + "'");
        }
        Type[] pixelmonTypesList = new Type[pixelmonTypesArray.size()];
        for (int i = 0; i < pixelmonTypesArray.size(); ++i) {
            pixelmonTypesList[i] = (Type)((Object)pixelmonTypesArray.get(i));
        }
        return pixelmonTypesList;
    }

    public static Type[] getTypesFromForgeBiome(BiomeGenBase biome) {
        ArrayList<Type> arrTempTypes = new ArrayList<Type>();
        for (BiomeDictionary.Type forgetype : BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)) {
            Type tempType = PixelmonBiomeDictionary.getTypeFromString(forgetype.name());
            if (tempType == null) continue;
            arrTempTypes.add(tempType);
        }
        if (arrTempTypes.size() > 0) {
            Type[] types = new Type[arrTempTypes.size()];
            for (int i = 0; i < arrTempTypes.size(); ++i) {
                types[i] = (Type)((Object)arrTempTypes.get(i));
            }
            return types;
        }
        return null;
    }

    public static Type getTypeFromString(String strType) {
        Type returnType = null;
        for (Type type : Type.values()) {
            if (!type.toString().equalsIgnoreCase(strType)) continue;
            returnType = type;
            break;
        }
        return returnType;
    }

    public static void setupCustomBiomeTags() {
        PixelmonBiomeDictionary.registerBiomeType(0, Type.OCEAN);
        PixelmonBiomeDictionary.registerBiomeType(1, Type.PLAINS);
        PixelmonBiomeDictionary.registerBiomeType(2, Type.DESERT);
        PixelmonBiomeDictionary.registerBiomeType(3, Type.EXTREMEHILLS);
        PixelmonBiomeDictionary.registerBiomeType(4, Type.FOREST);
        PixelmonBiomeDictionary.registerBiomeType(5, Type.TAIGA);
        PixelmonBiomeDictionary.registerBiomeType(6, Type.SWAMP);
        PixelmonBiomeDictionary.registerBiomeType(7, Type.RIVER);
        PixelmonBiomeDictionary.registerBiomeType(8, Type.NETHER);
        PixelmonBiomeDictionary.registerBiomeType(9, Type.END);
        PixelmonBiomeDictionary.registerBiomeType(10, Type.FROZEN, Type.OCEAN);
        PixelmonBiomeDictionary.registerBiomeType(11, Type.FROZEN, Type.RIVER);
        PixelmonBiomeDictionary.registerBiomeType(12, Type.FROZEN, Type.PLAINS);
        PixelmonBiomeDictionary.registerBiomeType(13, Type.FROZEN, Type.HILLS);
        PixelmonBiomeDictionary.registerBiomeType(14, Type.MUSHROOM);
        PixelmonBiomeDictionary.registerBiomeType(15, Type.BEACH, Type.MUSHROOM);
        PixelmonBiomeDictionary.registerBiomeType(16, Type.BEACH);
        PixelmonBiomeDictionary.registerBiomeType(17, Type.DESERT, Type.HILLS);
        PixelmonBiomeDictionary.registerBiomeType(18, Type.FOREST, Type.HILLS);
        PixelmonBiomeDictionary.registerBiomeType(19, Type.HILLS, Type.TAIGA);
        PixelmonBiomeDictionary.registerBiomeType(20, Type.EDGE, Type.EXTREMEHILLS);
        PixelmonBiomeDictionary.registerBiomeType(21, Type.JUNGLE);
        PixelmonBiomeDictionary.registerBiomeType(22, Type.JUNGLE, Type.HILLS);
        PixelmonBiomeDictionary.registerBiomeType(23, Type.EDGE, Type.JUNGLE);
        PixelmonBiomeDictionary.registerBiomeType(24, Type.AMPLIFIED, Type.OCEAN);
        PixelmonBiomeDictionary.registerBiomeType(25, Type.AMPLIFIED, Type.BEACH);
        PixelmonBiomeDictionary.registerBiomeType(26, Type.BEACH, Type.FROZEN);
        PixelmonBiomeDictionary.registerBiomeType(27, Type.FOREST, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(28, Type.FOREST, Type.HILLS, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(29, Type.FOREST, Type.MUSHROOM, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(30, Type.FROZEN, Type.TAIGA);
        PixelmonBiomeDictionary.registerBiomeType(31, Type.FROZEN, Type.HILLS, Type.TAIGA);
        PixelmonBiomeDictionary.registerBiomeType(32, Type.TAIGA, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(33, Type.AMPLIFIED, Type.HILLS, Type.TAIGA);
        PixelmonBiomeDictionary.registerBiomeType(34, Type.EXTREMEHILLS, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(35, Type.PLAINS, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(36, Type.PLAINS, Type.MUTATION, Type.PLATEAU);
        PixelmonBiomeDictionary.registerBiomeType(37, Type.MESA);
        PixelmonBiomeDictionary.registerBiomeType(38, Type.FOREST, Type.MESA, Type.PLATEAU);
        PixelmonBiomeDictionary.registerBiomeType(39, Type.MESA, Type.PLATEAU);
        PixelmonBiomeDictionary.registerBiomeType(129, Type.FLOWER, Type.MUTATION, Type.PLAINS);
        PixelmonBiomeDictionary.registerBiomeType(130, Type.DESERT, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(131, Type.AMPLIFIED, Type.EXTREMEHILLS);
        PixelmonBiomeDictionary.registerBiomeType(132, Type.FLOWER, Type.FOREST, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(133, Type.AMPLIFIED, Type.TAIGA);
        PixelmonBiomeDictionary.registerBiomeType(134, Type.AMPLIFIED, Type.SWAMP);
        PixelmonBiomeDictionary.registerBiomeType(140, Type.FROZEN, Type.MUTATION, Type.PLAINS);
        PixelmonBiomeDictionary.registerBiomeType(149, Type.AMPLIFIED, Type.JUNGLE);
        PixelmonBiomeDictionary.registerBiomeType(151, Type.AMPLIFIED, Type.EDGE, Type.JUNGLE);
        PixelmonBiomeDictionary.registerBiomeType(155, Type.AMPLIFIED, Type.FOREST, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(156, Type.AMPLIFIED, Type.FOREST, Type.HILLS, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(157, Type.AMPLIFIED, Type.FOREST, Type.MUSHROOM, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(158, Type.AMPLIFIED, Type.FROZEN, Type.TAIGA);
        PixelmonBiomeDictionary.registerBiomeType(160, Type.AMPLIFIED, Type.TAIGA, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(161, Type.AMPLIFIED, Type.HILLS, Type.MUTATION, Type.TAIGA);
        PixelmonBiomeDictionary.registerBiomeType(162, Type.AMPLIFIED, Type.EXTREMEHILLS, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(163, Type.AMPLIFIED, Type.PLAINS, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(164, Type.AMPLIFIED, Type.MUTATION, Type.PLAINS, Type.PLATEAU);
        PixelmonBiomeDictionary.registerBiomeType(165, Type.MESA, Type.MUTATION);
        PixelmonBiomeDictionary.registerBiomeType(166, Type.AMPLIFIED, Type.FOREST, Type.MESA, Type.PLATEAU);
        PixelmonBiomeDictionary.registerBiomeType(167, Type.AMPLIFIED, Type.MESA, Type.PLATEAU);
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null || PixelmonBiomeDictionary.isBiomeRegistered(biome)) continue;
            PixelmonBiomeDictionary.registerBiomeType(biome.field_76756_M, PixelmonBiomeDictionary.getTypesFromForgeBiome(biome));
        }
    }

    public static class PixelmonBiomeInfo {
        public String biomeName = "";
        public ArrayList<Type> typeList = new ArrayList();

        public PixelmonBiomeInfo(String biomeName, Type[] types) {
            this.biomeName = biomeName;
            Collections.addAll(this.typeList, types);
        }

        public boolean isSameNameAs(String strTestBiomeName) {
            String tempTestName;
            String tempBiomeName = this.biomeName.replace(" ", "").trim();
            return tempBiomeName.equalsIgnoreCase(tempTestName = strTestBiomeName.replace(" ", "").trim());
        }
    }

    public static enum Type {
        AMPLIFIED,
        BEACH,
        DESERT,
        EDGE,
        END,
        EXTREMEHILLS,
        FLOWER,
        FOREST,
        FROZEN,
        HILLS,
        JUNGLE,
        MAGICAL,
        MESA,
        MUSHROOM,
        MUTATION,
        NETHER,
        OCEAN,
        PLAINS,
        PLATEAU,
        RIVER,
        SWAMP,
        TAIGA,
        WASTELAND;

    }
}

