/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.google.common.primitives.Ints;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.spawning.SpawnData;
import com.pixelmonmod.pixelmon.spawning.SpawnRegistry;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerAir;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerBase;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerLand;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerUnderWater;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerUnderground;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class PixelmonSpawner {
    private static HashMap eligibleChunksForSpawning = new HashMap();
    private static Random rand = new Random();
    public static int chunkSpawnRadius = 8;
    public static int spawnerResetTicks = 1;
    private static ArrayList<SpawnerBase> spawners = new ArrayList();
    private HashMap<Integer, Integer> spawnerTickArray = new HashMap();

    protected static ChunkPosition getRandomSpawningPointInChunk(World world, int x, int z) {
        Chunk chunk = world.func_72964_e(x, z);
        int xCoord = x * 16 + world.field_73012_v.nextInt(16);
        int zCoord = z * 16 + world.field_73012_v.nextInt(16);
        return new ChunkPosition(xCoord, 60, zCoord);
    }

    public static void findChunksForSpawning(WorldServer world) {
        eligibleChunksForSpawning.clear();
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
            int x = MathHelper.func_76128_c((double)(player.field_70165_t / 16.0));
            int z = MathHelper.func_76128_c((double)(player.field_70161_v / 16.0));
            for (int j = -chunkSpawnRadius; j <= chunkSpawnRadius; ++j) {
                for (int k = -chunkSpawnRadius; k <= chunkSpawnRadius; ++k) {
                    boolean isBorder = j == -chunkSpawnRadius || j == chunkSpawnRadius || k == -chunkSpawnRadius || k == chunkSpawnRadius;
                    ChunkCoordIntPair cc = new ChunkCoordIntPair(j + x, k + z);
                    if (!isBorder) {
                        eligibleChunksForSpawning.put(cc, false);
                        continue;
                    }
                    if (eligibleChunksForSpawning.containsKey(cc)) continue;
                    eligibleChunksForSpawning.put(cc, true);
                }
            }
        }
    }

    public static void doSpawning(WorldServer world) {
        if (PixelmonSpawner.countEntities(world)) {
            return;
        }
        ChunkCoordinates chunkCoords = world.func_72861_E();
        Iterator chunkIterator = eligibleChunksForSpawning.keySet().iterator();
        ArrayList tmp = new ArrayList(eligibleChunksForSpawning.keySet());
        Collections.shuffle(tmp);
        for (ChunkCoordIntPair ccIntPair : tmp) {
            if (((Boolean)eligibleChunksForSpawning.get(ccIntPair)).booleanValue()) continue;
            ChunkPosition chunkPos = PixelmonSpawner.getRandomSpawningPointInChunk((World)world, ccIntPair.field_77276_a, ccIntPair.field_77275_b);
            Chunk c = world.func_72964_e(ccIntPair.field_77276_a, ccIntPair.field_77275_b);
            if (PixelmonSpawner.countEntities(c) > 4) continue;
            int cpX = chunkPos.field_151329_a;
            int cpZ = chunkPos.field_151328_c;
            for (SpawnerBase s : spawners) {
                Integer cpY;
                if (s.maxNum <= 0 || s.count > s.maxNum * eligibleChunksForSpawning.size() / 256 || (cpY = s.getSpawnConditionY((World)world, cpX, cpZ)) == null) continue;
                s.count += PixelmonSpawner.doSpawn(s, s.spawnLocation, (World)world, cpX, cpY, cpZ, chunkCoords);
            }
        }
    }

    private static int countEntities(Chunk c) {
        int count = 0;
        for (List l : c.field_76645_j) {
            count += l.size();
        }
        return count;
    }

    private static boolean countEntities(WorldServer world) {
        for (SpawnerBase s : spawners) {
            s.count = 0;
        }
        for (int var3 = 0; var3 < world.field_72996_f.size(); ++var3) {
            Entity var4 = (Entity)world.field_72996_f.get(var3);
            for (SpawnerBase b : spawners) {
                if (var4 instanceof EntityPixelmon) {
                    if (((EntityPixelmon)var4).getSpawnLocation() != b.spawnLocation) continue;
                    ++b.count;
                    continue;
                }
                if (!(var4 instanceof EntityNPC) || ((EntityNPC)var4).npcLocation != b.spawnLocation) continue;
                ++b.count;
            }
        }
        boolean isFull = true;
        for (SpawnerBase s : spawners) {
            if (!isFull || s.maxNum <= 0 || s.count >= s.maxNum * eligibleChunksForSpawning.size() / 256) continue;
            isFull = false;
        }
        return isFull;
    }

    private static int doSpawn(SpawnerBase s, SpawnLocation spawnLocation, World world, int cpX, int cpY, int cpZ, ChunkCoordinates chunkCoords) {
        int numInChunk = 0;
        boolean isBoss = false;
        EnumPokemon[] preEvolutions = null;
        String lastPokemon = "";
        block2: for (int count = 0; count < 3; ++count) {
            int cpXtmp = cpX;
            int cpYtmp = cpY;
            int cpZtmp = cpZ;
            int rndmMax = 6;
            String pokemonName = null;
            int maxInChunk = -1;
            boolean isLegendary = false;
            for (int count2 = 0; count2 < 4; ++count2) {
                EntityLiving pokemon;
                float zd;
                float yd;
                float xd;
                float d;
                float z;
                float y;
                float x;
                isLegendary = false;
                if (!s.canPokemonSpawnHere(world, cpXtmp += world.field_73012_v.nextInt(rndmMax) - world.field_73012_v.nextInt(rndmMax), cpYtmp += world.field_73012_v.nextInt(1) - world.field_73012_v.nextInt(1), cpZtmp += world.field_73012_v.nextInt(rndmMax) - world.field_73012_v.nextInt(rndmMax)) || world.func_72977_a((double)(x = (float)cpXtmp + 0.5f), (double)(y = (float)cpYtmp + 0.5f), (double)(z = (float)cpZtmp + 0.5f), 24.0) != null || !((d = (xd = x - (float)chunkCoords.field_71574_a) * xd + (yd = y - (float)chunkCoords.field_71572_b) * yd + (zd = z - (float)chunkCoords.field_71573_c) * zd) >= 576.0f)) continue;
                if (pokemonName == null) {
                    if (PixelmonSpawner.doLegendarySpawn(world) && (pokemonName = PixelmonSpawner.getRandomLegendary(s, world.field_73011_w, rand, cpXtmp, cpYtmp, cpZtmp)) != null) {
                        isLegendary = true;
                    }
                    if (pokemonName == null) {
                        pokemonName = s.getRandomPokemon(world.field_73011_w, rand, cpXtmp, cpYtmp, cpZtmp);
                    }
                    if (pokemonName == null) continue block2;
                }
                try {
                    pokemon = PixelmonEntityList.createEntityByName(pokemonName, world);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
                pokemon.func_70012_b((double)x, (double)y + (double)s.getYOffset(pokemon), (double)z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (pokemon instanceof EntityPixelmon) {
                    ((EntityPixelmon)pokemon).setSpawnLocation(spawnLocation);
                }
                if (pokemon instanceof EntityNPC) {
                    ((EntityNPC)pokemon).npcLocation = spawnLocation;
                }
                if (!pokemon.func_70601_bi()) continue;
                ++numInChunk;
                if (isLegendary) {
                    PixelmonSpawner.triggerLegendarySpawnEvent(pokemonName, world.field_73011_w, cpXtmp, cpZtmp);
                    ((EntityPixelmon)pokemon).legendaryTicks = 6000;
                }
                world.func_72838_d((Entity)pokemon);
                if (maxInChunk == -1) {
                    if (world.field_73012_v.nextInt(250) == 0 && pokemon instanceof EntityPixelmon) {
                        EntityPixelmon pixelmon = (EntityPixelmon)pokemon;
                        preEvolutions = pixelmon.getPreEvolutions();
                        lastPokemon = pokemonName;
                        pixelmon.setBoss(EnumBossMode.getRandomMode());
                        isBoss = true;
                    }
                    maxInChunk = pokemon.func_70641_bl();
                    if (isBoss) {
                        maxInChunk *= 2;
                        int ind = rand.nextInt(preEvolutions.length + 1);
                        if (ind > preEvolutions.length - 1) {
                            pokemonName = lastPokemon;
                        } else if (preEvolutions[ind] != null) {
                            pokemonName = preEvolutions[ind].name;
                        }
                    }
                }
                if (numInChunk < maxInChunk) continue;
                return numInChunk;
            }
        }
        return 0;
    }

    private static void triggerLegendarySpawnEvent(String pokemonName, WorldProvider provider, int x, int y) {
        if (!PixelmonConfig.doLegendaryEvent) {
            return;
        }
        BiomeGenBase b = provider.field_76579_a.func_72807_a(x, y);
        MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentTranslation("chat.type.announcement", new Object[]{EnumChatFormatting.LIGHT_PURPLE + "Pixelmon" + EnumChatFormatting.RESET, EnumChatFormatting.GREEN + "A legendary has spawned in a " + b.field_76791_y + " biome!"}));
    }

    private static String getRandomLegendary(SpawnerBase s, WorldProvider worldProvider, Random rand, int par2, int par3, int par4) {
        String pokemon;
        if (!s.spawnLegendaries()) {
            return null;
        }
        Integer biomeID = worldProvider.field_76579_a.func_72807_a((int)par2, (int)par4).field_76756_M;
        List<SpawnData> spawnData = SpawnRegistry.getLegendarySpawnsForBiome(biomeID);
        String string = pokemon = spawnData != null && !spawnData.isEmpty() ? SpawnerBase.getPokemonFromList(spawnData, worldProvider.field_76579_a) : null;
        if (pokemon == null) {
            return pokemon;
        }
        for (SpawnLocation loc : Entity3HasStats.getBaseStats(pokemon).spawnLocations) {
            if (loc != s.spawnLocation) continue;
            return pokemon;
        }
        return null;
    }

    private static boolean doLegendarySpawn(World world) {
        if (!PixelmonConfig.allowLegendariesSpawn) {
            return false;
        }
        return world.field_73012_v.nextInt(PixelmonConfig.legendarySpawnRate) == 0;
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && MinecraftServer.func_71276_C().func_71268_U()) {
            World world = event.world;
            int dimId = world.field_73011_w.field_76574_g;
            if (this.allowDimension(dimId)) {
                int spawnerTicks = -1;
                if (this.spawnerTickArray.containsKey(dimId)) {
                    spawnerTicks = this.spawnerTickArray.get(dimId);
                }
                if (++spawnerTicks >= spawnerResetTicks) {
                    PixelmonSpawner.findChunksForSpawning((WorldServer)world);
                    PixelmonSpawner.doSpawning((WorldServer)world);
                    spawnerTicks = 0;
                }
                this.spawnerTickArray.put(dimId, spawnerTicks);
            }
        }
    }

    private boolean allowDimension(int dimensionId) {
        return Ints.contains((int[])PixelmonConfig.spawnDimensions, (int)dimensionId);
    }

    static {
        spawners.add(new SpawnerLand());
        spawners.add(new SpawnerUnderground());
        spawners.add(new SpawnerUnderWater());
        spawners.add(new SpawnerAir());
    }

    private static enum spawnType {
        Land,
        Underground,
        Water;

    }
}

