/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.database.DatabaseStats;
import com.pixelmonmod.pixelmon.database.DatabaseTrainers;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Rarity;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.spawning.PixelmonBiomeDictionary;
import com.pixelmonmod.pixelmon.spawning.SpawnData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class SpawnRegistry {
    private static HashMap<Integer, List<SpawnData>> biomeSpawns = new HashMap();
    private static HashMap<Integer, List<SpawnData>> undergroundSpawns = new HashMap();
    private static HashMap<Integer, List<SpawnData>> biomeWaterSpawns = new HashMap();
    private static HashMap<Integer, List<SpawnData>> airSpawns = new HashMap();
    private static HashMap<Integer, List<SpawnData>> legendarySpawns = new HashMap();
    private static DatabaseStats db;

    public static void addPixelmonSpawn(BaseStats stats) {
        block15: {
            Integer[] biomeIDs;
            block14: {
                biomeIDs = stats.biomeIDs;
                if (biomeIDs == null) {
                    return;
                }
                if (stats.rarity.day >= 0 && stats.rarity.dawndusk >= 0 && stats.rarity.night >= 0) break block14;
                if (stats.rarity.day < 0) {
                    stats.rarity.day = 1;
                }
                if (stats.rarity.dawndusk < 0) {
                    stats.rarity.dawndusk = 1;
                }
                if (stats.rarity.night < 0) {
                    stats.rarity.night = 1;
                }
                for (SpawnLocation s : stats.spawnLocations) {
                    for (Integer biomeID : biomeIDs) {
                        SpawnRegistry.storeSpawnInfo(legendarySpawns, stats.pixelmonName, stats.rarity, PixelmonEntityList.ClassType.Pixelmon, biomeID, s);
                    }
                }
                break block15;
            }
            if (stats.rarity.day <= 0 && stats.rarity.dawndusk <= 0 && stats.rarity.night <= 0) break block15;
            if (stats.spawnLocations == null) {
                for (Integer biomeID : biomeIDs) {
                    SpawnRegistry.storeSpawnInfo(biomeSpawns, stats.pixelmonName, stats.rarity, PixelmonEntityList.ClassType.Pixelmon, biomeID, null);
                }
            } else {
                for (SpawnLocation s : stats.spawnLocations) {
                    for (Integer biomeID : biomeIDs) {
                        if (s == SpawnLocation.Land || s == SpawnLocation.Air) {
                            SpawnRegistry.storeSpawnInfo(biomeSpawns, stats.pixelmonName, stats.rarity, PixelmonEntityList.ClassType.Pixelmon, biomeID, s);
                            continue;
                        }
                        if (s == SpawnLocation.AirPersistent) {
                            SpawnRegistry.storeSpawnInfo(airSpawns, stats.pixelmonName, stats.rarity, PixelmonEntityList.ClassType.Pixelmon, biomeID, s);
                            continue;
                        }
                        if (s == SpawnLocation.UnderGround) {
                            SpawnRegistry.storeSpawnInfo(undergroundSpawns, stats.pixelmonName, stats.rarity, PixelmonEntityList.ClassType.Pixelmon, biomeID, s);
                            continue;
                        }
                        if (s != SpawnLocation.Water) continue;
                        SpawnRegistry.storeSpawnInfo(biomeWaterSpawns, stats.pixelmonName, stats.rarity, PixelmonEntityList.ClassType.Pixelmon, biomeID, s);
                    }
                }
            }
        }
    }

    public static boolean addPixelmonSpawnToBiome(String pixelmonName, String biomeName) {
        Integer biomeID = null;
        BaseStats stats = null;
        if (!EnumPokemon.hasPokemon(pixelmonName)) {
            System.out.println("[Warning] Unable to add custom spawn for " + pixelmonName + " to " + biomeName + ". Pokemon does not exist!");
            return false;
        }
        String correctName = EnumPokemon.getFromName((String)pixelmonName).name;
        stats = Entity3HasStats.getBaseStats(correctName);
        biomeID = PixelmonBiomeDictionary.getBiomeIDFromName(biomeName);
        if (biomeID == null) {
            System.out.println("[Warning] Unable to add custom spawn for " + pixelmonName + " to " + biomeName + ". Biome not found!");
            return false;
        }
        if (biomeID != null && stats != null) {
            Integer[] tempIDs = new Integer[stats.biomeIDs.length + 1];
            System.arraycopy(stats.biomeIDs, 0, tempIDs, 0, stats.biomeIDs.length);
            tempIDs[stats.biomeIDs.length] = biomeID;
            stats.biomeIDs = tempIDs;
            SpawnRegistry.addPixelmonSpawn(stats);
            return true;
        }
        return false;
    }

    public static void addNPCSpawn(String name, int rarity, PixelmonEntityList.ClassType type) {
        Integer[] biomeIDs = DatabaseTrainers.GetSpawnBiomeIDs(name);
        if (biomeIDs == null) {
            return;
        }
        for (Integer biomeID : biomeIDs) {
            SpawnRegistry.storeSpawnInfo(biomeSpawns, name, new Rarity(rarity, rarity, rarity), type, biomeID, null);
        }
    }

    private static void storeSpawnInfo(HashMap<Integer, List<SpawnData>> hashmap, String name, Rarity rarity, PixelmonEntityList.ClassType type, Integer biomeID, SpawnLocation s) {
        List<Object> spawnList = hashmap.containsKey(biomeID) ? hashmap.get(biomeID) : new ArrayList();
        spawnList.add(new SpawnData(name, rarity, type, s));
        hashmap.put(biomeID, spawnList);
    }

    public static void getGenerationInfo(HashMap<String, String> hashmap, String name) {
        ArrayList spawnList = new ArrayList();
        BaseStats stats = Entity3HasStats.getBaseStats(name);
        if (stats == null) {
            System.out.println("[Pixelmon] " + name + " returned NULL stats");
        } else {
            int ID = stats.nationalPokedexNumber;
            PixelmonEntityList.ClassType type = PixelmonEntityList.ClassType.Pixelmon;
            if (!hashmap.containsKey(name) && stats.rarity != null) {
                if (ID <= 151) {
                    if (PixelmonConfig.Gen1) {
                        SpawnRegistry.addPixelmonSpawn(stats);
                        hashmap.put(name, "Gen1");
                    }
                } else if (ID > 151 && ID <= 251) {
                    if (PixelmonConfig.Gen2) {
                        SpawnRegistry.addPixelmonSpawn(stats);
                        hashmap.put(name, "Gen2");
                    }
                } else if (ID > 251 && ID <= 386) {
                    if (PixelmonConfig.Gen3) {
                        SpawnRegistry.addPixelmonSpawn(stats);
                        hashmap.put(name, "Gen3");
                    }
                } else if (ID > 386 && ID <= 493) {
                    if (PixelmonConfig.Gen4) {
                        SpawnRegistry.addPixelmonSpawn(stats);
                        hashmap.put(name, "Gen4");
                    }
                } else if (ID > 493 && ID <= 649) {
                    if (PixelmonConfig.Gen5) {
                        SpawnRegistry.addPixelmonSpawn(stats);
                        hashmap.put(name, "Gen5");
                    }
                } else if (ID > 649 && ID <= 719) {
                    if (PixelmonConfig.Gen6) {
                        SpawnRegistry.addPixelmonSpawn(stats);
                        hashmap.put(name, "Gen6");
                    }
                } else {
                    System.out.println("[Pixelmon]" + name + " does not have a valid id number");
                }
            }
        }
    }

    public static List<SpawnData> getLegendarySpawnsForBiome(Integer biomeID) {
        return legendarySpawns.get(biomeID);
    }

    public static List<SpawnData> getSpawnsForBiome(Integer biomeID) {
        return biomeSpawns.get(biomeID);
    }

    public static List<SpawnData> getUndergroundSpawns() {
        ArrayList<SpawnData> undergroundSpawnData = new ArrayList<SpawnData>();
        HashSet<String> alreadyListed = new HashSet<String>();
        for (Integer biomeID : undergroundSpawns.keySet()) {
            for (SpawnData sd : undergroundSpawns.get(biomeID)) {
                if (alreadyListed.contains(sd.name)) continue;
                undergroundSpawnData.add(sd);
                alreadyListed.add(sd.name);
            }
        }
        return undergroundSpawnData;
    }

    public static List<SpawnData> getWaterSpawnsForBiome(Integer biomeID) {
        return biomeWaterSpawns.get(biomeID);
    }

    public static List<SpawnData> getAirSpawnsForBiome(Integer biomeID) {
        return airSpawns.get(biomeID);
    }
}

