/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning.spawners;

import com.google.common.eventbus.EventBus;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.spawning.SpawnData;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnRequestEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.Chunk;

public abstract class SpawnerBase {
    public static final EventBus SPAWN_DENIAL_BUS = new EventBus("Pixelmon Spawn Denial");
    public SpawnLocation spawnLocation;
    public int count = 0;
    public int maxNum = 0;
    static ArrayList<Material> validFloorMaterials = new ArrayList();
    static ArrayList<Material> validAirMaterials;

    public SpawnerBase(int maxNum, SpawnLocation spawnLocation) {
        this.maxNum = maxNum;
        this.spawnLocation = spawnLocation;
    }

    public static void register(Object obj) {
        SPAWN_DENIAL_BUS.register(obj);
    }

    protected boolean requestSpawn(World world, int x, int y, int z) {
        SpawnRequestEvent event = new SpawnRequestEvent(world, x, y, z, this.spawnLocation);
        SPAWN_DENIAL_BUS.post((Object)event);
        return event.approved;
    }

    public abstract Integer getSpawnConditionY(World var1, int var2, int var3);

    public abstract String getRandomPokemon(WorldProvider var1, Random var2, int var3, int var4, int var5);

    public boolean canPokemonSpawnHere(World par1World, int par2, int par3, int par4) {
        if (!this.requestSpawn(par1World, par2, par3, par4)) {
            return false;
        }
        return this.canPokemonSpawnHereImpl(par1World, par2, par3, par4);
    }

    public float getYOffset(EntityLiving pokemon) {
        return 0.0f;
    }

    public static worldState getWorldState(World world) {
        long time = world.func_72820_D() % 24000L;
        worldState state = time >= 22500L || time < 1000L ? worldState.dawn : (time >= 1000L && time < 11000L ? worldState.day : (time >= 11000L && time < 13500L ? worldState.dusk : worldState.night));
        return state;
    }

    public static String getPokemonFromList(List<SpawnData> spawnList, World world) {
        worldState state = SpawnerBase.getWorldState((World)MinecraftServer.func_71276_C().func_71218_a(0));
        int totalRarity = 0;
        for (int i = 0; i < spawnList.size(); ++i) {
            totalRarity += spawnList.get(i).getRarity(state);
        }
        if (totalRarity > 0) {
            int num = RandomHelper.getRandomNumberBetween(0, totalRarity - 1);
            int sum = 0;
            for (int i = 0; i < spawnList.size(); ++i) {
                int rarity = 0;
                if (num < sum + (rarity += spawnList.get(i).getRarity(state))) {
                    return spawnList.get((int)i).name;
                }
                sum += rarity;
            }
        }
        return null;
    }

    public boolean spawnLegendaries() {
        return true;
    }

    protected abstract boolean canPokemonSpawnHereImpl(World var1, int var2, int var3, int var4);

    public boolean isBlockValidForPixelmonSpawning(World world, int cpX, int cpY, int cpZ) {
        Material spawnFloorGroundMaterial = world.func_147439_a(cpX, cpY - 1, cpZ).func_149688_o();
        Material[] spawnAirMaterial = new Material[]{world.func_147439_a(cpX, cpY, cpZ).func_149688_o(), world.func_147439_a(cpX, cpY + 1, cpZ).func_149688_o()};
        ArrayList<Material> validFloorMaterials = this.getValidSpawnFloorMaterials();
        ArrayList<Material> validAirMaterials = this.getValidSpawnAirMaterials();
        return validFloorMaterials.contains(spawnFloorGroundMaterial) && validAirMaterials.contains(spawnAirMaterial[0]) && validAirMaterials.contains(spawnAirMaterial[1]);
    }

    public ArrayList<Material> getValidSpawnFloorMaterials() {
        return validFloorMaterials;
    }

    public ArrayList<Material> getValidEarthMaterials() {
        return validFloorMaterials;
    }

    public ArrayList<Material> getValidSpawnAirMaterials() {
        return validAirMaterials;
    }

    public Integer getTopEarthBlock(World world, int cpX, int cpZ) {
        Chunk chunk = world.func_72938_d(cpX, cpZ);
        Integer k = null;
        k = Math.max(0, Math.min(chunk.func_76625_h() + 15, 255));
        while (k > 0) {
            Block block = world.func_147439_a(cpX, k.intValue(), cpZ);
            if (block != Blocks.field_150350_a && this.getValidEarthMaterials().contains(world.func_147439_a(cpX, k.intValue(), cpZ).func_149688_o()) && !world.func_147439_a(cpX, k.intValue(), cpZ).isFoliage((IBlockAccess)world, cpX, k.intValue(), cpZ)) {
                return k + 1;
            }
            k = k - 1;
        }
        return null;
    }

    public Integer getTopWaterBlock(World world, int cpX, int cpZ) {
        Chunk chunk = world.func_72938_d(cpX, cpZ);
        Integer k = null;
        k = Math.max(0, Math.min(chunk.func_76625_h() + 15, 255));
        while (k > 0) {
            Block block = world.func_147439_a(cpX, k.intValue(), cpZ);
            if (block != Blocks.field_150350_a && world.func_147439_a(cpX, k.intValue(), cpZ).func_149688_o() == Material.field_151586_h) {
                return k;
            }
            k = k - 1;
        }
        return null;
    }

    static {
        validFloorMaterials.add(Material.field_151577_b);
        validFloorMaterials.add(Material.field_151578_c);
        validFloorMaterials.add(Material.field_151576_e);
        validFloorMaterials.add(Material.field_151595_p);
        validFloorMaterials.add(Material.field_151588_w);
        validAirMaterials = new ArrayList();
        validAirMaterials.add(Material.field_151579_a);
    }

    public static enum worldState {
        day,
        dusk,
        dawn,
        night;

    }
}

