/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning.spawners;

import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.spawning.PixelmonBiomeDictionary;
import com.pixelmonmod.pixelmon.spawning.SpawnData;
import com.pixelmonmod.pixelmon.spawning.SpawnRegistry;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldType;

public class SpawnerLand
extends SpawnerBase {
    static ArrayList<Material> validFloorMaterials = new ArrayList();
    static ArrayList<Material> validAirMaterials;

    public SpawnerLand() {
        super(PixelmonConfig.maxNumLandPokemon, SpawnLocation.Land);
    }

    @Override
    public Integer getSpawnConditionY(World world, int cpX, int cpZ) {
        if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c && this.isBlockValidForPixelmonSpawning(world, cpX, world.func_72976_f(cpX, cpZ), cpZ)) {
            return world.func_72976_f(cpX, cpZ);
        }
        Integer topEarth = this.getTopEarthBlock(world, cpX, cpZ);
        if (topEarth == null) {
            return null;
        }
        Integer cpY = null;
        if (this.isBlockValidForPixelmonSpawning(world, cpX, topEarth, cpZ)) {
            cpY = topEarth;
        } else {
            Integer biomeID = world.func_72807_a((int)cpX, (int)cpZ).field_76756_M;
            if (PixelmonBiomeDictionary.isBiomeOfType(biomeID, PixelmonBiomeDictionary.Type.JUNGLE)) {
                for (int i = 0; i < 5; ++i) {
                    if (!this.isBlockValidForPixelmonSpawning(world, cpX, topEarth + i, cpZ)) continue;
                    cpY = topEarth + i;
                    break;
                }
            }
        }
        return cpY;
    }

    @Override
    public String getRandomPokemon(WorldProvider worldProvider, Random rand, int par2, int par3, int par4) {
        Integer biomeID = worldProvider.field_76579_a.func_72807_a((int)par2, (int)par4).field_76756_M;
        List<SpawnData> spawnData = SpawnRegistry.getSpawnsForBiome(biomeID);
        return spawnData != null && !spawnData.isEmpty() ? SpawnerLand.getPokemonFromList(spawnData, worldProvider.field_76579_a) : null;
    }

    @Override
    public boolean canPokemonSpawnHereImpl(World par1World, int par2, int par3, int par4) {
        return this.isBlockValidForPixelmonSpawning(par1World, par2, par3, par4);
    }

    @Override
    public ArrayList<Material> getValidSpawnFloorMaterials() {
        return validFloorMaterials;
    }

    @Override
    public ArrayList<Material> getValidSpawnAirMaterials() {
        return validAirMaterials;
    }

    static {
        validFloorMaterials.add(Material.field_151596_z);
        validFloorMaterials.add(Material.field_151577_b);
        validFloorMaterials.add(Material.field_151578_c);
        validFloorMaterials.add(Material.field_151588_w);
        validFloorMaterials.add(Material.field_151584_j);
        validFloorMaterials.add(Material.field_151576_e);
        validFloorMaterials.add(Material.field_151595_p);
        validFloorMaterials.add(Material.field_151597_y);
        validFloorMaterials.add(Material.field_151598_x);
        validAirMaterials = new ArrayList();
        validAirMaterials.add(Material.field_151579_a);
        validAirMaterials.add(Material.field_151585_k);
        validAirMaterials.add(Material.field_151597_y);
        validAirMaterials.add(Material.field_151582_l);
    }
}

