/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning.spawners;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.spawning.SpawnData;
import com.pixelmonmod.pixelmon.spawning.SpawnRegistry;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;

public class SpawnerUnderWater
extends SpawnerBase {
    static ArrayList<Material> validFloorMaterials = new ArrayList();
    static ArrayList<Material> validAirMaterials;

    public SpawnerUnderWater() {
        super(PixelmonConfig.maxNumWaterPokemon, SpawnLocation.Water);
    }

    @Override
    public Integer getSpawnConditionY(World world, int cpX, int cpZ) {
        Integer k;
        Integer topEarth = this.getTopEarthBlock(world, cpX, cpZ);
        Integer topWater = this.getTopWaterBlock(world, cpX, cpZ);
        if (topEarth == null || topWater == null) {
            return null;
        }
        Integer cpY = null;
        if (topWater > topEarth && this.isBlockValidForPixelmonSpawning(world, cpX, k = Integer.valueOf(RandomHelper.getRandomNumberBetween(topEarth, topWater)), cpZ)) {
            cpY = k;
        }
        return cpY;
    }

    @Override
    public String getRandomPokemon(WorldProvider worldProvider, Random rand, int par2, int par3, int par4) {
        Integer biomeID = worldProvider.field_76579_a.func_72807_a((int)par2, (int)par4).field_76756_M;
        List<SpawnData> spawnData = SpawnRegistry.getWaterSpawnsForBiome(biomeID);
        return spawnData != null && !spawnData.isEmpty() ? SpawnerUnderWater.getPokemonFromList(spawnData, worldProvider.field_76579_a) : null;
    }

    @Override
    public boolean canPokemonSpawnHereImpl(World par1World, int par2, int par3, int par4) {
        return this.isBlockValidForPixelmonSpawning(par1World, par2, par3, par4);
    }

    @Override
    public ArrayList<Material> getValidSpawnFloorMaterials() {
        return validFloorMaterials;
    }

    @Override
    public ArrayList<Material> getValidSpawnAirMaterials() {
        return validAirMaterials;
    }

    static {
        validFloorMaterials.add(Material.field_151586_h);
        validAirMaterials = new ArrayList();
        validAirMaterials.add(Material.field_151579_a);
        validAirMaterials.add(Material.field_151586_h);
    }
}

