/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning.spawners;

import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.spawning.SpawnData;
import com.pixelmonmod.pixelmon.spawning.SpawnRegistry;
import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.util.ForgeDirection;

public class SpawnerUnderground
extends SpawnerBase {
    protected static final int ENCLOSURE_RADIUS = 5;
    static ArrayList<Material> validFloorMaterials = new ArrayList();

    public SpawnerUnderground() {
        super(PixelmonConfig.maxNumUndergroundPokemon, SpawnLocation.UnderGround);
    }

    @Override
    public Integer getSpawnConditionY(World world, int cpX, int cpZ) {
        if (world.func_72912_H().func_76067_t() == WorldType.field_77138_c) {
            return null;
        }
        int intMaxAttempts = 5;
        boolean isValidY = false;
        Integer cpY = null;
        for (int intCounter = 0; intCounter < intMaxAttempts && !isValidY; ++intCounter) {
            cpY = world.field_73012_v.nextInt(55) + 5;
            isValidY = this.canPokemonSpawnHereImpl(world, cpX, cpY, cpZ);
        }
        if (isValidY) {
            return cpY;
        }
        return null;
    }

    @Override
    public String getRandomPokemon(WorldProvider worldProvider, Random rand, int par2, int par3, int par4) {
        List<SpawnData> spawnData = SpawnRegistry.getUndergroundSpawns();
        return spawnData != null && !spawnData.isEmpty() ? SpawnerUnderground.getPokemonFromList(spawnData, worldProvider.field_76579_a) : null;
    }

    @Override
    public boolean canPokemonSpawnHereImpl(World par1World, int par2, int par3, int par4) {
        if (!this.isMostlyEnclosedSpace(par1World, par2, par3, par4, 5)) {
            return false;
        }
        return this.isBlockValidForPixelmonSpawning(par1World, par2, par3, par4);
    }

    protected boolean isMostlyEnclosedSpace(World world, int x, int y, int z, int radius) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            boolean ok = false;
            for (int i = 0; i < radius; ++i) {
                if (!world.func_147445_c(x + dir.offsetX * i, y + dir.offsetY * i, z + dir.offsetZ * i, true)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean spawnLegendaries() {
        return false;
    }

    @Override
    public ArrayList<Material> getValidSpawnFloorMaterials() {
        return validFloorMaterials;
    }

    static {
        validFloorMaterials.add(Material.field_151577_b);
        validFloorMaterials.add(Material.field_151578_c);
        validFloorMaterials.add(Material.field_151576_e);
    }
}

