/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pcClientStorage.PCAdd;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pcClientStorage.PCClear;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pcClientStorage.PCRemove;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ComputerBox {
    public boolean hasChanged = false;
    public static final int boxLimit = 30;
    public int position;
    private NBTTagCompound[] storedPokemon = new NBTTagCompound[30];
    private PlayerComputerStorage parentStorage;

    public ComputerBox(PlayerComputerStorage parentStorage, int position) {
        this.position = position;
        this.hasChanged = true;
        this.parentStorage = parentStorage;
    }

    public boolean hasSpace() {
        int count = 0;
        for (int i = 0; i < 30; ++i) {
            if (this.storedPokemon[i] == null) continue;
            ++count;
        }
        return count < 30;
    }

    public int count() {
        int count = 0;
        for (int i = 0; i < 30; ++i) {
            if (this.storedPokemon[i] == null) continue;
            ++count;
        }
        return count;
    }

    public void add(EntityPixelmon p) {
        NBTTagCompound n = new NBTTagCompound();
        p.setPokemonId(new int[]{this.parentStorage.getPlayerId(), this.parentStorage.playerStorage.idcounter++});
        p.func_70014_b(n);
        p.func_70109_d(n);
        n.func_74778_a("id", p.getName());
        n.func_74757_a("IsInBall", true);
        n.func_74757_a("IsShiny", p.getIsShiny());
        n.func_74778_a("originalTrainer", ((EntityPlayerMP)p.func_70902_q()).getDisplayName());
        int pos = this.getNextSpace();
        n.func_74768_a("PixelmonOrder", pos);
        n.func_74768_a("BoxNumber", this.position);
        if (n.func_74765_d("Health") > 0) {
            n.func_74757_a("IsFainted", false);
        }
        this.storedPokemon[pos] = n;
        this.hasChanged = true;
    }

    public int getNextSpace() {
        for (int i = 0; i < 30; ++i) {
            if (this.storedPokemon[i] != null) continue;
            return i;
        }
        return 0;
    }

    public NBTTagCompound get(int[] id) {
        for (NBTTagCompound n : this.storedPokemon) {
            if (n == null || !PixelmonMethods.isIDSame(n, id)) continue;
            return n;
        }
        return null;
    }

    public NBTTagCompound[] getStoredPokemon() {
        for (int i = 0; i < this.storedPokemon.length; ++i) {
            NBTTagCompound n = this.storedPokemon[i];
            if (n == null) continue;
            if (n.func_74779_i("Name").equals("")) {
                this.storedPokemon[i] = null;
            }
            if (!n.func_74764_b("HeldItem")) continue;
            if (n.func_74762_e("HeldItem") != -1) {
                n.func_74782_a("HeldItemStack", (NBTBase)new ItemStack(Item.func_150899_d((int)n.func_74762_e("HeldItem")), 1).func_77955_b(new NBTTagCompound()));
            }
            n.func_82580_o("HeldItem");
        }
        return this.storedPokemon;
    }

    public NBTTagCompound getNBTByPosition(int pos) {
        return this.storedPokemon[pos];
    }

    public void load(NBTTagCompound boxTag) {
        int i;
        for (i = 0; i < 30; ++i) {
            this.storedPokemon[i] = null;
        }
        for (i = 0; i < 30; ++i) {
            if (!boxTag.func_74764_b("pc" + i)) continue;
            NBTTagCompound tag = boxTag.func_74775_l("pc" + i);
            if (!tag.func_74764_b("pixelmonID1")) {
                int[] id = new int[]{this.parentStorage.getPlayerId(), this.parentStorage.playerStorage.idcounter++};
                tag.func_74768_a("pixelmonID1", id[0]);
                tag.func_74768_a("pixelmonID2", id[1]);
            }
            this.storedPokemon[i] = tag;
        }
        this.hasChanged = false;
    }

    public void save(NBTTagCompound nbt) {
        for (int i = 0; i < 30; ++i) {
            if (this.storedPokemon[i] == null) continue;
            nbt.func_74782_a("pc" + i, (NBTBase)this.storedPokemon[i]);
        }
        this.hasChanged = false;
    }

    public void addToFirstSpace(NBTTagCompound n) {
        for (int i = 0; i < 30; ++i) {
            if (this.storedPokemon[i] != null) continue;
            n.func_74768_a("PixelmonOrder", i);
            this.storedPokemon[i] = n;
            this.updatePCData(i);
            this.hasChanged = true;
            return;
        }
    }

    public void changePokemon(int boxPos, NBTTagCompound n) {
        if (n != null) {
            n.func_74768_a("PixelmonOrder", boxPos);
            n.func_74768_a("BoxNumber", this.position);
        }
        this.storedPokemon[boxPos] = n;
        this.hasChanged = true;
    }

    private void updatePCData(int pos) {
        if (this.parentStorage.getPlayer() != null) {
            Pixelmon.network.sendTo((IMessage)new PCClear(), this.parentStorage.getPlayer());
            if (this.storedPokemon[pos] != null) {
                Pixelmon.network.sendTo((IMessage)new PCAdd(new PixelmonData(this.storedPokemon[pos])), this.parentStorage.getPlayer());
            } else {
                Pixelmon.network.sendTo((IMessage)new PCRemove(this.position, pos), this.parentStorage.getPlayer());
            }
        }
    }

    public boolean contains(int[] id) {
        for (NBTTagCompound n : this.storedPokemon) {
            if (n == null || !PixelmonMethods.isIDSame(n, id)) continue;
            return true;
        }
        return false;
    }

    public EntityPixelmon getPokemonEntity(int[] pokemonID) {
        for (NBTTagCompound n : this.storedPokemon) {
            if (n == null || !PixelmonMethods.isIDSame(n, pokemonID)) continue;
            n.func_74776_a("FallDistance", 0.0f);
            n.func_74757_a("IsInBall", false);
            EntityPixelmon e = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(n, this.parentStorage.world);
            e.func_152115_b(this.parentStorage.playerUUID.toString());
            e.playerOwned = true;
            e.field_70179_y = 0.0;
            e.field_70181_x = 0.0;
            e.field_70159_w = 0.0;
            e.field_70128_L = false;
            return e;
        }
        return null;
    }

    public void updatePokemonEntry(EntityPixelmon p) {
        for (int i = 0; i < this.storedPokemon.length; ++i) {
            NBTTagCompound nbt = this.storedPokemon[i];
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, p)) continue;
            NBTTagCompound n = new NBTTagCompound();
            p.func_70014_b(n);
            p.func_70109_d(n);
            n.func_74778_a("id", p.getName());
            n.func_74757_a("IsInBall", true);
            n.func_74757_a("IsShiny", p.getIsShiny());
            n.func_74768_a("PixelmonOrder", nbt.func_74762_e("PixelmonOrder"));
            n.func_74757_a("isInRanch", nbt.func_74767_n("isInRanch"));
            n.func_74768_a("BoxNumber", this.position);
            if (n.func_74765_d("Health") > 0) {
                n.func_74757_a("IsFainted", false);
            }
            this.storedPokemon[i] = n;
            this.hasChanged = true;
        }
    }

    public NBTTagCompound getPokemonNBT(int[] id) {
        for (NBTTagCompound n : this.storedPokemon) {
            if (n == null || !PixelmonMethods.isIDSame(n, id)) continue;
            return n;
        }
        return null;
    }

    public void updatePokemonNBT(int[] id, NBTTagCompound nbt) {
        for (int i = 0; i < this.storedPokemon.length; ++i) {
            NBTTagCompound n = this.storedPokemon[i];
            if (n == null || !PixelmonMethods.isIDSame(n, id)) continue;
            this.storedPokemon[i] = nbt;
            this.hasChanged = true;
        }
    }

    public void unlockAllPokemon() {
        for (int i = 0; i < 30; ++i) {
            if (this.storedPokemon[i] == null) continue;
            this.storedPokemon[i].func_74757_a("isInRanch", false);
        }
    }

    public int getPlayerIdFromPokemon() {
        for (int i = 0; i < 30; ++i) {
            if (this.storedPokemon[i] == null) continue;
            return PixelmonMethods.getID(this.storedPokemon[i])[0];
        }
        return -1;
    }
}

