/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;

public class ComputerManager {
    private File workingDir;
    private ArrayList<PlayerComputerStorage> playerComputerList = new ArrayList();

    public PlayerComputerStorage getPlayerStorage(EntityPlayerMP owner) {
        for (PlayerComputerStorage p : this.playerComputerList) {
            if (!p.getPlayer().getDisplayName().equals(owner.getDisplayName())) continue;
            return p;
        }
        this.loadPlayer(owner);
        return this.getPlayerStorage(owner);
    }

    public EntityPlayerMP getPlayerFromUUID(UUID uuid) {
        for (PlayerComputerStorage p : this.playerComputerList) {
            if (!p.getPlayer().func_110124_au().equals(uuid)) continue;
            return p.getPlayer();
        }
        return null;
    }

    public PlayerComputerStorage getPlayerStorageFromUUID(World world, UUID ownerUUID) throws PlayerNotLoadedException {
        EntityPlayerMP player = this.getPlayerFromUUID(ownerUUID);
        if (player == null) {
            player = (EntityPlayerMP)world.func_152378_a(ownerUUID);
        }
        if (player != null) {
            return this.getPlayerStorage(player);
        }
        return this.getPlayerStorageOffline(world, ownerUUID);
    }

    private PlayerComputerStorage getPlayerStorageOffline(World world, UUID ownerUUID) {
        File playerFile;
        File saveDirPath = new File(this.getSaveFolder(world));
        if (!saveDirPath.exists()) {
            saveDirPath.mkdirs();
        }
        if ((playerFile = this.getSaveFile(world, ownerUUID)).exists()) {
            PlayerComputerStorage p;
            block6: {
                p = new PlayerComputerStorage(world, ownerUUID);
                try {
                    p.readFromNBT(CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(new FileInputStream(playerFile))));
                }
                catch (FileNotFoundException e) {
                    if (PixelmonConfig.printErrors) {
                        System.out.println("Couldn't read player data file for " + ownerUUID.toString());
                    }
                }
                catch (IOException e) {
                    if (!PixelmonConfig.printErrors) break block6;
                    System.out.println("Couldn't read player data file for " + ownerUUID.toString());
                }
            }
            return p;
        }
        return null;
    }

    private void loadPlayer(EntityPlayerMP player) {
        File saveDirPath = new File(this.getSaveFolder(player.field_70170_p));
        if (!saveDirPath.exists()) {
            saveDirPath.mkdirs();
        }
        File playerFile = this.getSaveFile((EntityPlayer)player);
        this.loadFromFile(playerFile, player);
    }

    private void loadFromFile(File playerFile, EntityPlayerMP player) {
        if (playerFile.exists()) {
            PlayerComputerStorage p;
            block6: {
                p = new PlayerComputerStorage(player);
                try {
                    p.readFromNBT(CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(new FileInputStream(playerFile))));
                }
                catch (FileNotFoundException e) {
                    if (PixelmonConfig.printErrors) {
                        System.out.println("Couldn't read player data file for " + player.getDisplayName());
                    }
                }
                catch (IOException e) {
                    if (!PixelmonConfig.printErrors) break block6;
                    System.out.println("Couldn't read player data file for " + player.getDisplayName());
                }
            }
            this.playerComputerList.add(p);
        } else {
            PlayerComputerStorage p = new PlayerComputerStorage(player);
            this.playerComputerList.add(p);
        }
    }

    private File getSaveFile(EntityPlayer player) {
        File playerFile = new File(this.getSaveFolder(player.field_70170_p) + player.func_110124_au().toString() + ".comp");
        if (playerFile.exists()) {
            return playerFile;
        }
        if (new File(this.getSaveFolder(player.field_70170_p) + player.getDisplayName() + ".comp").exists()) {
            new File(this.getSaveFolder(player.field_70170_p) + player.getDisplayName() + ".comp").renameTo(playerFile);
            File tmpFile = new File(this.getSaveFolder(player.field_70170_p) + player.getDisplayName() + ".comptemp");
            if (tmpFile.exists()) {
                tmpFile.renameTo(new File(this.getSaveFolder(player.field_70170_p) + player.func_110124_au() + ".comptemp"));
            }
        }
        return playerFile;
    }

    private File getSaveFile(World world, UUID uuid) {
        return new File(this.getSaveFolder(world) + uuid.toString() + ".comp");
    }

    public void saveAll() {
        for (int i = 0; i < this.playerComputerList.size(); ++i) {
            this.savePlayer(this.playerComputerList.get(i));
        }
    }

    public void savePlayer(PlayerComputerStorage storage) {
        try {
            File playerSaveFile = new File(storage.saveFile + "temp");
            if (storage.hasChanges()) {
                FileOutputStream f = new FileOutputStream(playerSaveFile);
                DataOutputStream s = new DataOutputStream(f);
                NBTTagCompound nbt = new NBTTagCompound();
                storage.writeToNBT(nbt);
                CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)s);
                s.close();
                f.close();
                this.replaceSaveFile(storage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSaveFile(PlayerComputerStorage storage) throws IOException {
        File playerSaveTempFile = new File(storage.saveFile + "temp");
        File playerSaveFile = new File(storage.saveFile);
        if (!playerSaveFile.exists()) {
            playerSaveFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(playerSaveTempFile).getChannel();
            destination = new FileOutputStream(playerSaveFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private NBTTagCompound getData(EntityPlayer player) {
        for (PlayerComputerStorage p : this.playerComputerList) {
            if (!p.getPlayer().func_110124_au().equals(player.func_110124_au())) continue;
            NBTTagCompound n = new NBTTagCompound();
            p.writeToNBT(n);
            return n;
        }
        return null;
    }

    private String getSaveFolder(World world) {
        if (MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().func_71262_S()) {
            return Pixelmon.modDirectory + "/" + MinecraftServer.func_71276_C().field_71305_c[0].func_72860_G().func_75760_g() + "/pokemon/";
        }
        return Pixelmon.modDirectory + "/saves/" + world.func_72860_G().func_75760_g() + "/pokemon/";
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.playerComputerList.clear();
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        this.saveAll();
    }

    public void onPlayerDC(EntityPlayer player) {
        if (player == null) {
            return;
        }
        for (int i = 0; i < this.playerComputerList.size(); ++i) {
            if (!this.playerComputerList.get((int)i).playerUUID.equals(player.func_110124_au())) continue;
            this.savePlayer(this.playerComputerList.get(i));
            this.playerComputerList.remove(i);
            break;
        }
    }

    public void playerLoggedIn(EntityPlayerMP player) {
        if (player == null) {
            return;
        }
        for (int i = 0; i < this.playerComputerList.size(); ++i) {
            if (!this.playerComputerList.get((int)i).playerUUID.equals(player.func_110124_au())) continue;
            this.playerComputerList.remove(i);
            break;
        }
    }
}

