/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.comm.DungeonMapPacket;
import com.pixelmonmod.pixelmon.storage.structure.AwarenessMysteryDungeon;
import com.pixelmonmod.pixelmon.util.INbt;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.MysteryDungeonFloor;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class DungeonFloorEntry
implements INbt {
    public final int x;
    public final int z;
    public final int width;
    public final int length;
    public final int dungeonID;
    public final byte floorID;
    private byte[] layout;

    public DungeonFloorEntry(AwarenessMysteryDungeon dungeon, int floor) {
        this.width = dungeon.getWidth();
        this.length = dungeon.getLength();
        this.x = dungeon.getX();
        this.z = dungeon.getZ();
        this.dungeonID = dungeon.getID();
        this.floorID = (byte)floor;
        this.layout = new byte[this.width * this.length];
    }

    public DungeonFloorEntry(NBTTagCompound nbt) {
        this.x = nbt.func_74762_e("X");
        this.z = nbt.func_74762_e("Z");
        this.width = nbt.func_74762_e("W");
        this.length = nbt.func_74762_e("L");
        this.dungeonID = nbt.func_74762_e("DI");
        this.floorID = nbt.func_74771_c("FI");
        this.layout = nbt.func_74770_j("C");
    }

    private DungeonFloorEntry(DungeonFloorEntry src) {
        this.x = src.x;
        this.z = src.z;
        this.width = src.width;
        this.length = src.length;
        this.dungeonID = src.dungeonID;
        this.floorID = src.floorID;
        this.layout = (byte[])src.layout.clone();
    }

    public DungeonFloorEntry copy() {
        return new DungeonFloorEntry(this);
    }

    public boolean update(Entity entity, AwarenessMysteryDungeon dungeon, int floorID, int radius) {
        boolean changed = false;
        for (int x0 = -radius; x0 <= radius; ++x0) {
            for (int z0 = -radius; z0 <= radius; ++z0) {
                int index;
                int z;
                int x = (int)entity.field_70165_t + x0 - dungeon.getX();
                if (!this.isInBounds(x, z = (int)entity.field_70161_v + z0 - dungeon.getZ()) || this.layout[index = this.index(x, z)] != 0) continue;
                changed = true;
                int dungeonBlockID = dungeon.getFloor(floorID)[index];
                if (dungeonBlockID == -1 || dungeonBlockID == -9) {
                    this.addRoom(x, z, dungeon.getFloor(floorID));
                    continue;
                }
                this.layout[index] = this.convertLayoutID(dungeonBlockID);
            }
        }
        return changed;
    }

    private void addRoom(int x, int z, int[] dungeonLayout) {
        int minX = x;
        int minZ = z;
        int maxX = x;
        int maxZ = z;
        for (ForgeDirection dir : WorldHelper.NWSE) {
            int scanX = x;
            int scanZ = z;
            boolean go = true;
            while (go) {
                if (scanX < minX) {
                    minX = scanX;
                }
                if (scanZ < minZ) {
                    minZ = scanZ;
                }
                if (scanX > maxX) {
                    maxX = scanX;
                }
                if (scanZ > maxZ) {
                    maxZ = scanZ;
                }
                int i = this.index(scanX += dir.offsetX, scanZ += dir.offsetZ);
                go = this.isInBounds(scanX, scanZ) && MysteryDungeonFloor.isRoomContents(dungeonLayout[i]);
            }
        }
        for (int x0 = minX; x0 <= maxX; ++x0) {
            for (int z0 = minZ; z0 <= maxZ; ++z0) {
                int index = this.index(x0, z0);
                boolean flag = this.shouldUsePassagewayID(x0, z0, minX, minZ, maxX, maxZ, dungeonLayout);
            }
        }
    }

    private boolean shouldUsePassagewayID(int i, int j, int rMinX, int rMinZ, int rMaxX, int rMaxZ, int[] dungeonLayout) {
        return false;
    }

    private boolean pointLiesOnRoomBorder(int i, int j, int rMinX, int rMinZ, int rMaxX, int rMaxZ) {
        return i == rMinX || i == rMaxX || j == rMinZ || j == rMaxZ;
    }

    private boolean pointLinksHallway(int i, int j, int[] dungeonLayout) {
        for (ForgeDirection dir : WorldHelper.NWSE) {
            int x0 = i + dir.offsetX;
            int z0 = j + dir.offsetZ;
            if (this.isInBounds(x0, z0)) continue;
            return false;
        }
        return false;
    }

    private byte convertLayoutID(int layoutID) {
        return (byte)layoutID;
    }

    private boolean isInBounds(int x, int z) {
        return x >= 0 && z >= 0 && x < this.width && z < this.length;
    }

    private int index(int x, int z) {
        return this.width * z + x;
    }

    public byte[] getLayout() {
        return this.layout;
    }

    public DungeonMapPacket getUpdatePacket() {
        return null;
    }

    @Override
    public void write(NBTTagCompound nbt) {
        nbt.func_74768_a("X", this.x);
        nbt.func_74768_a("Z", this.z);
        nbt.func_74768_a("W", this.width);
        nbt.func_74768_a("L", this.length);
        nbt.func_74768_a("DI", this.dungeonID);
        nbt.func_74774_a("FI", this.floorID);
        nbt.func_74773_a("C", this.layout);
    }

    @Override
    public void read(NBTTagCompound nbt) {
    }

    @Override
    public boolean isDirty() {
        return true;
    }
}

