/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.comm.DungeonMapPacket;
import com.pixelmonmod.pixelmon.storage.DungeonFloorEntry;
import com.pixelmonmod.pixelmon.storage.structure.AwarenessMysteryDungeon;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.world.WorldSavedData;

public class DungeonMapData
extends WorldSavedData {
    private static String ID = "MDMap_";
    private static ArrayList<DungeonMapData> mapData = new ArrayList();
    private static HashMap<Entity, DungeonPlayerEntry> playerInfo = new HashMap();
    private static final int tickRate = 7;
    private ArrayList<ArrayList<DungeonFloorEntry>> dungeons = new ArrayList();
    int dimensionID;

    public DungeonMapData(String par1Str) {
        super(par1Str);
    }

    public DungeonMapData copy(DungeonMapData other) {
        this.dungeons = new ArrayList();
        for (int i = 0; i < other.dungeons.size(); ++i) {
            this.dungeons.add(new ArrayList());
            for (int j = 0; j < other.dungeons.get(i).size(); ++j) {
                this.dungeons.get(i).add(other.dungeons.get(i).get(j));
            }
        }
        return this;
    }

    public void addData(Entity entity, AwarenessMysteryDungeon dungeon, int floorID) {
        DungeonPlayerEntry info = playerInfo.get(entity);
        if (info == null) {
            info = new DungeonPlayerEntry(null, 0, false);
        }
        if (info.ticks == 0) {
            if (dungeon != null) {
                int dungeonID = dungeon.getID();
                CommonHelper.ensureIndex(this.dungeons, dungeonID);
                ArrayList<DungeonFloorEntry> list = this.dungeons.get(dungeonID);
                if (list == null) {
                    list = new ArrayList();
                    this.dungeons.set(dungeonID, list);
                }
                CommonHelper.ensureIndex(list, floorID);
                DungeonFloorEntry floor = list.get(floorID);
                if (floor == null) {
                    floor = new DungeonFloorEntry(dungeon, floorID);
                    list.set(floorID, floor);
                }
                if (floor.update(entity, dungeon, floorID, 3)) {
                    this.func_76185_a();
                }
                info.floor = floor;
            } else {
                info.floor = null;
            }
        }
        info.ticks = (info.ticks + 1) % 5;
        playerInfo.put(entity, info);
    }

    public static DungeonMapPacket getUpdatePacket(Entity e) {
        DungeonPlayerEntry info = playerInfo.get(e);
        if (info == null || info.ticks != 0) {
            return null;
        }
        if (info.floor == null && !info.trigger) {
            info.trigger = true;
            return new DungeonMapPacket();
        }
        info.trigger = false;
        return info.floor == null ? null : info.floor.getUpdatePacket();
    }

    public void setDimensionID(int d) {
        this.dimensionID = d;
    }

    public int getDimensionID() {
        return this.dimensionID;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        Map data = CommonHelper.getMap(nbt);
        for (Map.Entry e0 : data.entrySet()) {
            if (e0.getKey().equals("I")) {
                this.dimensionID = ((NBTTagInt)e0.getValue()).func_150287_d();
                continue;
            }
            try {
                int i = Integer.parseInt(e0.getKey());
                CommonHelper.ensureIndex(this.dungeons, i);
                ArrayList<DungeonFloorEntry> floorList = new ArrayList<DungeonFloorEntry>();
                this.dungeons.set(i, floorList);
                NBTTagCompound floors = (NBTTagCompound)e0.getValue();
                Map floorsMap = CommonHelper.getMap(floors);
                for (Map.Entry e1 : floorsMap.entrySet()) {
                    try {
                        int j = Integer.parseInt(e1.getKey());
                        CommonHelper.ensureIndex(floorList, j);
                        floorList.set(j, new DungeonFloorEntry((NBTTagCompound)e1.getValue()));
                    }
                    catch (Exception e) {}
                }
            }
            catch (Exception e) {
            }
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74768_a("I", this.dimensionID);
        for (int i = 0; i < this.dungeons.size(); ++i) {
            ArrayList<DungeonFloorEntry> list0 = this.dungeons.get(i);
            NBTTagCompound floors = new NBTTagCompound();
            if (list0 == null) continue;
            for (int j = 0; j < list0.size(); ++j) {
                NBTTagCompound floor = new NBTTagCompound();
                if (list0.get(j) == null) continue;
                list0.get(j).write(floor);
                floors.func_74782_a(String.valueOf(j), (NBTBase)floor);
            }
            nbt.func_74782_a(String.valueOf(i), (NBTBase)floors);
        }
    }

    public ArrayList<ArrayList<DungeonFloorEntry>> getDungeons() {
        return this.dungeons;
    }

    public static class DungeonPlayerEntry {
        DungeonFloorEntry floor;
        int ticks;
        boolean trigger;

        public DungeonPlayerEntry(DungeonFloorEntry floor, int ticks, boolean trigger) {
            this.floor = floor;
            this.ticks = ticks;
            this.trigger = trigger;
        }
    }
}

