/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.DungeonMapPacket;
import com.pixelmonmod.pixelmon.storage.DungeonMapData;
import com.pixelmonmod.pixelmon.storage.GeneralAwareness;
import com.pixelmonmod.pixelmon.storage.structure.AwarenessMysteryDungeon;
import com.pixelmonmod.pixelmon.storage.structure.StructureStorage;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class DungeonMapStorage
extends GeneralAwareness {
    private static String ID = "MysDunMap";
    public static NBTTagCompound playersWithMapsIO = new NBTTagCompound();
    public static HashMap<Integer, EntityPlayer> playersOwningMap = new HashMap();
    private static DungeonMapStorage instance;

    public static DungeonMapStorage request() {
        return instance == null ? (instance = new DungeonMapStorage()) : instance;
    }

    public void update() {
        for (EntityPlayer player : playersOwningMap.values()) {
            this.update(player.field_70170_p, player);
        }
    }

    private void update(World par2World, EntityPlayer player) {
        DungeonMapData mapdata = this.getDMapData(player, par2World);
        this.updateMapData(par2World, (Entity)player, mapdata);
        DungeonMapPacket packet = DungeonMapData.getUpdatePacket((Entity)player);
        if (packet != null) {
            Pixelmon.network.sendTo((IMessage)packet, (EntityPlayerMP)player);
        }
    }

    public void updateMapData(World world, Entity entity, DungeonMapData dMapData) {
        if (entity.field_70170_p.field_73011_w.field_76574_g == dMapData.getDimensionID() && entity instanceof EntityPlayer) {
            AwarenessMysteryDungeon visiting = StructureStorage.visitingStructure(entity.field_70170_p, entity, AwarenessMysteryDungeon.class);
            int floorLevel = visiting == null ? -1 : visiting.visitingFloorLevel(entity);
            dMapData.addData(entity, visiting, floorLevel);
        }
    }

    public DungeonMapData getDMapData(EntityPlayer player, World par2World) {
        String s = ID + player.getDisplayName();
        DungeonMapData mapdata = (DungeonMapData)par2World.func_72943_a(DungeonMapData.class, s);
        if (mapdata == null) {
            mapdata = new DungeonMapData(s);
            mapdata.setDimensionID(par2World.field_73011_w.field_76574_g);
            mapdata.func_76185_a();
            par2World.func_72823_a(s, (WorldSavedData)mapdata);
        }
        return mapdata;
    }

    @Override
    public void onPlayerDC(EntityPlayer player) {
        playersOwningMap.remove(player.func_145782_y());
    }

    @Override
    public void playerLoggedIn(EntityPlayerMP player) {
        if (playersWithMapsIO.func_74764_b(player.getDisplayName())) {
            playersOwningMap.put(player.func_145782_y(), (EntityPlayer)player);
        }
    }

    @Override
    public void serverStarting(MinecraftServer server) {
        playersWithMapsIO = new NBTTagCompound();
        playersOwningMap = new HashMap();
    }

    @Override
    public void write(NBTTagCompound nbt) {
        nbt.func_74782_a("PS", (NBTBase)playersWithMapsIO);
    }

    @Override
    public void read(NBTTagCompound nbt) {
        playersWithMapsIO = nbt;
    }

    @Override
    public boolean isDirty() {
        return true;
    }

    @SubscribeEvent
    public void tickStart(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (!world.field_72995_K) {
            this.update();
        }
    }
}

