/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.storage.PCPos;

public class PCClientStorage {
    private static PixelmonData[][] store = new PixelmonData[16][30];

    public static void addToList(PixelmonData p) {
        PCClientStorage.store[p.boxNumber][p.order] = p;
    }

    public static void clearList() {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 30; ++j) {
                PCClientStorage.store[i][j] = null;
            }
        }
    }

    public static PixelmonData getFromBox(int i, int j) {
        return store[i][j];
    }

    public static PixelmonData getPixelmonDataFromID(int[] id) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 30; ++j) {
                if (store[i][j] == null || !PixelmonMethods.isIDSame(PCClientStorage.store[i][j].pokemonID, id)) continue;
                return store[i][j];
            }
        }
        return null;
    }

    public static void removeFromList(int box, int pos) {
        PCClientStorage.store[box][pos] = null;
    }

    public static void changePokemon(int box, int pos, PixelmonData pkt) {
        PCClientStorage.store[box][pos] = pkt;
    }

    public static int numSelected() {
        int num = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 30; ++j) {
                if (store[i][j] == null || !PCClientStorage.store[i][j].selected) continue;
                ++num;
            }
        }
        return num;
    }

    public static PixelmonData getSelected() {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 30; ++j) {
                if (store[i][j] == null || !PCClientStorage.store[i][j].selected) continue;
                return store[i][j];
            }
        }
        return null;
    }

    public static PCPos getPos(PixelmonData p) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 30; ++j) {
                if (store[i][j] != p) continue;
                return new PCPos(i, j);
            }
        }
        return null;
    }

    public static PixelmonData getByID(int[] id) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 30; ++j) {
                if (store[i][j] == null || !PixelmonMethods.isIDSame(PCClientStorage.store[i][j].pokemonID, id)) continue;
                return store[i][j];
            }
        }
        return null;
    }
}

