/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.PixelmonDeletedEvent;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pcClientStorage.PCAdd;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pcClientStorage.PCClear;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.ComputerBox;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class PCServer {
    public static void deletePokemon(EntityPlayerMP player, int box, int pos) {
        try {
            PixelmonStorage.PokeballManager.getPlayerStorage(player).recallAllPokemon();
        }
        catch (PlayerNotLoadedException e) {
            e.printStackTrace();
        }
        Pixelmon.EVENT_BUS.post((Event)new PixelmonDeletedEvent(player, PCServer.getPokemonAtPos(player, box, pos)));
        PCServer.storePokemonAtPos(player, null, box, pos);
    }

    public static void swapPokemon(EntityPlayerMP player, int firstBox, int firstPos, int secondBox, int secondPos) {
        NBTTagCompound n1 = PCServer.getPokemonAtPos(player, firstBox, firstPos);
        NBTTagCompound n2 = PCServer.getPokemonAtPos(player, secondBox, secondPos);
        PCServer.unloadEntity(player, firstBox, firstPos);
        PCServer.unloadEntity(player, secondBox, secondPos);
        PCServer.storePokemonAtPos(player, n1, secondBox, secondPos);
        PCServer.storePokemonAtPos(player, n2, firstBox, firstPos);
    }

    private static void storePokemonAtPos(EntityPlayerMP player, NBTTagCompound nbt, int box, int pos) {
        try {
            if (box == -1) {
                PlayerStorage store = PixelmonStorage.PokeballManager.getPlayerStorage(player);
                store.changePokemon(pos, nbt);
            } else {
                PixelmonStorage.ComputerManager.getPlayerStorage(player).getBox(box).changePokemon(pos, nbt);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.getStackTrace());
        }
    }

    private static void unloadEntity(EntityPlayerMP player, int box, int pos) {
        try {
            PlayerStorage store = PixelmonStorage.PokeballManager.getPlayerStorage(player);
            int[] id = store.getIDFromPosition(pos);
            if (id[0] != -1 && id[1] != -1 && store.EntityAlreadyExists(id, store.player.field_70170_p)) {
                EntityPixelmon p = store.getAlreadyExists(id, store.player.field_70170_p);
                p.unloadEntity();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static NBTTagCompound getPokemonAtPos(EntityPlayerMP player, int box, int pos) {
        try {
            if (box == -1) {
                return PixelmonStorage.PokeballManager.getPlayerStorage(player).getList()[pos];
            }
            return PixelmonStorage.ComputerManager.getPlayerStorage(player).getBox(box).getNBTByPosition(pos);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void sendContentsToPlayer(EntityPlayerMP player) {
        Pixelmon.network.sendTo((IMessage)new PCClear(), player);
        PlayerComputerStorage s = PixelmonStorage.ComputerManager.getPlayerStorage(player);
        for (ComputerBox b : s.getBoxList()) {
            for (NBTTagCompound n : b.getStoredPokemon()) {
                if (n == null) continue;
                PixelmonData p = new PixelmonData(n);
                Pixelmon.network.sendTo((IMessage)new PCAdd(p), player);
            }
        }
    }
}

