/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.PixelmonUpdateData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset.ChooseMoveset;
import com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset.ChoosingMovesetData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.Add;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.Remove;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.Update;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.entities.npcs.EntityTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumPokeballs;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStats;
import com.pixelmonmod.pixelmon.storage.PokeballManager;
import com.pixelmonmod.pixelmon.storage.playerData.ExternalMoves;
import com.pixelmonmod.pixelmon.storage.playerData.PlayerData;
import com.pixelmonmod.pixelmon.storage.playerData.TeleportPosition;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PlayerStorage
implements IExtendedEntityProperties {
    public NBTTagCompound[] partyPokemon = new NBTTagCompound[6];
    public ExternalMoves moves;
    public TeleportPosition teleportPos = new TeleportPosition();
    int idcounter = 0;
    private int pokeDollars = 0;
    private static final int carryLimit = 6;
    public EntityPlayerMP player;
    public EntityTrainer trainer;
    public String userName;
    public String saveFile;
    public PokeballManager.PokeballManagerMode mode;
    public Pokedex pokedex;
    public PlayerStats stats;
    public boolean guiOpened = false;
    public boolean battleEnabled = true;
    public boolean starterPicked = false;
    private int ticksSinceEggStepCheck = 0;
    public PlayerData playerData = new PlayerData();

    public PlayerStorage(EntityPlayerMP player) {
        this.moves = new ExternalMoves(this);
        this.mode = PokeballManager.PokeballManagerMode.Player;
        this.player = player;
        this.userName = player.getDisplayName();
        this.saveFile = MinecraftServer.func_71276_C().func_71262_S() ? Pixelmon.modDirectory + "/" + MinecraftServer.func_71276_C().field_71305_c[0].func_72860_G().func_75760_g() + "/pokemon/" + player.func_110124_au().toString() + ".pk" : Pixelmon.modDirectory + "/saves/" + player.field_70170_p.func_72860_G().func_75760_g() + "/pokemon/" + player.func_110124_au().toString() + ".pk";
        this.pokedex = new Pokedex((Entity)player);
        this.stats = new PlayerStats(player);
    }

    public PlayerStorage(EntityTrainer trainer) {
        this.mode = PokeballManager.PokeballManagerMode.Trainer;
        this.trainer = trainer;
    }

    public int getCurrency() {
        return this.pokeDollars;
    }

    public void setCurrency(int par1) {
        this.pokeDollars = par1;
        if (this.pokeDollars >= 999999) {
            this.pokeDollars = 999999;
        }
        if (this.pokeDollars <= 0) {
            this.pokeDollars = 0;
        }
    }

    public boolean hasSpace() {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt != null) continue;
            return true;
        }
        return false;
    }

    public int getNextOpen() {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            if (this.partyPokemon[i] != null) continue;
            return i;
        }
        return 0;
    }

    public void setPokemon(NBTTagCompound[] pokemon) {
        this.partyPokemon = pokemon;
    }

    public void addToParty(EntityPixelmon p) {
        if (this.mode == PokeballManager.PokeballManagerMode.Player && this.pokedex != null) {
            this.pokedex.set(Pokedex.nameToID(p.getName()), Pokedex.DexRegisterStatus.caught);
            this.pokedex.sendToPlayer((EntityPlayerMP)this.pokedex.owner);
        }
        if (p.getMoveset().size() == 0) {
            p.loadMoveset();
        }
        p.setBoss(EnumBossMode.NotBoss);
        if (p.caughtBall == null) {
            p.caughtBall = EnumPokeballs.PokeBall;
        }
        int[] id = new int[]{-1, -1};
        if (this.mode == PokeballManager.PokeballManagerMode.Player) {
            p.func_152115_b(this.player.func_110124_au().toString());
            id = new int[]{this.player.getDisplayName().hashCode(), this.idcounter++};
        } else if (this.mode == PokeballManager.PokeballManagerMode.Trainer) {
            p.setTrainer(this.trainer);
            id = new int[]{(int)this.trainer.func_110124_au().getLeastSignificantBits(), this.idcounter++};
        }
        if (!this.hasSpace()) {
            ChatHandler.sendChat((Entity)p.func_70902_q(), "pixelmon.storage.partyfull", p.isEgg ? "Egg" : p.getNickname());
            PixelmonStorage.ComputerManager.getPlayerStorage(this.player).addToComputer(p);
            return;
        }
        NBTTagCompound n = new NBTTagCompound();
        p.setPokemonId(id);
        p.func_70109_d(n);
        n.func_74778_a("id", "Pixelmon");
        n.func_74757_a("IsInBall", true);
        n.func_74757_a("IsShiny", p.getIsShiny());
        if (this.mode == PokeballManager.PokeballManagerMode.Player) {
            n.func_74778_a("originalTrainer", this.player.getDisplayName());
        }
        if (this.mode == PokeballManager.PokeballManagerMode.Trainer) {
            n.func_74778_a("originalTrainer", this.trainer.getName() + " " + this.trainer.getNickName());
        }
        if (p.func_70694_bm() != null) {
            n.func_74782_a("Held Item", (NBTBase)p.func_70694_bm().func_77955_b(new NBTTagCompound()));
        }
        n.func_74768_a("PixelmonOrder", this.getNextOpen());
        this.partyPokemon[this.getNextOpen()] = n;
        if (p.func_110143_aJ() > 0.0f) {
            n.func_74757_a("IsFainted", false);
        }
        if (this.mode == PokeballManager.PokeballManagerMode.Player) {
            Pixelmon.network.sendTo((IMessage)new Add(new PixelmonData(n)), this.player);
            EntityPlayerExtension.updatePlayerPokeballs(this.player, this.getPokeballList());
        }
    }

    public void retrieve(EntityPixelmon currentPixelmon) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound n = this.partyPokemon[i];
            if (n == null || !PixelmonMethods.isIDSame(n, currentPixelmon)) continue;
            currentPixelmon.func_70109_d(n);
            n.func_74757_a("IsInBall", true);
        }
    }

    public boolean contains(int[] id) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null || nbt.func_74762_e("pixelmonID1") != id[0] || nbt.func_74762_e("pixelmonID2") != id[1]) continue;
            return true;
        }
        return false;
    }

    public EntityPixelmon sendOut(int[] id, World world) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound n = this.partyPokemon[i];
            if (n == null || !PixelmonMethods.isIDSame(n, id)) continue;
            return this.sendOut(n, world);
        }
        return null;
    }

    private EntityPixelmon sendOut(NBTTagCompound n, World world) {
        n.func_74776_a("FallDistance", 0.0f);
        n.func_74768_a("Bukkit.MaxHealth", n.func_74762_e("StatsHP"));
        n.func_74757_a("IsInBall", false);
        EntityPixelmon e = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(n, world);
        if (this.mode == PokeballManager.PokeballManagerMode.Player) {
            e.func_152115_b(this.player.func_110124_au().toString());
            e.playerOwned = true;
        } else {
            e.setTrainer(this.trainer);
        }
        e.field_70179_y = 0.0;
        e.field_70181_x = 0.0;
        e.field_70159_w = 0.0;
        e.field_70128_L = false;
        e.setNumBreedingLevels(-1);
        return e;
    }

    public NBTTagCompound getNBT(int[] id) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, id)) continue;
            return nbt;
        }
        return null;
    }

    public NBTTagCompound[] getList() {
        return this.partyPokemon;
    }

    public void replace(EntityPixelmon entityPixelmon, EntityPixelmon entityCapturedPixelmon) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, entityPixelmon)) continue;
            entityCapturedPixelmon.setPokemonId(entityPixelmon.getPokemonId());
            entityCapturedPixelmon.func_70109_d(nbt);
            nbt.func_74778_a("id", entityCapturedPixelmon.getName());
            if (this.mode != PokeballManager.PokeballManagerMode.Player) continue;
            Pixelmon.network.sendTo((IMessage)new Add(new PixelmonData(nbt)), this.player);
            EntityPlayerExtension.updatePlayerPokeballs(this.player, this.getPokeballList());
        }
    }

    public void changePokemon(int pos, NBTTagCompound n) {
        if (n != null) {
            n.func_74768_a("PixelmonOrder", pos);
        }
        this.partyPokemon[pos] = n;
        if (this.mode == PokeballManager.PokeballManagerMode.Player) {
            EntityPlayerExtension.updatePlayerPokeballs(this.player, this.getPokeballList());
        }
    }

    public void changePokemonAndAssignID(int pos, NBTTagCompound n) {
        int[] id = new int[]{this.player.getDisplayName().hashCode(), this.idcounter++};
        if (this.partyPokemon[pos] != null) {
            int[] idpixel;
            if (n == null && this.EntityAlreadyExists(idpixel = PixelmonMethods.getID(this.partyPokemon[pos]), this.player.field_70170_p)) {
                EntityPixelmon p = this.getAlreadyExists(idpixel, this.player.field_70170_p);
                this.retrieve(p);
                this.updateNBT(p);
                p.isInBall = true;
                p.unloadEntity();
            }
            if (this.mode == PokeballManager.PokeballManagerMode.Player) {
                Pixelmon.network.sendTo((IMessage)new Remove(PixelmonMethods.getID(this.partyPokemon[pos])), this.player);
                EntityPlayerExtension.updatePlayerPokeballs(this.player, this.getPokeballList());
            }
        }
        if (n != null) {
            n.func_74768_a("pixelmonID1", id[0]);
            n.func_74768_a("pixelmonID2", id[1]);
        }
        this.changePokemon(pos, n);
        if (this.mode == PokeballManager.PokeballManagerMode.Player && n != null) {
            Pixelmon.network.sendTo((IMessage)new Add(new PixelmonData(n)), this.player);
            EntityPlayerExtension.updatePlayerPokeballs(this.player, this.getPokeballList());
        }
    }

    public void addToFirstEmptySpace(NBTTagCompound n) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            if (this.partyPokemon[i] != null) continue;
            if (n != null) {
                n.func_74768_a("PixelmonOrder", i);
                if (this.mode == PokeballManager.PokeballManagerMode.Player) {
                    Pixelmon.network.sendTo((IMessage)new Add(new PixelmonData(n)), this.player);
                }
            }
            this.partyPokemon[i] = n;
            if (this.mode == PokeballManager.PokeballManagerMode.Player) {
                EntityPlayerExtension.updatePlayerPokeballs(this.player, this.getPokeballList());
            }
            return;
        }
    }

    private int[] getPokeballList() {
        int[] balls = new int[6];
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            if (this.partyPokemon[i] != null) {
                if (this.partyPokemon[i].func_74767_n("isEgg")) {
                    balls[i] = -1;
                    continue;
                }
                balls[i] = this.partyPokemon[i].func_74762_e("CaughtBall");
                continue;
            }
            balls[i] = -1;
        }
        return balls;
    }

    public int count() {
        int count = 0;
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            if (this.partyPokemon[i] == null) continue;
            ++count;
        }
        return count;
    }

    public int countAblePokemon() {
        int c = 0;
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null || nbt.func_74767_n("IsFainted") || nbt.func_74767_n("isEgg") || nbt.func_74765_d("Health") <= 0) continue;
            ++c;
        }
        return c;
    }

    public boolean isIn(EntityPixelmon entityPixelmon) {
        return this.contains(entityPixelmon.getPokemonId());
    }

    public int getHighestLevel() {
        int lvl = -1;
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || nbt.func_74762_e("Level") <= lvl) continue;
            lvl = nbt.func_74762_e("Level");
        }
        return lvl;
    }

    public boolean hasSentOut(int[] pixelmonID) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, pixelmonID) || nbt.func_74767_n("IsInBall")) continue;
            return true;
        }
        return false;
    }

    public boolean isFainted(int[] id) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, id)) continue;
            if (nbt.func_74767_n("IsFainted")) {
                return true;
            }
            if (nbt.func_74765_d("Health") > 0) continue;
            return true;
        }
        return false;
    }

    public boolean isEgg(int[] id) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, id) || !nbt.func_74767_n("isEgg")) continue;
            return true;
        }
        return false;
    }

    private void updateNBT(EntityPixelmon pixelmon) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, pixelmon)) continue;
            pixelmon.func_70109_d(nbt);
            nbt.func_74778_a("id", pixelmon.getName());
            if (this.moves != null) {
                this.moves.refresh(nbt);
            }
            if (pixelmon.func_110143_aJ() <= 0.0f) {
                nbt.func_74757_a("IsFainted", true);
            }
            if (this.mode != PokeballManager.PokeballManagerMode.Player) continue;
            EntityPlayerExtension.updatePlayerPokeballs(this.player, this.getPokeballList());
        }
    }

    public void updateClient(NBTTagCompound nbt, EnumUpdateType type) {
        this.updateClient(nbt, new EnumUpdateType[]{type});
    }

    public void updateClient(NBTTagCompound nbt, EnumUpdateType[] types) {
        if (this.mode == PokeballManager.PokeballManagerMode.Player) {
            Pixelmon.network.sendTo((IMessage)new Update(new PixelmonUpdateData(nbt, types)), this.player);
        }
    }

    public void update(EntityPixelmon pixelmon, EnumUpdateType type) {
        this.updateAndSendToClient(pixelmon, new EnumUpdateType[]{type});
    }

    public void updateAndSendToClient(EntityPixelmon pixelmon, EnumUpdateType[] types) {
        this.updateNBT(pixelmon);
        if (this.mode == PokeballManager.PokeballManagerMode.Player) {
            Pixelmon.network.sendTo((IMessage)new Update(new PixelmonUpdateData(pixelmon, types)), this.player);
        }
    }

    public void sendUpdatedList() {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null || this.mode != PokeballManager.PokeballManagerMode.Player) continue;
            Pixelmon.network.sendTo((IMessage)new Add(new PixelmonData(nbt)), this.player);
        }
    }

    public int[] getIDFromPosition(int pos) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound n = this.partyPokemon[i];
            if (n == null || n.func_74762_e("PixelmonOrder") != pos) continue;
            return PixelmonMethods.getID(n);
        }
        return new int[]{-1, -1};
    }

    public boolean EntityAlreadyExists(int[] id, World world) {
        List EntityList2 = world.field_72996_f;
        for (int i = 0; i < EntityList2.size(); ++i) {
            Entity e = (Entity)EntityList2.get(i);
            if (!(e instanceof EntityPixelmon) || !PixelmonMethods.isIDSame(((EntityPixelmon)e).getPokemonId(), id)) continue;
            return true;
        }
        return false;
    }

    public boolean EntityAlreadyExists(EntityPixelmon pixelmon) {
        List EntityList2 = pixelmon.field_70170_p.field_72996_f;
        for (int i = 0; i < EntityList2.size(); ++i) {
            Entity e = (Entity)EntityList2.get(i);
            if (!(e instanceof EntityPixelmon) || !PixelmonMethods.isIDSame((EntityPixelmon)e, pixelmon)) continue;
            return true;
        }
        return false;
    }

    public EntityPixelmon getAlreadyExists(int[] id, World world) {
        if (id[0] == -1) {
            return null;
        }
        List EntityList2 = world.field_72996_f;
        for (int i = 0; i < EntityList2.size(); ++i) {
            Entity e = (Entity)EntityList2.get(i);
            if (!(e instanceof EntityPixelmon) || !PixelmonMethods.isIDSame(((EntityPixelmon)e).getPokemonId(), id)) continue;
            return (EntityPixelmon)e;
        }
        return null;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.playerData.writeToNBT(nbt);
        this.teleportPos.writeToNBT(nbt);
        nbt.func_74768_a("pixelDollars", this.pokeDollars);
        nbt.func_74768_a("idcounter", this.idcounter);
        nbt.func_74757_a("starterPicked", this.starterPicked);
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound e = this.partyPokemon[i];
            if (e == null) continue;
            int[] id = new int[]{e.func_74762_e("pixelmonID1"), e.func_74762_e("pixelmonID2")};
            if (this.EntityAlreadyExists(id, this.player != null ? this.player.field_70170_p : this.trainer.field_70170_p)) {
                EntityPixelmon pixelmon = this.getAlreadyExists(id, this.player != null ? this.player.field_70170_p : this.trainer.field_70170_p);
                this.updateNBT(pixelmon);
            }
            e.func_74768_a("PixelmonOrder", i);
            nbt.func_74782_a("party" + i, (NBTBase)e);
        }
        if (this.pokedex != null) {
            this.pokedex.writeToNBT(nbt);
        }
        if (this.stats != null) {
            this.stats.writeToNBT(nbt);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.playerData.readFromNBT(nbt);
        this.teleportPos.readFromNBT(nbt);
        this.pokeDollars = nbt.func_74762_e("pixelDollars");
        if (nbt.func_74764_b("idcounter")) {
            this.idcounter = nbt.func_74762_e("idcounter");
        }
        if (nbt.func_74764_b("starterPicked")) {
            this.starterPicked = nbt.func_74767_n("starterPicked");
        }
        for (int i = 0; i < 6; ++i) {
            NBTBase nbtbase;
            if (!nbt.func_74764_b("party" + i) || !((nbtbase = nbt.func_74781_a("party" + i)) instanceof NBTTagCompound)) continue;
            NBTTagCompound pokemonData = (NBTTagCompound)nbtbase;
            if (!pokemonData.func_74764_b("pixelmonID1")) {
                int[] id = this.mode == PokeballManager.PokeballManagerMode.Player ? new int[]{this.player.getDisplayName().hashCode(), this.idcounter++} : new int[]{(int)this.trainer.func_110124_au().getLeastSignificantBits(), this.idcounter++};
                pokemonData.func_74768_a("pixelmonID1", id[0]);
                pokemonData.func_74768_a("pixelmonID2", id[1]);
                pokemonData.func_82580_o("pixelmonID");
            }
            if (pokemonData.func_74764_b("HeldItem")) {
                if (pokemonData.func_74762_e("HeldItem") != -1) {
                    pokemonData.func_74782_a("HeldItemStack", (NBTBase)new ItemStack(Item.func_150899_d((int)pokemonData.func_74762_e("HeldItem")), 1).func_77955_b(new NBTTagCompound()));
                }
                pokemonData.func_82580_o("HeldItem");
            }
            this.partyPokemon[pokemonData.func_74762_e((String)"PixelmonOrder")] = pokemonData;
            if (this.mode != PokeballManager.PokeballManagerMode.Player) continue;
            Pixelmon.network.sendTo((IMessage)new Add(new PixelmonData(pokemonData)), this.player);
            EntityPlayerExtension.updatePlayerPokeballs(this.player, this.getPokeballList());
        }
        if (this.pokedex != null) {
            this.pokedex.readFromNBT(nbt);
        }
        if (this.stats != null) {
            this.stats.readFromNBT(nbt);
        }
    }

    public EntityPixelmon getFirstAblePokemon(World world) {
        for (int i = 0; i < 6; ++i) {
            int[] id = this.getIDFromPosition(i);
            if (id[0] == -1 || this.isFainted(id) || this.isEgg(id)) continue;
            return this.sendOut(id, world);
        }
        return null;
    }

    public int[] getFirstAblePokemonID(World worldObj) {
        for (int i = 0; i < 6; ++i) {
            int[] id = this.getIDFromPosition(i);
            if (id[0] == -1 || this.isFainted(id) || this.isEgg(id)) continue;
            return id;
        }
        return new int[]{-1, -1};
    }

    public void healAllPokemon() {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null) continue;
            this.heal(nbt);
        }
    }

    public EntityPixelmon sendOutFromPosition(int pos, World worldObj) {
        return this.sendOut(this.partyPokemon[pos], worldObj);
    }

    public void heal(int[] id) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, id)) continue;
            this.heal(nbt);
        }
    }

    private void heal(NBTTagCompound nbt) {
        nbt.func_74777_a("Health", (short)nbt.func_74762_e("StatsHP"));
        nbt.func_74776_a("HealF", (float)nbt.func_74762_e("StatsHP"));
        nbt.func_74757_a("IsFainted", false);
        int numMoves = nbt.func_74762_e("PixelmonNumberMoves");
        for (int i = 0; i < numMoves; ++i) {
            nbt.func_74768_a("PixelmonMovePP" + i, nbt.func_74762_e("PixelmonMovePPBase" + i));
        }
        int numStatus = nbt.func_74765_d("StatusCount");
        for (int i = 0; i < numStatus; ++i) {
            nbt.func_82580_o("Status" + i);
        }
        nbt.func_74777_a("StatusCount", (short)0);
        if (this.mode == PokeballManager.PokeballManagerMode.Player) {
            this.updateClient(nbt, new EnumUpdateType[]{EnumUpdateType.Status, EnumUpdateType.HP});
        }
    }

    public void recallAllPokemon() {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            int[] id;
            if (this.partyPokemon[i] == null || !this.EntityAlreadyExists(id = PixelmonMethods.getID(this.partyPokemon[i]), this.player.field_70170_p)) continue;
            EntityPixelmon p = this.getAlreadyExists(id, this.player.field_70170_p);
            this.retrieve(p);
            this.updateNBT(p);
            p.isInBall = true;
            p.unloadEntity();
        }
    }

    public int getPosition(int[] pokemonID) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound n = this.partyPokemon[i];
            if (n == null || !PixelmonMethods.isIDSame(n, pokemonID)) continue;
            return n.func_74762_e("PixelmonOrder");
        }
        return -1;
    }

    public int[] getNextPokemonId(int[] pokemonID) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, pokemonID) || nbt.func_74767_n("IsFainted") || nbt.func_74765_d("Health") < 0) continue;
            return PixelmonMethods.getID(nbt);
        }
        return new int[]{-1, -1};
    }

    public void setAllToLevel(int level) {
        this.recallAllPokemon();
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null) continue;
            EntityPixelmon p = this.sendOut(PixelmonMethods.getID(nbt), this.player.field_70170_p);
            p.getLvl().setLevel(level);
            p.update(EnumUpdateType.Stats);
            p.unloadEntity();
        }
    }

    public void setAllToLevelAndChooseMoveset(int level) {
        this.setAllToLevel(level);
        ArrayList<NBTTagCompound> pokemonList = new ArrayList<NBTTagCompound>();
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null) continue;
            pokemonList.add(nbt);
        }
        ChoosingMovesetData data = new ChoosingMovesetData(this.player, pokemonList);
        data.next();
        if (data.pokemonList.size() > 0) {
            ChooseMoveset.choosingMoveset.add(data);
        }
    }

    public Integer calculateHatchingBonus() {
        String[] hatchingBonusAbilities = new String[]{"Magma Armor", "Magma Armour", "Flame Body"};
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null || nbt.func_74767_n("isEgg")) continue;
            String ability = nbt.func_74779_i("Ability");
            for (String bonusAbility : hatchingBonusAbilities) {
                if (!ability.equalsIgnoreCase(bonusAbility)) continue;
                return 2;
            }
        }
        return 1;
    }

    public void checkEggStep() {
        ++this.ticksSinceEggStepCheck;
        if (this.ticksSinceEggStepCheck < 20) {
            return;
        }
        this.ticksSinceEggStepCheck = 0;
        if (!this.player.func_70115_ae() || this.player.func_70115_ae() && this.player.field_70154_o instanceof EntityPixelmon && this.player.field_70154_o.field_70154_o == null) {
            for (int i = 0; i < this.partyPokemon.length; ++i) {
                NBTTagCompound nbt = this.partyPokemon[i];
                if (nbt == null || !nbt.func_74767_n("isEgg")) continue;
                float changeX = Math.abs(nbt.func_74762_e("lastEggXCoord") - this.player.func_82114_b().field_71574_a);
                float changeZ = Math.abs(nbt.func_74762_e("lastEggZCoord") - this.player.func_82114_b().field_71573_c);
                if (!(changeX >= 2.0f) && !(changeZ >= 2.0f)) continue;
                nbt.func_74768_a("lastEggXCoord", this.player.func_82114_b().field_71574_a);
                nbt.func_74768_a("lastEggZCoord", this.player.func_82114_b().field_71573_c);
                nbt.func_74768_a("steps", nbt.func_74762_e("steps") + 2);
                if (nbt.func_74762_e("steps") > PixelmonConfig.stepsPerEggCycle) {
                    nbt.func_74768_a("eggCycles", nbt.func_74762_e("eggCycles") - this.calculateHatchingBonus());
                    if (nbt.func_74762_e("eggCycles") < 0) {
                        nbt.func_74778_a("originalTrainer", this.player.getDisplayName());
                        nbt.func_74757_a("isEgg", false);
                        String name = nbt.func_74779_i("Name").toLowerCase();
                        if (name.startsWith("a") || name.startsWith("e") || name.startsWith("i") || name.startsWith("o") || name.startsWith("u")) {
                            ChatHandler.sendFormattedChat((EntityPlayer)this.player, EnumChatFormatting.GREEN, "pixelmon.egg.hatchingan", nbt.func_74779_i("Name"));
                        } else {
                            ChatHandler.sendFormattedChat((EntityPlayer)this.player, EnumChatFormatting.GREEN, "pixelmon.egg.hatching", nbt.func_74779_i("Name"));
                        }
                        this.sendUpdatedList();
                    } else {
                        nbt.func_74768_a("steps", 0);
                    }
                }
                if (this.mode != PokeballManager.PokeballManagerMode.Player) continue;
                this.updateClient(nbt, EnumUpdateType.Egg);
                EntityPlayerExtension.updatePlayerPokeballs(this.player, this.getPokeballList());
            }
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        PixelmonStorage.PokeballManager.savePlayer(this);
    }

    public void loadNBTData(NBTTagCompound compound) {
    }

    public void init(Entity entity, World world) {
    }
}

