/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.StarterListPacket;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.StarterList;
import com.pixelmonmod.pixelmon.database.DatabaseStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PokeballManager {
    public static boolean disableStarterMenu = false;
    private File workingDir;

    public PlayerStorage getPlayerStorage(EntityPlayerMP player) throws PlayerNotLoadedException {
        if (player == null) {
            throw new PlayerNotLoadedException();
        }
        PlayerStorage storage = (PlayerStorage)player.getExtendedProperties("PixelmonPlayerStorage");
        if (storage == null) {
            storage = this.loadPlayer(player);
            player.registerExtendedProperties("PixelmonPlayerStorage", (IExtendedEntityProperties)storage);
        }
        return storage;
    }

    public PlayerStorage getPlayerStorageFromName(String name) throws PlayerNotLoadedException {
        return this.getPlayerStorage(this.getPlayerFromName(name));
    }

    public EntityPlayerMP getPlayerFromName(String name) {
        return MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(name);
    }

    public EntityPlayerMP getPlayerFromUUID(UUID uuid) {
        List list = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP p : list) {
            if (!p.func_110124_au().equals(uuid)) continue;
            return p;
        }
        return null;
    }

    public PlayerStorage getPlayerStorageFromUUID(UUID ownerUUID) throws PlayerNotLoadedException {
        return this.getPlayerStorage(this.getPlayerFromUUID(ownerUUID));
    }

    public PlayerStorage loadPlayer(EntityPlayerMP player) throws PlayerNotLoadedException {
        PlayerStorage p;
        File playerFile;
        if (player == null) {
            throw new PlayerNotLoadedException();
        }
        File saveDirPath = new File(this.getSaveFolder(player));
        if (!saveDirPath.exists()) {
            saveDirPath.mkdirs();
        }
        if ((playerFile = this.getSaveFile(player)).exists()) {
            p = new PlayerStorage(player);
            try {
                NBTTagCompound nbt = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(new FileInputStream(playerFile)));
                p.readFromNBT(nbt);
            }
            catch (FileNotFoundException e) {
                if (PixelmonConfig.printErrors) {
                    System.out.println("Couldn't read player data file for " + player.getDisplayName());
                }
                throw new PlayerNotLoadedException();
            }
            catch (IOException e) {
                if (PixelmonConfig.printErrors) {
                    System.out.println("Couldn't read player data file for " + player.getDisplayName());
                }
                throw new PlayerNotLoadedException();
            }
            catch (Exception e) {
                System.out.println("Error loading player: " + player.getDisplayName());
                e.printStackTrace();
            }
            if (p.count() == 0 && !disableStarterMenu && PixelmonConfig.giveStarter) {
                Pixelmon.network.sendTo((IMessage)new StarterListPacket(StarterList.StarterList), player);
            }
        } else {
            p = new PlayerStorage(player);
            if (!disableStarterMenu && PixelmonConfig.giveStarter) {
                Pixelmon.network.sendTo((IMessage)new StarterListPacket(StarterList.StarterList), player);
            }
        }
        return p;
    }

    private File getSaveFile(EntityPlayerMP player) {
        File playerFile = new File(this.getSaveFolder(player) + player.func_110124_au().toString() + ".pk");
        if (playerFile.exists()) {
            return playerFile;
        }
        if (new File(this.getSaveFolder(player) + player.getDisplayName() + ".pk").exists()) {
            new File(this.getSaveFolder(player) + player.getDisplayName() + ".pk").renameTo(playerFile);
            File tmpFile = new File(this.getSaveFolder(player) + player.getDisplayName() + ".pktemp");
            if (tmpFile.exists()) {
                tmpFile.renameTo(new File(this.getSaveFolder(player) + player.func_110124_au() + ".pktemp"));
            }
        }
        return playerFile;
    }

    public void savePlayer(PlayerStorage p) {
        try {
            String userName = p.userName;
            File playerSaveFile = new File(p.saveFile + "temp");
            NBTTagCompound nbt = new NBTTagCompound();
            p.writeToNBT(nbt);
            if (PixelmonConfig.saveToDatabase) {
                DatabaseStorage.writePlayerData(p.player.func_110124_au(), nbt);
            } else {
                FileOutputStream f = new FileOutputStream(playerSaveFile);
                DataOutputStream s = new DataOutputStream(f);
                CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)s);
                s.close();
                f.close();
                this.replaceSaveFile(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSaveFile(PlayerStorage playerStorage) throws IOException {
        File playerSaveTempFile = new File(playerStorage.saveFile + "temp");
        File playerSaveFile = new File(playerStorage.saveFile);
        if (!playerSaveFile.exists()) {
            playerSaveFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(playerSaveTempFile).getChannel();
            destination = new FileOutputStream(playerSaveFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private String getSaveFolder(EntityPlayerMP player) {
        if (MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().func_71262_S()) {
            return Pixelmon.modDirectory + "/" + MinecraftServer.func_71276_C().field_71305_c[0].func_72860_G().func_75760_g() + "/pokemon/";
        }
        return Pixelmon.modDirectory + "/saves/" + player.field_70170_p.func_72860_G().func_75760_g() + "/pokemon/";
    }

    public boolean hasPlayerFile(EntityPlayer player) {
        File playerSaveFile = new File(this.getSaveFolder((EntityPlayerMP)player) + ((EntityPlayerMP)player).func_110124_au() + ".pk");
        return playerSaveFile.exists();
    }

    public void onPlayerDC(EntityPlayerMP player) {
    }

    public void playerLoggedIn(EntityPlayerMP player) {
        if (player == null) {
            return;
        }
    }

    public static enum PokeballManagerMode {
        Player,
        Trainer;

    }
}

