/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.playerData;

import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.ExternalMoveBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.ExternalMoveRegistry;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.storage.playerData.ExternalMoveData;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;

public class ExternalMoves {
    private HashMap<Integer, ExternalMoveData[]> moves = new HashMap();
    private PlayerStorage storage;

    public ExternalMoves(PlayerStorage parent) {
        this.storage = parent;
    }

    public void refresh() {
        for (int i = 0; i < 6; ++i) {
            this.refresh(this.storage.partyPokemon[i]);
        }
    }

    public void refresh(NBTTagCompound nbt) {
        ArrayList<ExternalMoveData> pokeMoves = new ArrayList<ExternalMoveData>();
        int numMoves = nbt.func_74762_e("PixelmonNumberMoves");
        for (int i = 0; i < numMoves; ++i) {
            int id = nbt.func_74762_e("PixelmonMoveID" + i);
            ExternalMoveBase e = ExternalMoveRegistry.getExternalMove(id);
            if (e == null) continue;
            pokeMoves.add(new ExternalMoveData(i, e));
        }
        ExternalMoveData[] base = new ExternalMoveData[]{};
        this.moves.put(nbt.func_74762_e("pixelmonID2"), pokeMoves.toArray(base));
    }

    public static ExternalMoveBase[] load(PixelmonData pdata) {
        ArrayList<ExternalMoveBase> pokeMoves = new ArrayList<ExternalMoveBase>();
        int numMoves = pdata.numMoves;
        for (int i = 0; i < numMoves; ++i) {
            int id = pdata.moveset[i].attackIndex;
            ExternalMoveBase e = ExternalMoveRegistry.getExternalMove(id);
            if (e == null) continue;
            pokeMoves.add(e);
        }
        ExternalMoveBase[] base = new ExternalMoveBase[]{};
        return pokeMoves.toArray(base);
    }

    public ExternalMoveData get(int[] pokemonId, int moveIndex) {
        ExternalMoveData[] list = this.moves.get(pokemonId[1]);
        if (list != null && moveIndex >= 0 && moveIndex < list.length) {
            return list[moveIndex];
        }
        return null;
    }
}

