/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.playerData;

import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.storage.playerData.ISaveData;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerData
implements ISaveData {
    public static Item[] gemsList;
    public boolean[] gems = new boolean[17];
    private boolean gifted = false;
    public boolean giftOpened = false;

    public boolean registerGem(Item gem) {
        if (gemsList == null) {
            this.initGemsList();
        }
        for (int i = 0; i < this.gems.length; ++i) {
            if (this.gems[i] || gemsList[i] != gem) continue;
            this.gems[i] = true;
            return true;
        }
        return false;
    }

    public int getRegisteredCount() {
        int count = 0;
        for (int i = 0; i < this.gems.length; ++i) {
            if (!this.gems[i]) continue;
            ++count;
        }
        return count;
    }

    public void initGemsList() {
        gemsList = new Item[17];
        PlayerData.gemsList[0] = PixelmonItemsHeld.bugGem;
        PlayerData.gemsList[1] = PixelmonItemsHeld.darkGem;
        PlayerData.gemsList[2] = PixelmonItemsHeld.dragonGem;
        PlayerData.gemsList[3] = PixelmonItemsHeld.electricGem;
        PlayerData.gemsList[4] = PixelmonItemsHeld.fightingGem;
        PlayerData.gemsList[5] = PixelmonItemsHeld.fireGem;
        PlayerData.gemsList[6] = PixelmonItemsHeld.flyingGem;
        PlayerData.gemsList[7] = PixelmonItemsHeld.ghostGem;
        PlayerData.gemsList[8] = PixelmonItemsHeld.grassGem;
        PlayerData.gemsList[9] = PixelmonItemsHeld.groundGem;
        PlayerData.gemsList[10] = PixelmonItemsHeld.iceGem;
        PlayerData.gemsList[11] = PixelmonItemsHeld.normalGem;
        PlayerData.gemsList[12] = PixelmonItemsHeld.poisonGem;
        PlayerData.gemsList[13] = PixelmonItemsHeld.psychicGem;
        PlayerData.gemsList[14] = PixelmonItemsHeld.rockGem;
        PlayerData.gemsList[15] = PixelmonItemsHeld.steelGem;
        PlayerData.gemsList[16] = PixelmonItemsHeld.waterGem;
    }

    @Override
    public void writeToNBT(NBTTagCompound var1) {
        for (int i = 0; i < this.gems.length; ++i) {
            var1.func_74757_a("gem" + i, this.gems[i]);
        }
        var1.func_74757_a("gifted", this.gifted);
        var1.func_74757_a("giftOpened", this.giftOpened);
    }

    @Override
    public void readFromNBT(NBTTagCompound var1) {
        for (int i = 0; i < this.gems.length; ++i) {
            if (!var1.func_74764_b("gem" + i)) continue;
            this.gems[i] = var1.func_74767_n("gem" + i);
        }
        this.gifted = var1.func_74767_n("gifted");
        this.giftOpened = var1.func_74767_n("giftOpened");
    }

    public boolean finishedQuest() {
        if (gemsList == null) {
            this.initGemsList();
        }
        return this.getRegisteredCount() == gemsList.length;
    }

    public boolean getWasGifted() {
        return this.gifted;
    }

    public String[] getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        Calendar cal = Calendar.getInstance();
        String stime = dateFormat.format(cal.getTime());
        String[] elements = stime.split("/");
        return elements;
    }

    public void receivedGift() {
        this.gifted = true;
    }
}

