/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.structure;

import com.pixelmonmod.pixelmon.storage.structure.IStructureAwareness;
import com.pixelmonmod.pixelmon.storage.structure.StructureStorage;
import com.pixelmonmod.pixelmon.util.Array2D;
import com.pixelmonmod.pixelmon.worldGeneration.WorldGenMysteryDungeon;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.MysteryDungeonFloor;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class AwarenessMysteryDungeon
implements IStructureAwareness {
    private int[][] floorLayouts;
    private int floorCount;
    private int floorHeight;
    private int x;
    private int y;
    private int z;
    private int width;
    private int length;
    private boolean up;
    private boolean need2Saev;
    private static boolean update;
    private int ticks = 0;
    private int updateRate = 5;
    private int ID;
    public World worldObj;
    private StructureBoundingBox bounds;

    public AwarenessMysteryDungeon(World worldObj, WorldGenMysteryDungeon dungeon, int x, int y, int z) {
        this.floorCount = dungeon.numFloors;
        this.floorHeight = dungeon.floorHeight;
        this.worldObj = worldObj;
        this.need2Saev = true;
        this.floorLayouts = this.floorLayoutsFromFloors(dungeon.floors);
        this.ID = worldObj.func_72841_b("PixMysDun");
        this.x = x;
        this.y = y;
        this.z = z;
        this.initBounds(dungeon, x, y, z);
        StructureStorage.addStructure(this, worldObj);
    }

    private void initBounds(WorldGenMysteryDungeon dungeon, int x, int y, int z) {
        Array2D<Integer> floor = dungeon.floors[0].theMap;
        int minX = x + floor.minX();
        int minY = y + dungeon.builder.getMinY();
        int minZ = z + floor.minZ();
        int maxX = x + floor.maxX();
        int maxY = y + dungeon.builder.getMaxY() - 1;
        int maxZ = z + floor.maxZ();
        this.bounds = new StructureBoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public AwarenessMysteryDungeon() {
        this.need2Saev = false;
    }

    protected int[][] floorLayoutsFromFloors(MysteryDungeonFloor[] floors) {
        int[][] layouts = new int[floors.length][];
        for (int i = 0; i < floors.length; ++i) {
        }
        return layouts;
    }

    @Override
    public void setWorld(World w) {
        this.worldObj = w;
    }

    @Override
    public StructureBoundingBox[] getBounds() {
        return new StructureBoundingBox[]{this.bounds};
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public int floorCount() {
        return this.floorCount;
    }

    public int floorHeight() {
        return this.floorHeight;
    }

    public int getID() {
        return this.ID;
    }

    public int[][] getFloors() {
        return this.floorLayouts;
    }

    public int[] getFloor(int i) {
        return this.floorLayouts[i];
    }

    private void spawnPixelmon() {
    }

    @Override
    public void writeToNBT(NBTTagCompound dungeon) {
        dungeon.func_74768_a("FH", this.floorHeight);
        dungeon.func_74768_a("tx", this.ticks);
        dungeon.func_74768_a("rate", this.updateRate);
        dungeon.func_74768_a("X", this.x);
        dungeon.func_74768_a("Y", this.y);
        dungeon.func_74768_a("Z", this.z);
        dungeon.func_74768_a("W", this.width);
        dungeon.func_74768_a("L", this.length);
        dungeon.func_74757_a("U", this.up);
        dungeon.func_74768_a("ID", this.ID);
        dungeon.func_74782_a("BBX", (NBTBase)this.bounds.func_151535_h());
        NBTTagList floors = new NBTTagList();
        for (int i = 0; i < this.floorLayouts.length; ++i) {
            NBTTagCompound floor = new NBTTagCompound();
            floor.func_74768_a("I", i);
            floor.func_74783_a("F", this.floorLayouts[i]);
            floors.func_74742_a((NBTBase)floor);
        }
        dungeon.func_74782_a("FS", (NBTBase)floors);
    }

    @Override
    public void readFromNBT(NBTTagCompound dungeon) {
        this.floorHeight = dungeon.func_74762_e("FH");
        this.ticks = dungeon.func_74762_e("tx");
        this.updateRate = dungeon.func_74762_e("rate");
        this.x = dungeon.func_74762_e("X");
        this.y = dungeon.func_74762_e("Y");
        this.z = dungeon.func_74762_e("Z");
        this.width = dungeon.func_74762_e("W");
        this.length = dungeon.func_74762_e("L");
        this.up = dungeon.func_74767_n("U");
        this.ID = dungeon.func_74762_e("ID");
        this.bounds = new StructureBoundingBox(dungeon.func_74759_k("BBX"));
        NBTTagList floors = dungeon.func_150295_c("FS", 10);
        this.floorCount = floors.func_74745_c();
        this.floorLayouts = new int[this.floorCount][];
        for (int i = 0; i < this.floorCount; ++i) {
            NBTTagCompound floor = floors.func_150305_b(i);
            int floorIndex = floor.func_74762_e("I");
            this.floorLayouts[i] = floor.func_74759_k("F");
        }
    }

    @Override
    public boolean isDirty() {
        if (this.need2Saev) {
            this.need2Saev = false;
            return true;
        }
        return false;
    }

    public int visitingFloorLevel(Entity entity) {
        int i = (int)(entity.field_70163_u - (double)this.y);
        return (i /= this.floorHeight + 2) == this.floorCount ? this.floorCount - 1 : i;
    }
}

