/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.structure;

import com.google.common.collect.HashBiMap;
import com.pixelmonmod.pixelmon.storage.structure.AwarenessFogboundLake;
import com.pixelmonmod.pixelmon.storage.structure.AwarenessMysteryDungeon;
import com.pixelmonmod.pixelmon.storage.structure.IStructureAwareness;
import com.pixelmonmod.pixelmon.structure.generation.ComplexScattered;
import com.pixelmonmod.pixelmon.structure.generation.GeneralScattered;
import com.pixelmonmod.pixelmon.structure.generation.StructureScattered;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;
import com.pixelmonmod.pixelmon.util.testing.IDrawableGL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import org.lwjgl.opengl.GL11;

public class StructureStorage
extends WorldSavedData {
    private static final String ID = "Px_Sct";
    private static ArrayList<Map.Entry<World, StructureStorage>> awareni = new ArrayList();
    private static HashBiMap<Class<? extends IStructureAwareness>, String> namingMap = HashBiMap.create((int)1);
    private EntryList2D<HashSet<IStructureAwareness>> structuresInChunks = new EntryList2D();
    private HashMap<Class, ArrayList<Map.Entry<IStructureAwareness, NBTTagCompound>>> structures = new HashMap();
    private World worldObj;
    private NBTTagCompound masterNBT;
    private String uniqueID;
    public static boolean debugBounds = false;

    public StructureStorage(String name) {
        super(name);
    }

    public StructureStorage(World world) {
        super(ID);
        this.setWorld(world);
        this.masterNBT = new NBTTagCompound();
        this.uniqueID = ID + world.func_72841_b(ID);
        this.masterNBT.func_74778_a("UID", this.uniqueID);
    }

    private void setWorld(World world) {
        this.worldObj = world;
    }

    public static Class<? extends IStructureAwareness> getClassNamed(String name) {
        return (Class)namingMap.inverse().get((Object)name);
    }

    public static Class<? extends IStructureAwareness> demandClassNamed(String name) {
        Class<? extends IStructureAwareness> result = StructureStorage.getClassNamed(name);
        if (result == null) {
            throw new IllegalArgumentException("No such IStructureAwareness class is registered with the name \"" + name + "\"");
        }
        return result;
    }

    public static StructureStorage request(World world) {
        StructureStorage awareness = StructureStorage.getAwareness(world);
        if (awareness != null) {
            return awareness;
        }
        awareness = (StructureStorage)world.perWorldStorage.func_75742_a(StructureStorage.class, ID);
        if (awareness == null) {
            awareness = new StructureStorage(world);
            world.perWorldStorage.func_75745_a(ID, (WorldSavedData)awareness);
        } else {
            awareness.setWorld(world);
            awareness.func_76185_a();
        }
        awareni.add(new AbstractMap.SimpleEntry<World, StructureStorage>(world, awareness));
        return awareness;
    }

    public static void registerClass(Class<? extends IStructureAwareness> c, String nbtName) {
        if (namingMap.containsKey(c)) {
            throw new IllegalStateException("The class \"" + c.getName() + "\" is already registered with name \"" + (String)namingMap.get(c) + "\"");
        }
        if (namingMap.containsValue((Object)nbtName)) {
            throw new IllegalStateException("The name \"" + nbtName + "\" is already in use by \"" + ((Class)namingMap.inverse().get((Object)nbtName)).getName());
        }
        namingMap.put(c, (Object)nbtName);
    }

    public static void addStructure(IStructureAwareness s, World world) {
        if (namingMap.get(s.getClass()) == null) {
            throw StructureStorage.classNotRegistered(s);
        }
        StructureStorage awareness = StructureStorage.getAwareness(world);
        if (awareness != null) {
            awareness.addStructure(s);
        }
        StructureStorage.request(world).addStructure(s);
    }

    public void addStructureLayout(IStructureAwareness s) {
        StructureBoundingBox[] bboxes;
        for (StructureBoundingBox bbox : bboxes = s.getBounds()) {
            int x = bbox.field_78897_a >> 4;
            int z = bbox.field_78896_c >> 4;
            int w = (bbox.field_78893_d >> 4) - x;
            int l = (bbox.field_78892_f >> 4) - z;
            for (int i = 0; i <= w; ++i) {
                for (int j = 0; j <= l; ++j) {
                    HashSet<IStructureAwareness> structures = null;
                    structures = this.structuresInChunks.get(x + i, z + j);
                    if (structures == null) {
                        structures = new HashSet();
                        this.structuresInChunks.addValue(x + i, z + j, structures);
                    }
                    structures.add(s);
                }
            }
        }
    }

    public void addStructure(IStructureAwareness s) {
        this.addStructureImpl(s, s.getClass());
        if (s instanceof StructureScattered) {
            this.addStructureImpl(s, StructureScattered.class);
        }
    }

    private void addStructureImpl(IStructureAwareness s, Class<? extends IStructureAwareness> keyClass) {
        ArrayList<Map.Entry<IStructureAwareness, Object>> theList = this.structures.get(keyClass);
        if (theList == null) {
            theList = new ArrayList();
            this.structures.put(keyClass, theList);
        }
        if (!theList.contains(s)) {
            CommonHelper.insert(theList, new AbstractMap.SimpleEntry<IStructureAwareness, NBTTagCompound>(s, new NBTTagCompound()));
            this.addStructureLayout(s);
        }
    }

    private void loadStructure(IStructureAwareness s, NBTTagCompound nbt, int i) {
        this.loadStructureImpl(s, nbt, i, s.getClass());
        if (s instanceof StructureScattered) {
            this.loadStructureImpl(s, nbt, i, StructureScattered.class);
        }
    }

    private void loadStructureImpl(IStructureAwareness s, NBTTagCompound nbt, int i, Class<? extends IStructureAwareness> keyClass) {
        s.setWorld(this.worldObj);
        ArrayList<Map.Entry<IStructureAwareness, Object>> theList = this.structures.get(keyClass);
        if (theList == null) {
            theList = new ArrayList();
            this.structures.put(keyClass, theList);
        }
        CommonHelper.ensureIndex(theList, i);
        theList.set(i, new AbstractMap.SimpleEntry<IStructureAwareness, NBTTagCompound>(s, nbt));
        this.addStructureLayout(s);
    }

    public static StructureStorage getAwareness(World world) {
        for (Map.Entry<World, StructureStorage> e : awareni) {
            if (e.getKey() != world) continue;
            return e.getValue();
        }
        return null;
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        this.masterNBT = nbttagcompound.func_74775_l("SHINYZONES");
        this.uniqueID = this.masterNBT.func_74779_i("UID");
        Map nbtMap = CommonHelper.getMap(this.masterNBT);
        Set entrySet = nbtMap.entrySet();
        for (Map.Entry entry : entrySet) {
            try {
                String key = entry.getKey();
                if (key.equalsIgnoreCase("UID")) continue;
                int dotIndex = key.indexOf(".");
                int id = Integer.parseInt(key.substring(0, dotIndex));
                Class awarenessClass = (Class)namingMap.inverse().get((Object)key.substring(dotIndex + 1));
                IStructureAwareness struct = (IStructureAwareness)awarenessClass.newInstance();
                struct.readFromNBT((NBTTagCompound)entry.getValue());
                this.loadStructure(struct, (NBTTagCompound)entry.getValue(), id);
            }
            catch (Exception e) {
                System.err.println("Error reading NBT entry : " + entry);
                throw new RuntimeException(e);
            }
        }
    }

    public void func_76187_b(NBTTagCompound nbttagcompound) {
        for (Map.Entry<Class, ArrayList<Map.Entry<IStructureAwareness, NBTTagCompound>>> mapEntry : this.structures.entrySet()) {
            ArrayList<Map.Entry<IStructureAwareness, NBTTagCompound>> theList = mapEntry.getValue();
            for (int i = 0; i < theList.size(); ++i) {
                Map.Entry<IStructureAwareness, NBTTagCompound> listEntry = theList.get(i);
                if (listEntry == null) continue;
                IStructureAwareness struct = listEntry.getKey();
                if (struct.isDirty()) {
                    System.out.println("Saving " + struct.getClass() + "to NBT");
                    NBTTagCompound nbt = listEntry.getValue();
                    struct.writeToNBT(nbt);
                    String className = (String)namingMap.get(struct.getClass());
                    if (className == null) {
                        throw StructureStorage.classNotRegistered(struct);
                    }
                    String writeKey = i + "." + className;
                    this.masterNBT.func_74782_a(writeKey, (NBTBase)nbt);
                }
                nbttagcompound.func_74782_a("StructureStorage", (NBTBase)this.masterNBT);
            }
        }
    }

    public ArrayList<Map.Entry<IStructureAwareness, NBTTagCompound>> getStructures(Class<? extends IStructureAwareness> kind) {
        return this.structures.get(kind);
    }

    public static <T extends IStructureAwareness> T visitingStructure(World world, Entity entity, Class<T> structClass) {
        StructureStorage ma = StructureStorage.request(world);
        ArrayList<Map.Entry<IStructureAwareness, NBTTagCompound>> list = ma.getStructures(structClass);
        if (list == null) {
            return null;
        }
        for (Map.Entry<IStructureAwareness, NBTTagCompound> e : list) {
            for (StructureBoundingBox bbox : e.getKey().getBounds()) {
                if (!bbox.func_78890_b((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) continue;
                return (T)e.getKey();
            }
        }
        return null;
    }

    public static boolean canFitWithoutChunkOverlap(World world, StructureBoundingBox bbox, Class<? extends IStructureAwareness>[] avoidOnly) {
        return StructureStorage.request(world).canFitWithoutChunkOverlap(bbox, avoidOnly);
    }

    public static boolean canFitWithoutChunkOverlap(World world, StructureBoundingBox bbox) {
        return StructureStorage.canFitWithoutChunkOverlap(world, bbox, null);
    }

    public boolean canFitWithoutChunkOverlap(StructureBoundingBox bbox, Class<? extends IStructureAwareness>[] avoidOnly) {
        HashSet structuresInSameChunks = new HashSet();
        int x = bbox.field_78897_a >> 4;
        int z = bbox.field_78896_c >> 4;
        int w = (bbox.field_78893_d >> 4) - x;
        int l = (bbox.field_78892_f >> 4) - z;
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < l; ++j) {
                HashSet<IStructureAwareness> structuresAt = this.structuresInChunks.get(x + i, z + j);
                if (structuresAt != null && !structuresAt.isEmpty() && avoidOnly == null) {
                    return false;
                }
                if (structuresAt == null || avoidOnly == null) continue;
                for (IStructureAwareness struct : structuresAt) {
                    if (!CommonHelper.contains(avoidOnly, struct.getClass())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean canFitWithoutOverlap(World world, StructureBoundingBox bbox, Class<? extends IStructureAwareness>[] avoidOnly) {
        return StructureStorage.request(world).canFitWithoutOverlap(bbox, avoidOnly);
    }

    public static boolean canFitWithoutOverlap(World world, StructureBoundingBox bbox) {
        return StructureStorage.request(world).canFitWithoutOverlap(bbox, null);
    }

    public boolean canFitWithoutOverlap(StructureBoundingBox bbox) {
        return this.canFitWithoutOverlap(bbox, null);
    }

    public boolean canFitWithoutOverlap(StructureBoundingBox bbox, Class<? extends IStructureAwareness>[] avoidOnly) {
        HashSet<IStructureAwareness> structuresInSameChunks = new HashSet<IStructureAwareness>();
        int x = bbox.field_78897_a >> 4;
        int z = bbox.field_78896_c >> 4;
        int w = (bbox.field_78893_d >> 4) - x;
        int l = (bbox.field_78892_f >> 4) - z;
        for (int i = 0; i <= w; ++i) {
            for (int j = 0; j <= l; ++j) {
                HashSet<IStructureAwareness> structuresAt = this.structuresInChunks.get(x + i, z + j);
                if (structuresAt == null) continue;
                structuresInSameChunks.addAll(structuresAt);
            }
        }
        for (IStructureAwareness s : structuresInSameChunks) {
            if (avoidOnly != null && !CommonHelper.contains(avoidOnly, s.getClass())) continue;
            for (StructureBoundingBox bbox1 : s.getBounds()) {
                if (!bbox.func_78884_a(bbox1)) continue;
                return false;
            }
        }
        return true;
    }

    public static <T extends IStructureAwareness> boolean isSafeDistanceToNearest(World world, Class<T> type, int x, int y, int z, double distance, boolean evalCentered, boolean distX, boolean distY, boolean distZ) {
        return StructureStorage.request(world).isSafeDistanceToNearest(type, x, y, z, distance, evalCentered, distX, distY, distZ);
    }

    public <T extends IStructureAwareness> boolean isSafeDistanceToNearest(Class<T> type, int x, int y, int z, double distance, boolean evalCentered, boolean distX, boolean distY, boolean distZ) {
        ArrayList<Map.Entry<IStructureAwareness, NBTTagCompound>> structs = this.getStructures(type);
        if (structs == null || structs.isEmpty()) {
            return true;
        }
        for (Map.Entry<IStructureAwareness, NBTTagCompound> e : structs) {
            StructureBoundingBox[] bs;
            IStructureAwareness s = e.getKey();
            for (StructureBoundingBox b : bs = s.getBounds()) {
                int yDist;
                int xDist;
                int n = distX ? x - (evalCentered ? b.func_78881_e() : b.field_78897_a) : (xDist = 0);
                int n2 = distY ? y - (evalCentered ? b.func_78879_f() : b.field_78895_b) : (yDist = 0);
                int zDist = distZ ? z - (evalCentered ? b.func_78891_g() : b.field_78896_c) : 0;
                double structDist = GeometryHelper.dist(xDist, yDist, zDist);
                if (!(structDist < distance)) continue;
                return false;
            }
        }
        return true;
    }

    public static <T extends IStructureAwareness> boolean isSafeDistanceToNearestNamed(World world, String structureScatteredName, int x, int y, int z, double distance, boolean evalCentered, boolean distX, boolean distY, boolean distZ) {
        return StructureStorage.request(world).isSafeDistanceToNearestNamed(structureScatteredName, x, y, z, distance, evalCentered, distX, distY, distZ);
    }

    public boolean isSafeDistanceToNearestNamed(String structureScatteredName, int x, int y, int z, double distance, boolean evalCentered, boolean distX, boolean distY, boolean distZ) {
        ArrayList<Map.Entry<IStructureAwareness, NBTTagCompound>> structs = this.getStructures(StructureScattered.class);
        if (structs == null || structs.isEmpty()) {
            return true;
        }
        for (Map.Entry<IStructureAwareness, NBTTagCompound> e : structs) {
            StructureBoundingBox[] bs;
            StructureScattered s;
            if (e == null || !(s = (StructureScattered)e.getKey()).getName().equalsIgnoreCase(structureScatteredName)) continue;
            for (StructureBoundingBox b : bs = s.getBounds()) {
                int yDist;
                int xDist;
                int n = distX ? x - (evalCentered ? b.func_78881_e() : b.field_78897_a) : (xDist = 0);
                int n2 = distY ? y - (evalCentered ? b.func_78879_f() : b.field_78895_b) : (yDist = 0);
                int zDist = distZ ? z - (evalCentered ? b.func_78891_g() : b.field_78896_c) : 0;
                double structDist = GeometryHelper.dist(xDist, yDist, zDist);
                if (!(structDist < distance)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean func_76188_b() {
        return true;
    }

    private static RuntimeException classNotRegistered(IStructureAwareness s) {
        return new RuntimeException(String.format("The class \"" + s.getClass().getName() + "\" must be registered with a name via MasterAwareness.registerClass!", new Object[0]));
    }

    public void drawAllBBoxes() {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.0625f, (float)0.0625f, (float)0.0625f);
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        for (ArrayList<Map.Entry<IStructureAwareness, NBTTagCompound>> list : this.structures.values()) {
            for (Map.Entry<IStructureAwareness, NBTTagCompound> entry : list) {
                StructureBoundingBox[] bbxs;
                if (entry == null || entry.getKey() == null || (bbxs = entry.getKey().getBounds()) == null) continue;
                for (StructureBoundingBox bbx : bbxs) {
                    IDrawableGL.BoxMesh mesh = IDrawableGL.BoxMesh.get(bbx);
                    mesh.draw();
                }
            }
        }
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    static {
        StructureStorage.registerClass(AwarenessMysteryDungeon.class, "MysDun");
        StructureStorage.registerClass(AwarenessFogboundLake.class, "FBLake");
        StructureStorage.registerClass(ComplexScattered.class, "CplxStruc");
        StructureStorage.registerClass(GeneralScattered.class, "GnrlStruc");
    }
}

