/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure;

import com.pixelmonmod.pixelmon.blocks.BlockEntry;
import com.pixelmonmod.pixelmon.structure.StructureData;
import com.pixelmonmod.pixelmon.structure.StructureRegistry;
import com.pixelmonmod.pixelmon.structure.generation.SpecialParameters;
import com.pixelmonmod.pixelmon.structure.generation.specialgen.AbstractSpecialGen;
import java.io.InputStream;
import java.util.HashSet;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SchematicImporter {
    public StructureData creator;
    public String filename;
    public BlockEntry[][][] blockEntries;
    public NBTTagList tileEntities;
    public int width;
    public int height;
    public int length;
    public int offsetX = 0;
    public int offsetY = 0;
    public int offsetZ = 0;
    public HashSet<String> namedSpecialGens;

    public SchematicImporter(String filename) {
        this.filename = filename;
    }

    public SchematicImporter(String filename, StructureData creator) {
        this.filename = filename;
        this.creator = creator;
    }

    public void setOffset(int x, int y, int z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    public void readHeader() {
        NBTTagCompound n = this.getNBTTag();
        if (n == null) {
            return;
        }
        this.width = n.func_74765_d("Width");
        this.height = n.func_74765_d("Height");
        this.length = n.func_74765_d("Length");
    }

    public void readSchematic() {
        NBTTagCompound n = this.getNBTTag();
        if (n == null) {
            return;
        }
        this.width = n.func_74765_d("Width");
        this.height = n.func_74765_d("Height");
        this.length = n.func_74765_d("Length");
        byte[] blockArray = n.func_74770_j("Blocks");
        byte[] blockDataArray = n.func_74770_j("Data");
        this.tileEntities = n.func_150295_c("TileEntities", 10);
        this.blockEntries = new BlockEntry[this.width][this.height][this.length];
        int i = 0;
        boolean warningFlag = false;
        for (int y = 0; y < this.height; ++y) {
            for (int z = 0; z < this.length; ++z) {
                for (int x = 0; x < this.width; ++x) {
                    int id = blockArray[i] < 0 ? blockArray[i] + 256 : blockArray[i];
                    BlockEntry blockEntry = new BlockEntry(id, (int)blockDataArray[i]);
                    if (this.creator != null && this.creator.filter != null) {
                        this.creator.doFilter(blockEntry);
                    }
                    if (blockEntry.block == null) {
                        warningFlag = true;
                    }
                    this.blockEntries[x][y][z] = blockEntry;
                    ++i;
                }
            }
        }
        if (warningFlag) {
            System.out.println(String.format("WARNING! One of the block values in %s resolved to null.", this.filename));
        }
    }

    public void addSpecialGenName(String name) {
        if (this.namedSpecialGens == null) {
            this.namedSpecialGens = new HashSet();
        }
        this.namedSpecialGens.add(name);
    }

    public void verifyOkSpecialGens() {
        if (this.namedSpecialGens == null) {
            return;
        }
        for (String s : this.namedSpecialGens) {
            Object sp = this.creator.variables.get(s);
            if (sp == null) {
                throw new IllegalArgumentException(String.format("There is no such variable in %s named %s.", this.creator.path, s));
            }
            if (!(sp instanceof SpecialParameters)) {
                throw new IllegalArgumentException(String.format("The variable named %s in %s does not point to a Structure Modifier.", s, this.creator.path));
            }
            SpecialParameters spars = (SpecialParameters)sp;
            if (AbstractSpecialGen.class.isAssignableFrom(spars.modifierClass)) continue;
            throw new IllegalArgumentException(String.format("The variable named %s in %s point to parameters that do not reference a type of Special Generator.", s, this.creator.path));
        }
    }

    NBTTagCompound getNBTTag() {
        try {
            return CompressedStreamTools.func_74796_a((InputStream)StructureRegistry.class.getResourceAsStream(this.filename));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error loading Schematic: " + this.filename);
        }
    }
}

