/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure;

import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.blocks.BlockEntry;
import com.pixelmonmod.pixelmon.structure.SchematicImporter;
import com.pixelmonmod.pixelmon.structure.StructureRegistry;
import com.pixelmonmod.pixelmon.structure.filter.AbstractImportFilter;
import com.pixelmonmod.pixelmon.structure.filter.TileFilter;
import com.pixelmonmod.pixelmon.structure.filter.TileParameters;
import com.pixelmonmod.pixelmon.structure.generation.AbstractStructureModifier;
import com.pixelmonmod.pixelmon.structure.generation.ComplexScattered;
import com.pixelmonmod.pixelmon.structure.generation.GeneralScattered;
import com.pixelmonmod.pixelmon.structure.generation.SpecialParameters;
import com.pixelmonmod.pixelmon.structure.generation.StructureScattered;
import com.pixelmonmod.pixelmon.structure.generation.criteria.AbstractSpawnCriteria;
import com.pixelmonmod.pixelmon.structure.generation.groundhelper.AbstractGroundHelper;
import com.pixelmonmod.pixelmon.util.ConfigCategory;
import com.pixelmonmod.pixelmon.util.Property;
import com.pixelmonmod.pixelmon.util.SimpleConfig;
import com.pixelmonmod.pixelmon.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;

public class StructureData {
    private static final String GENERAL = "general";
    private static final String SWAPS = "swaps";
    private static final String STRUCTURES = "components";
    private static final String SPECIALS = "specials";
    private static final String BATTLE = "battle";
    private static final String SIMPLE_NAME = "name";
    private static final String BIOMES = "biomes";
    private static final String DEPTH = "depth";
    private static final String HASPOKEMON = "hasPokemon";
    private static final String COMPLEX = "complex";
    private static final String IMPORTFILTERS = "importFilters";
    private static final String TILEFILTERS = "tileFilters";
    private static final String NPARTICIPANTS = "participants";
    private static final String NPOKEMON = "pokemon";
    private static final String REGEX_VARNAME = ".*(\\[)(.*)(\\]).*";
    private static final String REGEX_MODCLASS = ".*(\\[.*\\]:*)(.*)";
    public SchematicImporter mainComponent;
    public ArrayList<SchematicImporter> components = new ArrayList();
    public ArrayList<AbstractImportFilter> importFilters = new ArrayList();
    public ArrayList<TileFilter> tileFilters = new ArrayList();
    public ArrayList<SpecialParameters> spawnCriteria;
    public HashMap<String, Object> variables = new HashMap();
    public HashMap<String, TileParameters> tileParams = new HashMap();
    public HashMap<Block, Block> filter;
    public BiomeGenBase[] biomes;
    public SpecialParameters groundHelper;
    public String simpleName = null;
    public String path;
    public int depth = 0;
    public boolean hasPokemon = false;
    public boolean complex = false;
    private SimpleConfig config;
    protected int numParticipants;
    protected int numPokemon;
    public ArrayList<double[]> participantPos;
    public ArrayList<double[]> pokemonPos;

    public StructureData(String filename, String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.path = path + filename + ".data";
        InputStream is = StructureData.class.getResourceAsStream(this.path);
        this.config = new SimpleConfig(is);
        this.init();
        if (this.mainComponent == null) {
            if (!this.components.isEmpty()) {
                throw new IllegalArgumentException("A Structure Data file containing any \"include\" commands must also name a \"main\" schematic!");
            }
            this.mainComponent = this.loadSchematic(filename);
        }
        this.mainComponent.readHeader();
        this.mainComponent.readSchematic();
        this.simpleName = filename;
        for (SchematicImporter schem : this.components) {
            schem.readHeader();
            schem.readSchematic();
            schem.verifyOkSpecialGens();
        }
    }

    private void init() {
        try {
            if (this.config.hasCategory(GENERAL)) {
                this.parseGeneral(this.config.getCategory(GENERAL));
            }
            if (this.config.hasCategory(SWAPS)) {
                this.parseSwaps(this.config.getCategory(SWAPS));
            }
            if (this.config.hasCategory(STRUCTURES)) {
                this.parseStructures(this.config.getCategory(STRUCTURES));
            }
            if (this.config.hasCategory(SPECIALS)) {
                this.parseSpecials(this.config.getCategory(SPECIALS));
            }
            if (this.config.hasCategory(BATTLE)) {
                this.parseBattle(this.config.getCategory(BATTLE));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void parseBattle(ConfigCategory battle) {
        int pos;
        int i;
        Property prop = null;
        prop = battle.get(NPARTICIPANTS);
        if (prop != null) {
            this.numParticipants = prop.getInt();
        }
        if ((prop = battle.get(NPOKEMON)) != null) {
            this.numPokemon = prop.getInt();
        }
        this.participantPos = new ArrayList();
        for (i = 0; i < this.numParticipants; ++i) {
            pos = i + 1;
            prop = battle.get("participantPos" + pos);
            if (prop == null) continue;
            this.participantPos.add(prop.getDoubleList());
        }
        this.pokemonPos = new ArrayList();
        for (i = 0; i < this.numPokemon; ++i) {
            pos = i + 1;
            prop = battle.get("pokemonPos" + pos);
            if (prop == null) continue;
            this.pokemonPos.add(prop.getDoubleList());
        }
    }

    private void parseGeneral(ConfigCategory general) {
        Property prop = null;
        prop = general.get(SIMPLE_NAME);
        if (prop != null) {
            this.simpleName = CommonHelper.textInQuotes(prop.getString());
        }
        if ((prop = general.get(BIOMES)) != null) {
            String[] stringArray;
            if (prop.isList()) {
                stringArray = prop.getStringList();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = prop.getString();
            }
            String[] biomeNames = stringArray;
            this.biomes = new BiomeGenBase[biomeNames.length];
            for (int i = 0; i < this.biomes.length; ++i) {
                this.biomes[i] = WorldHelper.demandBiome(CommonHelper.textInQuotes(biomeNames[i]));
            }
        }
        if ((prop = general.get(DEPTH)) != null) {
            this.depth = prop.getInt(0);
        }
        if ((prop = general.get(HASPOKEMON)) != null) {
            this.hasPokemon = prop.getBoolean(false);
        }
        if ((prop = general.get(COMPLEX)) != null) {
            this.complex = prop.getBoolean(false);
        }
    }

    private void parseSwaps(ConfigCategory swaps) {
        if (this.filter == null) {
            this.filter = new HashMap();
        }
        for (Map.Entry<String, Property> entry : swaps.entrySet()) {
            Block scan = BlockHelper.demandBlock(entry.getKey());
            Block place = BlockHelper.demandBlock(entry.getValue().getString());
            this.filter.put(scan, place);
        }
    }

    private void parseStructures(ConfigCategory structures) {
        for (Map.Entry<String, Property> entry : structures.entrySet()) {
            String[] parameters;
            String[] stringArray;
            String[] parts = entry.getKey().split(":");
            SchematicImporter schem = this.loadSchematic(parts[1]);
            Property prop = entry.getValue();
            if (prop.isList()) {
                stringArray = prop.getStringList();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = prop.getString();
            }
            for (String s : parameters = stringArray) {
                if ((s = CommonHelper.textInQuotes(s)).matches("<.*>")) {
                    s = s.replaceAll("(<)(.*)(>)", "$2").replaceAll("\\s+|,", " ");
                    String[] offsets = s.split(" ");
                    int xo = Integer.parseInt(offsets[0]);
                    int yo = Integer.parseInt(offsets[1]);
                    int zo = Integer.parseInt(offsets[2]);
                    schem.setOffset(xo, yo, zo);
                    continue;
                }
                if (!s.matches("\\[.*\\]")) continue;
                String specialGenName = s.replaceAll("(\\[)(.*)(\\])", "$2");
                schem.addSpecialGenName(specialGenName);
            }
            if (parts[0].equalsIgnoreCase("main")) {
                this.mainComponent = schem;
                continue;
            }
            if (!parts[0].equalsIgnoreCase("include")) continue;
            this.components.add(schem);
        }
    }

    private SchematicImporter loadSchematic(String fileName) {
        int lastSlash = this.path.lastIndexOf("/");
        String schematicPath = this.path.substring(0, lastSlash + 1) + fileName;
        if (!schematicPath.endsWith(".schematic")) {
            schematicPath = schematicPath + ".schematic";
        }
        return new SchematicImporter(schematicPath, this);
    }

    private void parseSpecials(ConfigCategory specials) {
        for (Map.Entry<String, Property> entry : specials.entrySet()) {
            String[] stringArray;
            String key;
            if (entry.getKey().equalsIgnoreCase(IMPORTFILTERS)) {
                String[] params;
                String[] stringArray2;
                Property prop = entry.getValue();
                if (prop.isList()) {
                    stringArray2 = prop.getStringList();
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray2 = stringArray3;
                    stringArray3[0] = prop.getString();
                }
                for (String param : params = stringArray2) {
                    this.importFilters.add(StructureRegistry.demandImportFilterByName(param));
                }
                continue;
            }
            if (entry.getKey().equalsIgnoreCase(TILEFILTERS)) {
                key = CommonHelper.textInQuotes(entry.getKey());
                Property prop = entry.getValue();
                if (prop.isList()) {
                    for (String param : prop.getStringList()) {
                        String[] splits = param.split(":", 2);
                        String name = splits[0].replace("[", "").replace("]", "").replace("\"", "");
                        TileParameters parameters = new TileParameters(name, new String[]{splits[1].replace("\"", "")});
                        this.tileFilters.add(TileParameters.createFilterFrom(parameters));
                        this.tileParams.put(key, parameters);
                    }
                }
                String name = key.matches(REGEX_VARNAME) ? key.replaceAll(REGEX_VARNAME, "$2") : null;
                String type = key.replaceAll(REGEX_MODCLASS, "$2");
                continue;
            }
            key = CommonHelper.textInQuotes(entry.getKey());
            String name = key.matches(REGEX_VARNAME) ? key.replaceAll(REGEX_VARNAME, "$2") : null;
            String type = key.replaceAll(REGEX_MODCLASS, "$2");
            Property prop = entry.getValue();
            if (prop.isList()) {
                stringArray = prop.getStringList();
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = prop.getString();
            }
            String[] params = stringArray;
            SpecialParameters parameters = new SpecialParameters(type, params);
            SpecialParameters.createModifierFrom(parameters);
            if (name != null && !name.isEmpty()) {
                this.variables.put(name, parameters);
            }
            if (AbstractSpawnCriteria.class.isAssignableFrom(parameters.modifierClass)) {
                if (this.spawnCriteria == null) {
                    this.spawnCriteria = new ArrayList();
                }
                this.spawnCriteria.add(parameters);
                continue;
            }
            if (!AbstractGroundHelper.class.isAssignableFrom(parameters.modifierClass)) continue;
            this.groundHelper = parameters;
        }
    }

    public void doFilter(BlockEntry blockEntry) {
        if (this.filter != null && this.filter.containsKey(blockEntry.block)) {
            blockEntry.block = this.filter.get(blockEntry.block);
        }
        for (AbstractImportFilter f : this.importFilters) {
            f.doFilter(blockEntry);
        }
    }

    public StructureScattered createStructure(Random random, int x, int y, int z, boolean doRotation, boolean forceGeneration) {
        if (!this.complex && this.components.isEmpty()) {
            return new GeneralScattered(random, x, y, z, this.mainComponent, this, doRotation, forceGeneration);
        }
        return new ComplexScattered(random, x, y, z, this, doRotation, forceGeneration);
    }

    public boolean hasModifierOfType(Class<? extends AbstractStructureModifier> clazz) {
        if (this.groundHelper != null && this.groundHelper.modifierClass == clazz) {
            return true;
        }
        if (this.spawnCriteria != null) {
            for (SpecialParameters criteria : this.spawnCriteria) {
                if (criteria.modifierClass != clazz) continue;
                return true;
            }
        }
        if (this.variables != null) {
            for (Object o : this.variables.values()) {
                if (!(o instanceof SpecialParameters)) continue;
                SpecialParameters sp = (SpecialParameters)o;
                if (sp.modifierClass != clazz) continue;
                return true;
            }
        }
        return false;
    }
}

